/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.capability;

import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.client.skinhandling.SkinChangingHandler;
import me.swirtzly.regeneration.client.skinhandling.SkinInfo;
import me.swirtzly.regeneration.common.capability.IRegenerationStateManager;
import me.swirtzly.regeneration.common.types.TypeHandler;
import me.swirtzly.regeneration.compat.lucraft.PlayerCanRegenEvent;
import me.swirtzly.regeneration.util.PlayerUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.eventhandler.Event;

public interface IRegeneration
extends INBTSerializable<NBTTagCompound> {
    public EntityPlayer getPlayer();

    public int getRegenerationsLeft();

    @Deprecated
    public void setRegenerationsLeft(int var1);

    public void triggerRegeneration();

    public void tick();

    public void synchronise();

    public NBTTagCompound getStyle();

    public void setStyle(NBTTagCompound var1);

    public Vec3d getPrimaryColor();

    public Vec3d getSecondaryColor();

    default public boolean canRegenerate() {
        return (RegenConfig.infiniteRegeneration || this.getRegenerationsLeft() > 0) && this.getPlayer().field_70163_u > 0.0 && !MinecraftForge.EVENT_BUS.post((Event)new PlayerCanRegenEvent(this.getPlayer()));
    }

    public void receiveRegenerations(int var1);

    public void extractRegeneration(int var1);

    public PlayerUtil.RegenState getState();

    public TypeHandler.RegenType getType();

    public void setType(TypeHandler.RegenType var1);

    public IRegenerationStateManager getStateManager();

    public String getEncodedSkin();

    public void setEncodedSkin(String var1);

    public SkinInfo.SkinType getSkinType();

    public void setSkinType(String var1);

    public SkinChangingHandler.EnumChoices getPreferredModel();

    public void setPreferredModel(String var1);

    public boolean areHandsGlowing();

    public String getDeathSource();

    public void setDeathSource(String var1);

    public ResourceLocation getDnaType();

    public void setDnaType(ResourceLocation var1);

    public boolean isDnaActive();

    public void setDnaActive(boolean var1);

    public int getAnimationTicks();

    public void setAnimationTicks(int var1);

    public void setSyncingFromJar(boolean var1);

    public boolean isSyncingToJar();

    public String getNextSkin();

    public void setNextSkin(String var1);

    public SkinInfo.SkinType getNextSkinType();

    public void setNextSkinType(SkinInfo.SkinType var1);

    public boolean hasDroppedHand();

    public void setDroppedHand(boolean var1);

    public EnumHandSide getCutoffHand();

    public void setCutOffHand(EnumHandSide var1);

    public float getProgress();

    public void setProgress(float var1);
}

