/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.commands;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.common.traits.DnaHandler;
import me.swirtzly.regeneration.util.PlayerUtil;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;

public class RegenDebugCommand
extends CommandBase {
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0 || args.length > 2) {
            throw new WrongUsageException("regeneration.commands.debug.usage", new Object[0]);
        }
        EntityPlayerMP player = RegenDebugCommand.func_71521_c((ICommandSender)sender);
        IRegeneration cap = CapabilityRegeneration.getForPlayer((EntityPlayer)player);
        switch (args[0]) {
            case "glow": {
                if (cap.getState().isGraceful()) {
                    cap.getStateManager().fastForwardHandGlow();
                    break;
                }
                throw new CommandException("regeneration.messages.cant_glow", new Object[0]);
            }
            case "fast-forward": {
                if (cap.getState() == PlayerUtil.RegenState.ALIVE) {
                    throw new CommandException("regeneration.messages.fast_forward_cmd_fail", new Object[0]);
                }
                cap.getStateManager().fastForward();
                break;
            }
            case "set-regens": {
                int amount;
                int n = amount = args.length > 1 ? RegenDebugCommand.func_180528_a((String)args[1], (int)0) : -1;
                if (amount >= 0) {
                    cap.setRegenerationsLeft(amount);
                    break;
                }
                RegenDebugCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)("Regenerations: " + cap.getRegenerationsLeft()), (Object[])new Object[0]);
                break;
            }
            case "set-trait": {
                if (DnaHandler.DNA_ENTRIES.containsKey(new ResourceLocation(args[1]))) {
                    DnaHandler.IDna trait = DnaHandler.DNA_ENTRIES.get(new ResourceLocation(args[1]));
                    DnaHandler.DNA_ENTRIES.get(cap.getDnaType()).onRemoved(cap);
                    trait.onAdded(cap);
                    cap.setDnaType(new ResourceLocation(args[1]));
                    PlayerUtil.sendMessage((EntityPlayer)player, new TextComponentTranslation(trait.getLangKey(), new Object[0]), true);
                    break;
                }
                throw new CommandException(args[1] + " is not a valid Trait!", new Object[0]);
            }
        }
        cap.synchronise();
    }

    public String func_71517_b() {
        return "regen";
    }

    public String func_71518_a(ICommandSender sender) {
        return "regeneration.commands.debug.usage";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length < 2) {
            return RegenDebugCommand.func_71530_a((String[])args, (String[])new String[]{"fast-forward", "set-regens", "glow", "set-trait"});
        }
        if (args[0].equals("set-trait") && args.length < 3) {
            return RegenDebugCommand.func_175762_a((String[])args, DnaHandler.DNA_ENTRIES.keySet());
        }
        return Collections.emptyList();
    }

    public int func_82362_a() {
        return 2;
    }
}

