/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.swirtzly.regeneration.common.item.arch.IDontStore;
import me.swirtzly.regeneration.common.item.arch.capability.CapabilityArch;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ItemArchInterface
extends Item
implements IDontStore {
    public ItemArchInterface() {
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        EntityEquipmentSlot entityequipmentslot = EntityLiving.func_184640_d((ItemStack)itemstack);
        ItemStack headSlot = playerIn.func_184582_a(entityequipmentslot);
        if (headSlot.func_190926_b()) {
            playerIn.func_184201_a(entityequipmentslot, itemstack.func_77946_l());
            itemstack.func_190920_e(0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound oldCapNbt) {
        return new InvProvider();
    }

    public static void sync(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            stack.func_77978_p().func_179237_a(stack.func_77973_b().getNBTShareTag(stack));
        }
    }

    public static void readSync(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            stack.func_77973_b().readNBTShareTag(stack, stack.func_77978_p());
        }
    }

    public boolean func_77651_p() {
        return super.func_77651_p();
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            tag.func_74782_a("arch_sync", CapabilityArch.getForStack(stack).serializeNBT());
            return tag;
        }
        return super.getNBTShareTag(stack);
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        super.readNBTShareTag(stack, nbt);
        if (nbt != null && stack != null && nbt.func_74764_b("cap_sync")) {
            CapabilityArch.getForStack(stack).deserializeNBT((NBTBase)((NBTTagCompound)nbt.func_74781_a("arch_sync")));
        }
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return super.onEntitySwing(entityLiving, stack);
    }

    @Nullable
    public EntityEquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EntityEquipmentSlot.HEAD;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new TextComponentTranslation("item.info.purpose", new Object[0]).func_150261_e());
        if (GuiInventory.func_146272_n()) {
            tooltip.add(new TextComponentTranslation("item.info.arch_power", new Object[0]).func_150261_e());
            tooltip.add(new TextComponentTranslation("item.info.arch_power2", new Object[0]).func_150261_e());
            tooltip.add(new TextComponentTranslation("item.info.arch_use", new Object[0]).func_150261_e());
        } else {
            tooltip.add(new TextComponentTranslation("item.info.shift", new Object[0]).func_150261_e());
        }
    }

    private static class InvProvider
    implements ICapabilitySerializable<NBTBase> {
        private final IItemHandler inv = new ItemStackHandler(1){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack toInsert, boolean simulate) {
                if (!toInsert.func_190926_b()) {
                    boolean isUseAble;
                    boolean bl = isUseAble = toInsert.hasCapability(CapabilityArch.CAPABILITY, null) && toInsert.func_190916_E() == 1;
                    if (isUseAble) {
                        return super.insertItem(slot, toInsert, simulate);
                    }
                }
                return toInsert;
            }
        };

        private InvProvider() {
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inv);
            }
            return null;
        }

        public NBTBase serializeNBT() {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.inv, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.inv, null, nbt);
        }
    }
}

