/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.item;

import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.RegenerationMod;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.common.entity.EntityItemOverride;
import me.swirtzly.regeneration.common.item.ItemOverrideBase;
import me.swirtzly.regeneration.common.item.arch.IDontStore;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.util.ClientUtil;
import me.swirtzly.regeneration.util.PlayerUtil;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ItemFobWatch
extends ItemOverrideBase
implements IDontStore {
    public ItemFobWatch() {
        this.func_77656_e(RegenConfig.regenCapacity);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("open"), (stack, worldIn, entityIn) -> {
            if (ItemFobWatch.getStackTag(stack) == null || !ItemFobWatch.getStackTag(stack).func_74764_b("open")) {
                return 0.0f;
            }
            return ItemFobWatch.getOpen(stack);
        });
        this.func_185043_a(new ResourceLocation("engrave"), (stack, worldIn, entityIn) -> {
            if (ItemFobWatch.getStackTag(stack) == null || !ItemFobWatch.getStackTag(stack).func_74764_b("engrave")) {
                return 0.0f;
            }
            return ItemFobWatch.getEngrave(stack);
        });
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public static int getEngrave(ItemStack stack) {
        return ItemFobWatch.getStackTag(stack).func_74762_e("engrave");
    }

    public static void setEngrave(ItemStack stack, int engrave) {
        ItemFobWatch.getStackTag(stack).func_74768_a("engrave", engrave);
    }

    public static NBTTagCompound getStackTag(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("open", 0);
            stack.func_77978_p().func_74768_a("engrave", field_77697_d.nextInt(2));
        }
        return stack.func_77978_p();
    }

    public static int getOpen(ItemStack stack) {
        return ItemFobWatch.getStackTag(stack).func_74762_e("open");
    }

    public static void setOpen(ItemStack stack, int amount) {
        ItemFobWatch.getStackTag(stack).func_74768_a("open", amount);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        if (RegenConfig.craftWithRegens) {
            stack.func_77964_b(0);
            ItemFobWatch.setEngrave(stack, worldIn.field_73012_v.nextInt(3));
            ItemFobWatch.setOpen(stack, 0);
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74757_a("live", false);
        } else {
            stack.func_77978_p().func_74757_a("live", false);
        }
        if (ItemFobWatch.getOpen(stack) == 1 && entityIn.field_70173_aa % 600 == 0) {
            ItemFobWatch.setOpen(stack, 0);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        IRegeneration cap = CapabilityRegeneration.getForPlayer(player);
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            if (stack.func_77952_i() == RegenConfig.regenCapacity) {
                return this.msgUsageFailed(player, "regeneration.messages.transfer.empty_watch", stack);
            }
            if (cap.getRegenerationsLeft() == RegenConfig.regenCapacity) {
                return this.msgUsageFailed(player, "regeneration.messages.transfer.max_regens", stack);
            }
            int supply = RegenConfig.regenCapacity - stack.func_77952_i();
            int needed = RegenConfig.regenCapacity - cap.getRegenerationsLeft();
            int used = Math.min(supply, needed);
            if (cap.canRegenerate()) {
                ItemFobWatch.setOpen(stack, 1);
                ClientUtil.createToast(new TextComponentTranslation("regeneration.messages.gained_regens", new Object[]{used}), new TextComponentTranslation("regeneration.toast.to_use", new Object[]{CapabilityRegeneration.getForPlayer(player).getRegenerationsLeft()}));
            } else if (!world.field_72995_K) {
                ItemFobWatch.setOpen(stack, 1);
            } else {
                ClientUtil.createToast(new TextComponentTranslation("regeneration.toast.timelord", new Object[0]), new TextComponentTranslation("regeneration.toast.to_use", new Object[]{CapabilityRegeneration.getForPlayer(player).getRegenerationsLeft()}));
            }
            if (used < 0) {
                RegenerationMod.LOG.warn(player.func_70005_c_() + ": Fob watch used <0 regens (supply: " + supply + ", needed:" + needed + ", used:" + used + ", capacity:" + RegenConfig.regenCapacity + ", damage:" + stack.func_77952_i() + ", regens:" + cap.getRegenerationsLeft());
            }
            if (!cap.getPlayer().func_184812_l_()) {
                stack.func_77964_b(stack.func_77952_i() + used);
            }
            if (world.field_72995_K) {
                ItemFobWatch.setOpen(stack, 1);
                ClientUtil.playPositionedSoundRecord(RegenObjects.Sounds.FOB_WATCH, 1.0f, 2.0f);
            } else {
                cap.receiveRegenerations(used);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (!cap.canRegenerate()) {
            return this.msgUsageFailed(player, "regeneration.messages.transfer.no_regens", stack);
        }
        if (cap.getState() != PlayerUtil.RegenState.ALIVE) {
            return this.msgUsageFailed(player, "regeneration.messages.not_alive", stack);
        }
        if (stack.func_77952_i() == 0) {
            return this.msgUsageFailed(player, "regeneration.messages.transfer.full_watch", stack);
        }
        stack.func_77964_b(stack.func_77952_i() - 1);
        PlayerUtil.sendMessage(player, "regeneration.messages.transfer.success", true);
        if (world.field_72995_K) {
            ClientUtil.playPositionedSoundRecord(SoundEvents.field_187646_bt, 5.0f, 2.0f);
        } else {
            ItemFobWatch.setOpen(stack, 1);
            cap.extractRegeneration(1);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private ActionResult<ItemStack> msgUsageFailed(EntityPlayer player, String message, ItemStack stack) {
        PlayerUtil.sendMessage(player, message, true);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    @Override
    public void update(EntityItemOverride itemOverride) {
        if (!itemOverride.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack itemStack = itemOverride.getItem();
        if (itemStack.func_77973_b() == this && itemStack.func_77952_i() != RegenConfig.regenCapacity && (itemOverride.field_70173_aa % 5000 == 0 || itemOverride.field_70173_aa == 2)) {
            ClientUtil.playSound((Object)itemOverride, RegenObjects.Sounds.FOB_WATCH_DIALOGUE.getRegistryName(), SoundCategory.AMBIENT, false, () -> itemOverride.field_70128_L, 1.5f);
        }
    }

    public boolean isRepairable() {
        return false;
    }
}

