/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.item;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import javax.annotation.Nullable;
import me.swirtzly.regeneration.client.skinhandling.SkinInfo;
import me.swirtzly.regeneration.common.traits.DnaHandler;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;

public class ItemHand
extends Item {
    public ItemHand() {
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("skin_type"), (stack, worldIn, entityIn) -> ItemHand.getSkinType(stack).equals("ALEX") ? 1.0f : 0.0f);
    }

    public static void setTimeCreated(ItemStack stack, long created) {
        ItemHand.getStackTag(stack).func_74772_a("created", created);
    }

    public static long getTimeCreated(ItemStack stack) {
        return ItemHand.getStackTag(stack).func_74763_f("created");
    }

    public static void setTextureString(ItemStack stack, String textureString) {
        ItemHand.getStackTag(stack).func_74778_a("textureString", textureString);
    }

    public static String getTextureString(ItemStack stack) {
        return ItemHand.getStackTag(stack).func_74779_i("textureString");
    }

    public static void setSkinType(ItemStack stack, String skinType) {
        ItemHand.getStackTag(stack).func_74778_a("skinType", skinType);
    }

    public static String getSkinType(ItemStack stack) {
        return ItemHand.getStackTag(stack).func_74779_i("skinType");
    }

    public static void setTrait(ItemStack stack, String trait) {
        ItemHand.getStackTag(stack).func_74778_a("trait", trait);
    }

    public static String getTrait(ItemStack stack) {
        return ItemHand.getStackTag(stack).func_74779_i("trait");
    }

    public static void setOwner(ItemStack stack, UUID owner) {
        ItemHand.getStackTag(stack).func_186854_a("owner", owner);
    }

    public static UUID getOwner(ItemStack stack) {
        return ItemHand.getStackTag(stack).func_186857_a("owner");
    }

    public static NBTTagCompound getStackTag(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74778_a("textureString", "NONE");
            stack.func_77978_p().func_74778_a("skinType", SkinInfo.SkinType.ALEX.name());
            stack.func_77978_p().func_186854_a("owner", UUID.fromString("96511168-1bb3-4ff0-a894-271e42606a39"));
            stack.func_77978_p().func_74772_a("created", 0L);
            stack.func_77978_p().func_74778_a("trait", DnaHandler.DNA_BORING.resourceLocation.toString());
        }
        return stack.func_77978_p();
    }

    public String func_77653_i(ItemStack stack) {
        return new TextComponentTranslation("item.hand.name", new Object[]{UsernameCache.getLastKnownUsername((UUID)ItemHand.getOwner(stack))}).func_150261_e();
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Date date = new Date(ItemHand.getTimeCreated(stack));
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/YYYY @ HH:mm");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String dateFormatted = formatter.format(date);
        tooltip.add(new TextComponentTranslation("nbt.created", new Object[]{dateFormatted}).func_150261_e());
        tooltip.add("Trait: " + new TextComponentTranslation(DnaHandler.getDnaEntry(new ResourceLocation(ItemHand.getTrait(stack))).getLangKey(), new Object[0]).func_150261_e());
    }
}

