/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.item;

import java.util.List;
import javax.annotation.Nullable;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.common.advancements.RegenTriggers;
import me.swirtzly.regeneration.common.block.BlockHandInJar;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.common.entity.EntityItemOverride;
import me.swirtzly.regeneration.common.item.ItemOverrideBase;
import me.swirtzly.regeneration.common.item.arch.IDontStore;
import me.swirtzly.regeneration.common.tiles.TileEntityHandInJar;
import me.swirtzly.regeneration.util.PlayerUtil;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLindos
extends ItemOverrideBase
implements IDontStore {
    public ItemLindos() {
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("amount"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (stack.func_77978_p() != null) {
                    int amount = ItemLindos.getAmount(stack);
                    if (!ItemLindos.hasWater(stack)) {
                        return 0.0f;
                    }
                    if (ItemLindos.hasWater(stack) && ItemLindos.getAmount(stack) <= 0) {
                        return 2.0f;
                    }
                    if (amount == 100) {
                        return 1.0f;
                    }
                    if (amount >= 90) {
                        return 0.2f;
                    }
                    if (amount >= 50) {
                        return 0.5f;
                    }
                    if (amount >= 10) {
                        return 0.1f;
                    }
                }
                return 2.0f;
            }
        });
    }

    public static NBTTagCompound getStackTag(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("amount", 0);
        }
        return stack.func_77978_p();
    }

    public static int getAmount(ItemStack stack) {
        return ItemLindos.getStackTag(stack).func_74762_e("amount");
    }

    public static void setAmount(ItemStack stack, int amount) {
        ItemLindos.getStackTag(stack).func_74768_a("amount", MathHelper.func_76125_a((int)amount, (int)0, (int)100));
    }

    public static boolean hasWater(ItemStack stack) {
        return ItemLindos.getStackTag(stack).func_74767_n("water");
    }

    public static void setWater(ItemStack stack, boolean water) {
        ItemLindos.getStackTag(stack).func_74757_a("water", water);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        if (!playerIn.field_70170_p.field_72995_K) {
            RegenTriggers.LINDOS_VIAL.trigger((EntityPlayerMP)playerIn);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return stack;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        IRegeneration cap = CapabilityRegeneration.getForPlayer(player);
        if (!worldIn.field_72995_K) {
            if (ItemLindos.getAmount(stack) > 100 && ItemLindos.hasWater(stack) && (cap.getState() == PlayerUtil.RegenState.POST || cap.getState() == PlayerUtil.RegenState.REGENERATING || player.func_184812_l_())) {
                PlayerUtil.sendMessage(player, new TextComponentTranslation("regeneration.messages.cannot_use", new Object[0]), true);
                return stack;
            }
            if (ItemLindos.hasWater(stack)) {
                if (ItemLindos.getAmount(stack) == 100) {
                    if (cap.getRegenerationsLeft() <= RegenConfig.regenCapacity) {
                        cap.receiveRegenerations(1);
                        PlayerUtil.sendMessage(player, new TextComponentTranslation("regeneration.messages.jar", new Object[0]), true);
                    } else {
                        PlayerUtil.sendMessage(player, new TextComponentTranslation("regeneration.messages.transfer.max_regens", new Object[0]), true);
                    }
                    ItemLindos.setAmount(stack, 0);
                    ItemLindos.setWater(stack, false);
                    return stack;
                }
                PlayerUtil.sendMessage(player, new TextComponentTranslation("regeneration.messages.empty_vial", new Object[0]), true);
                return stack;
            }
            PlayerUtil.sendMessage(player, new TextComponentTranslation("regeneration.messages.no_water", new Object[0]), true);
            return stack;
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74757_a("live", true);
        } else {
            stack.func_77978_p().func_74757_a("live", true);
        }
        if (!worldIn.field_72995_K) {
            EntityPlayer player2;
            worldIn.func_72872_a(EntityPlayer.class, entityIn.func_174813_aQ().func_72321_a(10.0, 10.0, 10.0)).forEach(player -> {
                IRegeneration data = CapabilityRegeneration.getForPlayer((EntityPlayer)entityIn);
                if (data.getState() == PlayerUtil.RegenState.REGENERATING && ItemLindos.hasWater(stack) && worldIn.field_73012_v.nextInt(100) > 70 && PlayerUtil.isInEitherHand((EntityLivingBase)player, this)) {
                    ItemLindos.setAmount(stack, ItemLindos.getAmount(stack) + 1);
                }
            });
            if (entityIn instanceof EntityPlayer && PlayerUtil.isInEitherHand((EntityLivingBase)(player2 = (EntityPlayer)entityIn), this) && ItemLindos.hasWater(stack) && CapabilityRegeneration.getForPlayer(player2).areHandsGlowing() && player2.field_70173_aa % 100 == 0) {
                ItemLindos.setAmount(stack, ItemLindos.getAmount(stack) + 2);
            }
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            ItemStack itemStack = player.func_184586_b(hand);
            RayTraceResult raytraceresult = this.func_77621_a(worldIn, player, true);
            if (raytraceresult == null || raytraceresult.func_178782_a() == null) {
                return EnumActionResult.FAIL;
            }
            BlockPos blockPos = raytraceresult.func_178782_a();
            IBlockState iblockstate = worldIn.func_180495_p(blockPos);
            Material material = iblockstate.func_185904_a();
            if (iblockstate.func_177230_c() instanceof BlockHandInJar && player.func_70093_af()) {
                if (worldIn.func_175625_s(blockPos) instanceof TileEntityHandInJar) {
                    TileEntityHandInJar jar = (TileEntityHandInJar)worldIn.func_175625_s(blockPos);
                    int has = ItemLindos.getAmount(itemStack);
                    int needs = 100 - has;
                    if (jar.getLindosAmont() >= needs) {
                        jar.setLindosAmont(jar.getLindosAmont() - needs);
                        ItemLindos.setAmount(itemStack, ItemLindos.getAmount(itemStack) + needs);
                    }
                }
                return EnumActionResult.SUCCESS;
            }
            if (material == Material.field_151586_h) {
                if (!ItemLindos.hasWater(itemStack)) {
                    worldIn.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 11);
                    player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                    ItemLindos.setWater(itemStack, true);
                    PlayerUtil.sendMessage(player, new TextComponentTranslation("nbt.item.water_filled", new Object[0]), true);
                } else {
                    PlayerUtil.sendMessage(player, new TextComponentTranslation("nbt.item.water_already_filled", new Object[0]), true);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (CapabilityRegeneration.getForPlayer(playerIn).getState() == PlayerUtil.RegenState.ALIVE) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new TextComponentTranslation("nbt.item.lindos", new Object[]{ItemLindos.getAmount(stack)}).func_150260_c());
        tooltip.add(new TextComponentTranslation("nbt.item.water", new Object[]{ItemLindos.hasWater(stack)}).func_150260_c());
    }

    @Override
    public void update(EntityItemOverride itemOverride) {
        if (itemOverride.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack itemStack = itemOverride.getItem();
        if (itemStack.func_77973_b() == this && itemOverride.func_70090_H() && itemStack.func_77978_p() != null) {
            ItemLindos.setWater(itemStack, true);
        }
    }
}

