/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.item.arch;

import me.swirtzly.regeneration.client.skinhandling.SkinChangingHandler;
import me.swirtzly.regeneration.client.skinhandling.SkinInfo;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.common.item.ItemArchInterface;
import me.swirtzly.regeneration.common.item.arch.IDontStore;
import me.swirtzly.regeneration.common.item.arch.capability.ArchProvider;
import me.swirtzly.regeneration.common.item.arch.capability.CapabilityArch;
import me.swirtzly.regeneration.common.item.arch.capability.IArch;
import me.swirtzly.regeneration.common.traits.DnaHandler;
import me.swirtzly.regeneration.network.MessageRemovePlayer;
import me.swirtzly.regeneration.network.NetworkHandler;
import me.swirtzly.regeneration.util.PlayerUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber
public class ArchHelper {
    @SubscribeEvent
    public static void onItemCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() instanceof ItemBlock || ((ItemStack)event.getObject()).func_77973_b() instanceof IDontStore) {
            return;
        }
        event.addCapability(CapabilityArch.ARCH_ID, (ICapabilityProvider)new ArchProvider(new CapabilityArch((ItemStack)event.getObject())));
    }

    public static void onArchUse(EntityPlayer player) {
        boolean isSafe;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack headSlot = player.func_184582_a(EntityEquipmentSlot.HEAD);
        IItemHandler invData = (IItemHandler)headSlot.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        ItemStack stack = invData.getStackInSlot(0);
        if (!stack.hasCapability(CapabilityArch.CAPABILITY, null)) {
            return;
        }
        IRegeneration playerData = CapabilityRegeneration.getForPlayer(player);
        boolean bl = isSafe = playerData.getState() == PlayerUtil.RegenState.ALIVE && player.field_70170_p.func_175640_z(player.func_180425_c());
        if (isSafe) {
            IArch stackData = CapabilityArch.getForStack(stack);
            if (stackData.getArchStatus() == IArch.ArchStatus.NORMAL_ITEM) {
                stackData.setRegenAmount(playerData.getRegenerationsLeft());
                stackData.setSavedTrait(playerData.getDnaType());
                stackData.setArchStatus(IArch.ArchStatus.ARCH_ITEM);
                stackData.setSkinType(playerData.getSkinType());
                stackData.setSkin(playerData.getEncodedSkin());
                ItemArchInterface.sync(stack);
                playerData.setDnaType(DnaHandler.DNA_BORING.getRegistryName());
                playerData.extractRegeneration(playerData.getRegenerationsLeft());
                playerData.setEncodedSkin("NONE");
                NetworkHandler.INSTANCE.sendToAll((IMessage)new MessageRemovePlayer(player.func_110124_au()));
                boolean isAlex = SkinChangingHandler.getSkinType(player, true).getMojangType().equals("slim");
                playerData.setSkinType(isAlex ? SkinInfo.SkinType.ALEX.name() : SkinInfo.SkinType.STEVE.name());
                playerData.synchronise();
                InventoryHelper.func_180173_a((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)stack.func_77946_l());
                stack.func_190920_e(0);
                return;
            }
            if (stackData.getArchStatus() == IArch.ArchStatus.ARCH_ITEM && playerData.getRegenerationsLeft() == 0) {
                playerData.receiveRegenerations(stackData.getRegenAmount());
                playerData.setDnaType(stackData.getSavedTrait());
                playerData.setEncodedSkin(stackData.getSkin());
                playerData.setSkinType(stackData.getSkinType().name());
                playerData.synchronise();
                NetworkHandler.INSTANCE.sendToAll((IMessage)new MessageRemovePlayer(player.func_110124_au()));
                stackData.setArchStatus(IArch.ArchStatus.NORMAL_ITEM);
                stackData.setRegenAmount(0);
                stackData.setSavedTrait(DnaHandler.DNA_BORING.getRegistryName());
                ItemArchInterface.sync(stack);
                InventoryHelper.func_180173_a((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)stack.func_77946_l());
                stack.func_190920_e(0);
                return;
            }
        } else {
            PlayerUtil.sendMessage(player, new TextComponentTranslation("regeneration.messages.arch_fail", new Object[0]), true);
        }
    }
}

