/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.item.arch.capability;

import javax.annotation.Nonnull;
import me.swirtzly.regeneration.client.skinhandling.SkinInfo;
import me.swirtzly.regeneration.common.item.arch.capability.IArch;
import me.swirtzly.regeneration.common.traits.DnaHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class CapabilityArch
implements IArch {
    @CapabilityInject(value=IArch.class)
    public static final Capability<IArch> CAPABILITY = null;
    public static final ResourceLocation ARCH_ID = new ResourceLocation("regeneration", "arch");
    private final ItemStack itemStack;
    private IArch.ArchStatus archStatus = IArch.ArchStatus.NORMAL_ITEM;
    private int regenAmount = 0;
    private ResourceLocation savedTrait = DnaHandler.DNA_BORING.getRegistryName();
    private String encoded = "NONE";
    private SkinInfo.SkinType skinType = SkinInfo.SkinType.STEVE;

    public CapabilityArch() {
        this.itemStack = null;
    }

    public CapabilityArch(ItemStack stack) {
        this.itemStack = stack;
    }

    @Nonnull
    public static IArch getForStack(ItemStack stack) {
        if (stack.hasCapability(CAPABILITY, null)) {
            return (IArch)stack.getCapability(CAPABILITY, null);
        }
        throw new IllegalStateException("Missing Arch capability: " + stack + " , please report this to the issue tracker");
    }

    @Override
    public int getRegenAmount() {
        return this.regenAmount;
    }

    @Override
    public void setRegenAmount(int regenAmount) {
        this.regenAmount = regenAmount;
    }

    @Override
    public ResourceLocation getSavedTrait() {
        return this.savedTrait;
    }

    @Override
    public void setSavedTrait(ResourceLocation savedTrait) {
        this.savedTrait = savedTrait;
    }

    @Override
    public IArch.ArchStatus getArchStatus() {
        return this.archStatus;
    }

    @Override
    public void setArchStatus(IArch.ArchStatus status) {
        this.archStatus = status;
    }

    @Override
    public void setSkinType(SkinInfo.SkinType skinType) {
        this.skinType = skinType;
    }

    @Override
    public SkinInfo.SkinType getSkinType() {
        return this.skinType;
    }

    @Override
    public void setSkin(String encoded) {
        this.encoded = encoded;
    }

    @Override
    public String getSkin() {
        return this.encoded;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("regenAmount", this.regenAmount);
        if (this.savedTrait != null) {
            nbt.func_74778_a("trait", this.savedTrait.toString());
        }
        if (this.archStatus == null) {
            this.archStatus = IArch.ArchStatus.NORMAL_ITEM;
        } else {
            nbt.func_74778_a("arch_status", this.archStatus.name());
        }
        if (this.skinType == null) {
            this.skinType = SkinInfo.SkinType.STEVE;
        } else {
            nbt.func_74778_a("skinType", this.skinType.name());
        }
        if (this.encoded == null) {
            this.encoded = "NONE";
        } else {
            nbt.func_74778_a("skin", this.encoded);
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.regenAmount = nbt.func_74762_e("regenAmount");
        this.savedTrait = new ResourceLocation(nbt.func_74779_i("trait"));
        this.archStatus = nbt.func_74764_b("arch_status") ? IArch.ArchStatus.valueOf(nbt.func_74779_i("arch_status")) : IArch.ArchStatus.NORMAL_ITEM;
        this.skinType = nbt.func_74764_b("skinType") ? SkinInfo.SkinType.valueOf(nbt.func_74779_i("skinType")) : SkinInfo.SkinType.ALEX;
        this.encoded = nbt.func_74764_b("skin") ? nbt.func_74779_i("skin") : "NONE";
    }
}

