/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.traits;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.common.traits.negative.DnaHunger;
import me.swirtzly.regeneration.common.traits.negative.DnaHydrophobic;
import me.swirtzly.regeneration.common.traits.positive.DnaAthlete;
import me.swirtzly.regeneration.common.traits.positive.DnaFireResistant;
import me.swirtzly.regeneration.common.traits.positive.DnaLucky;
import me.swirtzly.regeneration.common.traits.positive.DnaNightvision;
import me.swirtzly.regeneration.common.traits.positive.DnaSimple;
import me.swirtzly.regeneration.common.traits.positive.DnaSwimmer;
import me.swirtzly.regeneration.common.traits.positive.DnaTough;
import me.swirtzly.regeneration.common.traits.positive.DnaWallClimbing;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class DnaHandler {
    public static IDna DNA_ATHLETE = new DnaAthlete();
    public static IDna DNA_BORING = new DnaSimple("boring");
    public static IDna DNA_DUMB = new DnaSimple("dumb");
    public static IDna DNA_TOUGH = new DnaTough();
    public static IDna DNA_LUCKY = new DnaLucky();
    public static IDna DNA_SWIMMER = new DnaSwimmer();
    public static IDna DNA_SCARED_OF_WATER = new DnaHydrophobic();
    public static IDna DNA_FIRE_RESISTANT = new DnaFireResistant();
    public static IDna DNA_HUNGER = new DnaHunger();
    public static IDna DNA_NIGHTVISION = new DnaNightvision();
    public static IDna DNA_WALLCLIMB = new DnaWallClimbing();
    public static IDna DNA_REPEL_ARROW = new DnaSimple("repel_arrow");
    public static HashMap<ResourceLocation, IDna> DNA_ENTRIES = new HashMap();
    private static ArrayList<IDna> DNA_LIST = new ArrayList();

    public static void init() {
        DnaHandler.register(DNA_ATHLETE);
        DnaHandler.register(DNA_BORING);
        DnaHandler.register(DNA_DUMB);
        DnaHandler.register(DNA_TOUGH);
        DnaHandler.register(DNA_LUCKY);
        DnaHandler.register(DNA_SWIMMER);
        DnaHandler.register(DNA_SCARED_OF_WATER);
        DnaHandler.register(DNA_FIRE_RESISTANT);
        DnaHandler.register(DNA_HUNGER);
        DnaHandler.register(DNA_NIGHTVISION);
        DnaHandler.register(DNA_WALLCLIMB);
        DnaHandler.register(DNA_REPEL_ARROW);
    }

    public static void register(IDna dna) {
        DNA_ENTRIES.put(dna.getRegistryName(), dna);
        DNA_LIST.add(dna);
    }

    public static IDna getDnaEntry(ResourceLocation resourceLocation) {
        if (DNA_ENTRIES.containsKey(resourceLocation)) {
            return DNA_ENTRIES.get(resourceLocation);
        }
        return DNA_BORING;
    }

    public static IDna getRandomDna(Random random) {
        return DNA_LIST.get(random.nextInt(DNA_LIST.size()));
    }

    @SubscribeEvent
    public static void onXpPickup(PlayerPickupXpEvent e) {
        IRegeneration data = CapabilityRegeneration.getForPlayer(e.getEntityPlayer());
        IDna dna = DnaHandler.getDnaEntry(data.getDnaType());
        if (dna.getRegistryName().equals((Object)DNA_DUMB.getRegistryName()) && data.isDnaActive()) {
            e.getOrb().field_70530_e = (int)((double)e.getOrb().field_70530_e * 0.5);
        }
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            IRegeneration data = CapabilityRegeneration.getForPlayer(player);
            if (player.field_70170_p.field_72995_K) {
                return;
            }
            if (data.isDnaActive() && data.getDnaType().equals((Object)DNA_ATHLETE.getRegistryName())) {
                player.field_70181_x += 0.1;
                player.field_70133_I = true;
            }
        }
    }

    @SubscribeEvent
    public static void onArrow(LivingAttackEvent event) {
        DamageSource source = event.getSource();
        Entity attacked = event.getEntity();
        if (source != null && attacked != null && source.func_76364_f() != null && attacked instanceof EntityPlayer && source.func_76364_f() instanceof EntityArrow && !attacked.field_70170_p.field_72995_K) {
            EntityPlayer player = (EntityPlayer)attacked;
            boolean flag = CapabilityRegeneration.getForPlayer(player).getDnaType().toString().equals(DNA_REPEL_ARROW.getRegistryName().toString());
            event.setCanceled(flag);
        }
    }

    public static abstract class IDna {
        public ResourceLocation resourceLocation;
        public String localName;
        private String localDesc;

        public IDna(String name) {
            this.localName = "traits." + name + ".name";
            this.localDesc = "traits." + name + ".desc";
            this.resourceLocation = new ResourceLocation("regeneration", name);
        }

        public abstract void onUpdate(IRegeneration var1);

        public abstract void onAdded(IRegeneration var1);

        public abstract void onRemoved(IRegeneration var1);

        public String getLangKey() {
            return this.localName;
        }

        public String getLocalDesc() {
            return this.localDesc;
        }

        public ResourceLocation getRegistryName() {
            return this.resourceLocation;
        }
    }
}

