/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.types;

import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.client.rendering.types.TypeFieryRenderer;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.common.types.IRegenType;
import me.swirtzly.regeneration.common.types.TypeHandler;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.util.PlayerUtil;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class TypeFiery
implements IRegenType<TypeFieryRenderer> {
    private SoundEvent[] SOUNDS = new SoundEvent[]{RegenObjects.Sounds.REGENERATION_1, RegenObjects.Sounds.REGENERATION_2, RegenObjects.Sounds.REGENERATION_3, RegenObjects.Sounds.REGENERATION_4, RegenObjects.Sounds.REGENERATION_5, RegenObjects.Sounds.REGENERATION_6};

    @Override
    public void onUpdateMidRegen(EntityPlayer player, IRegeneration capability) {
        player.func_70066_B();
        if (!player.field_70170_p.field_72995_K) {
            PlayerUtil.setPerspective((EntityPlayerMP)player, true, false);
        }
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.field_70170_p.func_180495_p(player.func_180425_c()).func_177230_c() instanceof BlockFire) {
            player.field_70170_p.func_175698_g(player.func_180425_c());
        }
        double x = player.field_70165_t + player.func_70681_au().nextGaussian() * 2.0;
        double y = player.field_70163_u + 0.5 + player.func_70681_au().nextGaussian() * 2.0;
        double z = player.field_70161_v + player.func_70681_au().nextGaussian() * 2.0;
        player.field_70170_p.func_72885_a((Entity)player, x, y, z, 0.1f, RegenConfig.fieryRegen, false);
        for (BlockPos bs : BlockPos.func_177980_a((BlockPos)player.func_180425_c().func_177978_c().func_177976_e(), (BlockPos)player.func_180425_c().func_177968_d().func_177974_f())) {
            if (!(player.field_70170_p.func_180495_p(bs).func_177230_c() instanceof BlockFire)) continue;
            player.field_70170_p.func_175698_g(bs);
        }
    }

    @Override
    public void onFinishRegeneration(EntityPlayer player, IRegeneration capability) {
        PlayerUtil.setPerspective((EntityPlayerMP)player, false, true);
        capability.setAnimationTicks(0);
    }

    @Override
    public int getAnimationLength() {
        return 280;
    }

    @Override
    public double getAnimationProgress(IRegeneration cap) {
        return Math.min(1.0, (double)cap.getAnimationTicks() / (double)this.getAnimationLength());
    }

    @Override
    public TypeHandler.RegenType getTypeID() {
        return TypeHandler.RegenType.FIERY;
    }

    @Override
    public SoundEvent[] getRegeneratingSounds() {
        return this.SOUNDS;
    }

    @Override
    public Vec3d getDefaultPrimaryColor() {
        return new Vec3d((double)0.93f, (double)0.61f, 0.0);
    }

    @Override
    public Vec3d getDefaultSecondaryColor() {
        return new Vec3d(1.0, 0.5, (double)0.18f);
    }

    @Override
    public TypeFieryRenderer getRenderer() {
        return TypeFieryRenderer.INSTANCE;
    }
}

