/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.compat.lucraft;

import lucraft.mods.lucraftcore.materials.potions.PotionRadiation;
import lucraft.mods.lucraftcore.superpowers.SuperpowerHandler;
import lucraft.mods.lucraftcore.util.abilitybar.AbilityBarHandler;
import lucraft.mods.lucraftcore.util.abilitybar.AbilityBarKeys;
import lucraft.mods.lucraftcore.util.abilitybar.IAbilityBarProvider;
import lucraft.mods.lucraftcore.util.events.RenderModelEvent;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.client.animation.AnimationContext;
import me.swirtzly.regeneration.client.animation.AnimationHandler;
import me.swirtzly.regeneration.client.rendering.types.ATypeRenderer;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.common.types.IRegenType;
import me.swirtzly.regeneration.common.types.TypeHandler;
import me.swirtzly.regeneration.compat.lucraft.LCCoreBarEntry;
import me.swirtzly.regeneration.compat.lucraft.PlayerCanRegenEvent;
import me.swirtzly.regeneration.handlers.IActingHandler;
import me.swirtzly.regeneration.util.ClientUtil;
import me.swirtzly.regeneration.util.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LucraftCoreHandler
implements IActingHandler {
    public static void registerEntry() {
        AbilityBarHandler.registerProvider((IAbilityBarProvider)new LCCoreBarEntry());
    }

    public static void registerEventBus() {
        MinecraftForge.EVENT_BUS.register((Object)new LucraftCoreHandler());
    }

    public static String getKeyBindDisplayName() {
        for (int i = 0; i < 5; ++i) {
            if (!(AbilityBarHandler.getEntryFromKey((int)i) instanceof LCCoreBarEntry)) continue;
            return ((AbilityBarKeys.KeyBindingAbilityBar)AbilityBarKeys.KEYS.get(i)).getDisplayName();
        }
        return "???";
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onInput(InputUpdateEvent tickEvent) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r == null && minecraft.field_71439_g != null) {
            ClientUtil.keyBind = LucraftCoreHandler.getKeyBindDisplayName();
        }
    }

    @Override
    public void onRegenTick(IRegeneration cap) {
    }

    @Override
    public void onEnterGrace(IRegeneration cap) {
    }

    @Override
    public void onHandsStartGlowing(IRegeneration cap) {
    }

    @Override
    public void onRegenFinish(IRegeneration cap) {
    }

    @Override
    public void onStartPost(IRegeneration cap) {
    }

    @Override
    public void onProcessDone(IRegeneration cap) {
    }

    @Override
    public void onRegenTrigger(IRegeneration cap) {
    }

    @Override
    public void onGoCritical(IRegeneration cap) {
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntityLiving();
            IRegeneration data = CapabilityRegeneration.getForPlayer(player);
            boolean flag = data.canRegenerate() && e.getSource() == PotionRadiation.RADIATION && RegenConfig.modIntegrations.lucraftcore.immuneToRadiation;
            e.setCanceled(flag);
        }
    }

    @SubscribeEvent
    public void onCanRegen(PlayerCanRegenEvent e) {
        boolean flag;
        boolean bl = flag = RegenConfig.modIntegrations.lucraftcore.superpowerDisable && SuperpowerHandler.hasSuperpower((EntityLivingBase)e.getEntityPlayer());
        if (flag) {
            e.setCanceled(true);
            PlayerUtil.sendMessage(e.getEntityPlayer(), "You cannot Regenerate with a superpower", true);
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    @SideOnly(value=Side.CLIENT)
    public void onAnimation(RenderModelEvent.SetRotationAngels ev) {
        if (ev.getEntity() instanceof EntityPlayer) {
            AnimationContext context = new AnimationContext(ev.model, (EntityPlayer)ev.getEntity(), ev.limbSwing, ev.limbSwingAmount, ev.ageInTicks, ev.netHeadYaw, ev.headPitch);
            IRegeneration data = CapabilityRegeneration.getForPlayer((EntityPlayer)ev.getEntity());
            if (data.getState() == PlayerUtil.RegenState.REGENERATING) {
                IRegenType type = TypeHandler.getTypeInstance(data.getType());
                ev.setCanceled(((ATypeRenderer)type.getRenderer()).onAnimateRegen(context));
            } else {
                AnimationHandler.animate(context);
            }
        }
    }
}

