/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.compat.tardis;

import java.util.Random;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.common.types.TypeHandler;
import me.swirtzly.regeneration.handlers.IActingHandler;
import me.swirtzly.regeneration.handlers.RegenObjects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketParticles;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.dimensions.WorldProviderTardis;
import net.tardis.mod.common.entities.controls.ControlDoor;
import net.tardis.mod.common.sounds.TSounds;
import net.tardis.mod.common.systems.SystemDimension;
import net.tardis.mod.common.systems.TardisSystems;
import net.tardis.mod.common.tileentity.TileEntityTardis;

public class TardisModHandler
implements IActingHandler {
    public static void registerEventBus() {
        MinecraftForge.EVENT_BUS.register((Object)new TardisModHandler());
    }

    @Override
    public void onRegenTick(IRegeneration cap) {
        this.playBells(cap, false);
    }

    @Override
    public void onEnterGrace(IRegeneration cap) {
        if (cap.getPlayer().field_70170_p.field_73011_w instanceof WorldProviderTardis) {
            this.playBells(cap, true);
        }
    }

    @Override
    public void onHandsStartGlowing(IRegeneration cap) {
        if (cap.getPlayer().field_70170_p.field_73011_w instanceof WorldProviderTardis) {
            this.playBells(cap, true);
        }
    }

    @Override
    public void onRegenFinish(IRegeneration cap) {
        if (cap.getPlayer().field_70170_p.field_73011_w instanceof WorldProviderTardis) {
            this.playBells(cap, true);
        }
    }

    @Override
    public void onStartPost(IRegeneration cap) {
    }

    @Override
    public void onProcessDone(IRegeneration cap) {
    }

    @Override
    public void onRegenTrigger(IRegeneration cap) {
        if (cap.getType() == TypeHandler.RegenType.FIERY) {
            this.damageTardisInRange(cap.getPlayer());
        }
    }

    @Override
    public void onGoCritical(IRegeneration cap) {
        if (cap.getPlayer().field_70170_p.field_73011_w instanceof WorldProviderTardis) {
            this.playBells(cap, true);
        }
    }

    private void playBells(IRegeneration cap, boolean force) {
        if (cap.getPlayer().field_70173_aa % 1200 == 0 && cap.getPlayer().field_70170_p.field_73011_w instanceof WorldProviderTardis || force) {
            cap.getPlayer().field_70170_p.func_184133_a(null, cap.getPlayer().func_180425_c(), TSounds.cloister_bell, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void damageTardisInRange(EntityPlayer player) {
        if (!RegenConfig.modIntegrations.tardisMod.damageTardis) {
            return;
        }
        for (TileEntity te : player.field_70170_p.field_147482_g) {
            TardisSystems.BaseSystem[] systems;
            if (!(te instanceof TileEntityTardis) || player.func_174818_b(te.func_174877_v()) > 10.0) continue;
            TileEntityTardis tileEntityTardis = (TileEntityTardis)te;
            Random rand = tileEntityTardis.func_145831_w().field_73012_v;
            tileEntityTardis.func_145831_w().func_184133_a(null, tileEntityTardis.func_174877_v(), TSounds.cloister_bell, SoundCategory.BLOCKS, 1.0f, 1.0f);
            ControlDoor controlDoor = tileEntityTardis.getDoor();
            if (controlDoor != null && controlDoor.isOpen()) {
                controlDoor.func_184230_a(player, EnumHand.MAIN_HAND);
            }
            for (TardisSystems.BaseSystem system : systems = tileEntityTardis.systems) {
                if (rand.nextInt(5) >= 2 || system instanceof SystemDimension) continue;
                system.damage();
                tileEntityTardis.func_145831_w().func_72872_a(EntityPlayer.class, player.func_174813_aQ().func_72321_a(45.0, 45.0, 45.0)).forEach(player1 -> {
                    if (player1 instanceof EntityPlayerMP) {
                        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)player1;
                        BlockPos tilePos = tileEntityTardis.func_174877_v();
                        Vec3d look = new Vec3d(0.1, 0.0, 0.1);
                        for (int particle = 0; particle < 300; ++particle) {
                            entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketParticles(EnumParticleTypes.EXPLOSION_NORMAL, true, (float)tilePos.func_177958_n(), (float)tilePos.func_177956_o(), (float)tilePos.func_177952_p(), (float)look.field_72450_a, (float)look.field_72448_b, (float)look.field_72449_c, 2.0f, 25, new int[0]));
                            look = look.func_178785_b(0.003f);
                        }
                    }
                });
            }
            if (!tileEntityTardis.isInFlight()) continue;
            tileEntityTardis.crash(true);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            IRegeneration data = CapabilityRegeneration.getForPlayer(player);
            if (player.field_71093_bK == TDimensions.TARDIS_ID && data.getState().isGraceful()) {
                for (TileEntity tileEntity : player.field_70170_p.field_147482_g) {
                    if (!(player.func_174818_b(tileEntity.func_174877_v()) < 40.0) || !(tileEntity instanceof TileEntityTardis) || data.getPlayer().field_70173_aa % 25 != 0) continue;
                    tileEntity.func_145831_w().func_184133_a(null, tileEntity.func_174877_v(), RegenObjects.Sounds.ALARM, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
    }
}

