/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.handlers;

import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.asm.RegenClientHooks;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.handlers.IActingHandler;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.util.ClientUtil;
import me.swirtzly.regeneration.util.PlayerUtil;
import me.swirtzly.regeneration.util.RegenUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;

class ActingClientHandler
implements IActingHandler {
    public static final IActingHandler INSTANCE = new ActingClientHandler();

    private ActingClientHandler() {
    }

    @Override
    public void onRegenTick(IRegeneration cap) {
    }

    @Override
    public void onEnterGrace(IRegeneration cap) {
        ClientUtil.takeScreenshot();
        ClientUtil.playSound(cap.getPlayer(), RegenObjects.Sounds.HEART_BEAT.getRegistryName(), SoundCategory.PLAYERS, true, () -> !cap.getState().isGraceful(), 0.2f);
        ClientUtil.playSound(cap.getPlayer(), RegenObjects.Sounds.GRACE_HUM.getRegistryName(), SoundCategory.AMBIENT, true, () -> cap.getState() != PlayerUtil.RegenState.GRACE, 1.5f);
        RegenClientHooks.handleShader();
    }

    @Override
    public void onHandsStartGlowing(IRegeneration cap) {
        ClientUtil.playSound(cap.getPlayer(), RegenObjects.Sounds.HAND_GLOW.getRegistryName(), SoundCategory.PLAYERS, true, () -> !cap.areHandsGlowing(), 1.0f);
        RegenClientHooks.handleShader();
    }

    @Override
    public void onRegenFinish(IRegeneration cap) {
        ClientUtil.createToast(new TextComponentTranslation("regeneration.toast.regenerated", new Object[0]), new TextComponentTranslation("regeneration.toast.regenerations_left", new Object[]{cap.getRegenerationsLeft()}));
        if (RegenConfig.changeHand && cap.getPlayer().func_110124_au() == Minecraft.func_71410_x().field_71439_g.func_110124_au()) {
            Minecraft.func_71410_x().field_71474_y.field_186715_A = RegenUtil.randomEnum(EnumHandSide.class);
            Minecraft.func_71410_x().field_71474_y.func_82879_c();
        }
        RegenClientHooks.handleShader();
    }

    @Override
    public void onStartPost(IRegeneration cap) {
        RegenClientHooks.handleShader();
    }

    @Override
    public void onProcessDone(IRegeneration cap) {
        RegenClientHooks.handleShader();
    }

    @Override
    public void onRegenTrigger(IRegeneration cap) {
        RegenClientHooks.handleShader();
    }

    @Override
    public void onGoCritical(IRegeneration cap) {
        ClientUtil.createToast(new TextComponentTranslation("regeneration.toast.enter_critical", new Object[0]), new TextComponentTranslation("regeneration.toast.enter_critical.sub", new Object[]{RegenConfig.grace.criticalPhaseLength / 60}));
        ClientUtil.playSound(cap.getPlayer(), RegenObjects.Sounds.CRITICAL_STAGE.getRegistryName(), SoundCategory.PLAYERS, true, () -> cap.getState() != PlayerUtil.RegenState.GRACE_CRIT, 1.0f);
        RegenClientHooks.handleShader();
    }
}

