/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.handlers;

import java.util.ArrayList;
import java.util.List;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.handlers.ActingClientHandler;
import me.swirtzly.regeneration.handlers.ActingServerHandler;
import me.swirtzly.regeneration.handlers.IActingHandler;
import me.swirtzly.regeneration.network.MessageRegenStateEvent;
import me.swirtzly.regeneration.network.NetworkHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class ActingForwarder {
    private static List<IActingHandler> SERVER_HANDLERS = new ArrayList<IActingHandler>();
    private static List<IActingHandler> CLIENT_HANDLERS = new ArrayList<IActingHandler>();

    public static void init() {
        ActingForwarder.register(ActingServerHandler.INSTANCE, Side.SERVER);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            ActingForwarder.register(ActingClientHandler.INSTANCE, Side.CLIENT);
        }
    }

    public static void register(Class<? extends IActingHandler> handlerClass, Side side) {
        try {
            ActingForwarder.register(handlerClass.newInstance(), side);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Error while instantiating acting handler", e);
        }
    }

    public static void register(IActingHandler handler, Side side) {
        (side == Side.CLIENT ? CLIENT_HANDLERS : SERVER_HANDLERS).add(handler);
    }

    public static void onRegenTick(IRegeneration cap) {
        if (cap.getPlayer().field_70170_p.field_72995_K) {
            throw new IllegalStateException("'Posting' tick `event` from client (this is VERY wrong)");
        }
        for (IActingHandler handler : SERVER_HANDLERS) {
            handler.onRegenTick(cap);
        }
    }

    public static void onEnterGrace(IRegeneration cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.ENTER_GRACE);
        for (IActingHandler handler : SERVER_HANDLERS) {
            handler.onEnterGrace(cap);
        }
    }

    public static void onRegenFinish(IRegeneration cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.REGEN_FINISH);
        for (IActingHandler handler : SERVER_HANDLERS) {
            handler.onRegenFinish(cap);
        }
    }

    public static void onRegenTrigger(IRegeneration cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.REGEN_TRIGGER);
        for (IActingHandler handler : SERVER_HANDLERS) {
            handler.onRegenTrigger(cap);
        }
    }

    public static void onGoCritical(IRegeneration cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.CRITICAL_START);
        for (IActingHandler handler : SERVER_HANDLERS) {
            handler.onGoCritical(cap);
        }
    }

    public static void onHandsStartGlowing(IRegeneration cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.HAND_GLOW_START);
        for (IActingHandler handler : SERVER_HANDLERS) {
            handler.onHandsStartGlowing(cap);
        }
    }

    public static void onStartPost(IRegeneration cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.PERFORM_POST);
        for (IActingHandler handler : SERVER_HANDLERS) {
            handler.onStartPost(cap);
        }
    }

    public static void onProcessDone(IRegeneration cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.PROCESS_DONE);
        for (IActingHandler handler : SERVER_HANDLERS) {
            handler.onProcessDone(cap);
        }
    }

    public static void onClient(RegenEvent event, IRegeneration cap) {
        for (IActingHandler handler : CLIENT_HANDLERS) {
            switch (event) {
                case ENTER_GRACE: {
                    handler.onEnterGrace(cap);
                    break;
                }
                case REGEN_FINISH: {
                    handler.onRegenFinish(cap);
                    break;
                }
                case REGEN_TRIGGER: {
                    handler.onRegenTrigger(cap);
                    break;
                }
                case CRITICAL_START: {
                    handler.onGoCritical(cap);
                    break;
                }
                case HAND_GLOW_START: {
                    handler.onHandsStartGlowing(cap);
                    break;
                }
                case PERFORM_POST: {
                    handler.onStartPost(cap);
                }
                case PROCESS_DONE: {
                    handler.onProcessDone(cap);
                }
            }
        }
    }

    private static void checkAndForward(IRegeneration cap, RegenEvent event) {
        if (cap.getPlayer().field_70170_p.field_72995_K) {
            throw new IllegalStateException("'Posting' \"acting\" `event` from client");
        }
        NetworkHandler.INSTANCE.sendTo((IMessage)new MessageRegenStateEvent(cap.getPlayer(), event.name()), (EntityPlayerMP)cap.getPlayer());
    }

    public static enum RegenEvent {
        ENTER_GRACE,
        REGEN_FINISH,
        REGEN_TRIGGER,
        CRITICAL_START,
        PERFORM_POST,
        HAND_GLOW_START,
        PROCESS_DONE;

    }
}

