/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.handlers;

import java.util.UUID;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.common.advancements.RegenTriggers;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.common.entity.EntityLindos;
import me.swirtzly.regeneration.common.traits.DnaHandler;
import me.swirtzly.regeneration.common.types.TypeHandler;
import me.swirtzly.regeneration.handlers.IActingHandler;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.network.MessagePlayRegenerationSound;
import me.swirtzly.regeneration.network.NetworkHandler;
import me.swirtzly.regeneration.util.PlayerUtil;
import me.swirtzly.regeneration.util.RegenUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

class ActingServerHandler
implements IActingHandler {
    public static final IActingHandler INSTANCE = new ActingServerHandler();
    private final UUID SLOWNESS_ID = UUID.fromString("f9aa2c36-f3f3-4d76-a148-86d6f2c87782");
    private final UUID MAX_HEALTH_ID = UUID.fromString("5d6f0ba2-1286-46fc-b896-461c5cfd99cc");
    private final double HEART_REDUCTION = 0.5;
    private final double SPEED_REDUCTION = 0.35;
    private final AttributeModifier slownessModifier = new AttributeModifier(this.SLOWNESS_ID, "slow", -0.35, 1);
    private final AttributeModifier heartModifier = new AttributeModifier(this.MAX_HEALTH_ID, "short-heart", -0.5, 1);

    @Override
    public void onRegenTick(IRegeneration cap) {
        EntityPlayer player = cap.getPlayer();
        float stateProgress = (float)cap.getStateManager().getStateProgress();
        switch (cap.getState()) {
            case POST: {
                if (player.field_70173_aa % 210 == 0) {
                    PlayerUtil.applyPotionIfAbsent(player, PlayerUtil.POTIONS.get(player.field_70170_p.field_73012_v.nextInt(PlayerUtil.POTIONS.size())), player.field_70170_p.field_73012_v.nextInt(400), 1, false, false);
                }
                if (RegenConfig.postRegen.postRegenerationLindosInterval == 0 || player.field_70173_aa % (RegenConfig.postRegen.postRegenerationLindosInterval * 20) != 0 || !(player.field_70170_p.field_73012_v.nextDouble() < RegenConfig.postRegen.lindosChancePerInterval)) break;
                EntityLindos lindos = new EntityLindos(player.field_70170_p);
                lindos.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, 0.0f, 0.0f);
                player.field_70170_p.func_72838_d((Entity)lindos);
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), RegenObjects.Sounds.REGEN_BREATH, SoundCategory.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case REGENERATING: {
                float dm = Math.max(1.0f, (float)(player.field_70170_p.func_175659_aa().func_151525_a() + 1) / 3.0f);
                player.func_70691_i(stateProgress * 0.3f * dm);
                player.func_85034_r(0);
                RegenUtil.regenerationExplosion(player);
                if (player.field_70173_aa % 5 != 0) break;
                PlayerUtil.openDoors(player);
                break;
            }
            case GRACE_CRIT: {
                float nauseaPercentage = 0.5f;
                if (stateProgress > nauseaPercentage) {
                    PlayerUtil.applyPotionIfAbsent(player, MobEffects.field_76431_k, (int)((float)(RegenConfig.grace.criticalPhaseLength * 20) * (1.0f - nauseaPercentage) * 1.5f), 0, false, false);
                }
                PlayerUtil.applyPotionIfAbsent(player, MobEffects.field_76437_t, (int)((float)(RegenConfig.grace.criticalPhaseLength * 20) * (1.0f - stateProgress)), 0, false, false);
                if (!(player.field_70170_p.field_73012_v.nextDouble() < (double)(RegenConfig.grace.criticalDamageChance / 100.0f))) break;
                player.func_70097_a(RegenObjects.REGEN_DMG_CRITICAL, player.field_70170_p.field_73012_v.nextFloat() + 0.5f);
                break;
            }
            case GRACE: {
                float weaknessPercentage = 0.5f;
                if (!(stateProgress > weaknessPercentage)) break;
                PlayerUtil.applyPotionIfAbsent(player, MobEffects.field_76437_t, (int)((float)(RegenConfig.grace.gracePhaseLength * 20) * (1.0f - weaknessPercentage) + (float)(RegenConfig.grace.criticalPhaseLength * 20)), 0, false, false);
                break;
            }
            case ALIVE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)cap.getState()));
            }
        }
    }

    @Override
    public void onEnterGrace(IRegeneration cap) {
        EntityPlayer player = cap.getPlayer();
        player.func_110149_m(player.func_110138_aP() * 0.5f);
        if (!player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_180374_a(this.heartModifier)) {
            player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(this.heartModifier);
        }
        DnaHandler.IDna dna = DnaHandler.getDnaEntry(cap.getDnaType());
        dna.onRemoved(cap);
        cap.setDnaActive(false);
        player.func_70606_j(player.func_110138_aP());
    }

    @Override
    public void onHandsStartGlowing(IRegeneration cap) {
        PlayerUtil.sendMessage(cap.getPlayer(), new TextComponentTranslation("regeneration.messages.regen_warning", new Object[0]), true);
    }

    @Override
    public void onGoCritical(IRegeneration cap) {
        RegenTriggers.CRITICAL.trigger((EntityPlayerMP)cap.getPlayer());
        if (!cap.getPlayer().func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(this.slownessModifier)) {
            cap.getPlayer().func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.slownessModifier);
        }
    }

    @Override
    public void onRegenTrigger(IRegeneration cap) {
        EntityPlayer player = cap.getPlayer();
        NetworkHandler.INSTANCE.sendToAllAround((IMessage)new MessagePlayRegenerationSound(RegenUtil.getRandomSound(TypeHandler.getTypeInstance(cap.getType()).getRegeneratingSounds(), player.field_70170_p.field_73012_v), player.func_110124_au().toString()), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 40.0));
        player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_188479_b(this.MAX_HEALTH_ID);
        player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(this.SLOWNESS_ID);
        player.func_70606_j(Math.max(player.func_110143_aJ(), 8.0f));
        player.func_110149_m(0.0f);
        player.func_70066_B();
        player.func_184226_ay();
        player.func_70674_bp();
        player.func_184210_p();
        if (RegenConfig.postRegen.resetHunger) {
            player.func_71024_bL().func_75114_a(20);
        }
        if (RegenConfig.postRegen.resetOxygen) {
            player.func_70050_g(300);
        }
        cap.extractRegeneration(1);
    }

    @Override
    public void onRegenFinish(IRegeneration cap) {
        EntityPlayer player = cap.getPlayer();
        RegenTriggers.FIRST_REGENERATION.trigger((EntityPlayerMP)cap.getPlayer());
        player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, RegenConfig.postRegen.postRegenerationDuration * 2, RegenConfig.postRegen.postRegenerationLevel - 1, false, false));
        player.func_70606_j(player.func_110138_aP());
        player.func_110149_m((float)(RegenConfig.postRegen.absorbtionLevel * 2));
        if (RegenConfig.onRegen.traitsEnabled) {
            cap.setDnaType(DnaHandler.getRandomDna(player.field_70170_p.field_73012_v).getRegistryName());
            DnaHandler.IDna newDna = DnaHandler.getDnaEntry(cap.getDnaType());
            newDna.onAdded(cap);
            cap.setDnaActive(true);
            PlayerUtil.sendMessage(player, new TextComponentTranslation(newDna.getLangKey(), new Object[0]), true);
        }
        RegenUtil.resetNextSkin(player);
    }

    @Override
    public void onStartPost(IRegeneration cap) {
    }

    @Override
    public void onProcessDone(IRegeneration cap) {
        EntityPlayer player = cap.getPlayer();
        if (player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(this.MAX_HEALTH_ID) != null) {
            player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_188479_b(this.MAX_HEALTH_ID);
            player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(this.SLOWNESS_ID);
            player.func_110149_m(0.0f);
        } else if (player.field_70170_p.field_73012_v.nextDouble() < RegenConfig.postRegen.lindosChance) {
            EntityLindos lindos = new EntityLindos(player.field_70170_p);
            lindos.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, 0.0f, 0.0f);
            player.field_70170_p.func_72838_d((Entity)lindos);
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), RegenObjects.Sounds.REGEN_BREATH, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        cap.setDroppedHand(false);
    }
}

