/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.handlers;

import com.google.common.base.Predicate;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.common.advancements.RegenTriggers;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.common.capability.RegenerationProvider;
import me.swirtzly.regeneration.common.item.ItemHand;
import me.swirtzly.regeneration.common.traits.DnaHandler;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.network.MessageRemovePlayer;
import me.swirtzly.regeneration.network.NetworkHandler;
import me.swirtzly.regeneration.util.PlayerUtil;
import me.swirtzly.regeneration.util.RegenUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="regeneration")
public class RegenEventHandler {
    @SubscribeEvent
    public static void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            IRegeneration data = CapabilityRegeneration.getForPlayer(player);
            data.tick();
            if (data.hasDroppedHand() && !player.func_184592_cb().func_190926_b()) {
                player.func_71019_a(player.func_184592_cb(), false);
                player.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_190931_a));
            }
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(CapabilityRegeneration.CAP_REGEN_ID, (ICapabilityProvider)new RegenerationProvider(new CapabilityRegeneration((EntityPlayer)event.getObject())));
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Capability.IStorage storage = CapabilityRegeneration.CAPABILITY.getStorage();
        IRegeneration oldCap = CapabilityRegeneration.getForPlayer(event.getOriginal());
        IRegeneration newCap = CapabilityRegeneration.getForPlayer(event.getEntityPlayer());
        NBTTagCompound nbt = (NBTTagCompound)storage.writeNBT(CapabilityRegeneration.CAPABILITY, (Object)oldCap, null);
        storage.readNBT(CapabilityRegeneration.CAPABILITY, (Object)newCap, null, (NBTBase)nbt);
        CapabilityRegeneration.getForPlayer(event.getEntityPlayer()).synchronise();
    }

    @SubscribeEvent
    public static void playerTracking(PlayerEvent.StartTracking event) {
        CapabilityRegeneration.getForPlayer(event.getEntityPlayer()).synchronise();
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!RegenConfig.firstStartGiftOnly) {
            CapabilityRegeneration.getForPlayer(event.player).receiveRegenerations(RegenConfig.freeRegenerations);
        }
        CapabilityRegeneration.getForPlayer(event.player).synchronise();
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilityRegeneration.getForPlayer(event.player).synchronise();
    }

    @SubscribeEvent
    public static void onDeathEvent(LivingDeathEvent e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            CapabilityRegeneration.getForPlayer((EntityPlayer)e.getEntityLiving()).synchronise();
        }
    }

    @SubscribeEvent
    public static void onPunchBlock(PlayerInteractEvent.LeftClickBlock e) {
        if (e.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        CapabilityRegeneration.getForPlayer(e.getEntityPlayer()).getStateManager().onPunchBlock(e);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void painless(LivingAttackEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        IRegeneration cap = CapabilityRegeneration.getForPlayer(player);
        if (cap.getState() == PlayerUtil.RegenState.REGENERATING && RegenConfig.regenFireImmune && event.getSource().func_76347_k() || cap.getState() == PlayerUtil.RegenState.REGENERATING && event.getSource().func_94541_c()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onHurt(LivingHurtEvent event) {
        Entity trueSource = event.getSource().func_76346_g();
        if (trueSource instanceof EntityPlayer && event.getEntityLiving() instanceof EntityLiving) {
            EntityPlayer player = (EntityPlayer)trueSource;
            CapabilityRegeneration.getForPlayer(player).getStateManager().onPunchEntity(event);
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer) || event.getSource() == RegenObjects.REGEN_DMG_CRITICAL || event.getSource() == RegenObjects.REGEN_DMG_KILLED) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        IRegeneration cap = CapabilityRegeneration.getForPlayer(player);
        cap.setDeathSource(event.getSource().func_151519_b((EntityLivingBase)player).func_150260_c());
        if (cap.getState() == PlayerUtil.RegenState.POST && player.field_70163_u > 0.0) {
            if (event.getSource() == DamageSource.field_76379_h) {
                PlayerUtil.applyPotionIfAbsent(player, MobEffects.field_76431_k, 200, 4, false, false);
                if (event.getAmount() > 8.0f) {
                    if (player.field_70170_p.func_82736_K().func_82766_b("mobGriefing") && RegenConfig.postRegen.genGreator) {
                        RegenUtil.genCrater(player.field_70170_p, player.func_180425_c(), 3);
                    }
                    event.setAmount(0.5f);
                    PlayerUtil.sendMessage(player, new TextComponentTranslation("regeneration.messages.fall_dmg", new Object[0]), true);
                    return;
                }
            } else {
                EntityLiving living;
                if (!player.field_70170_p.field_72995_K && trueSource instanceof EntityLiving && RegenUtil.isSharp((living = (EntityLiving)trueSource).func_184614_ca()) & player.field_70170_p.field_73012_v.nextBoolean() && !cap.hasDroppedHand()) {
                    ItemStack hand = new ItemStack(RegenObjects.Items.HAND);
                    ItemHand.setTextureString(hand, cap.getEncodedSkin());
                    ItemHand.setSkinType(hand, cap.getSkinType().name());
                    ItemHand.setOwner(hand, player.func_110124_au());
                    ItemHand.setTimeCreated(hand, System.currentTimeMillis());
                    ItemHand.setTrait(hand, cap.getDnaType().toString());
                    cap.setDroppedHand(true);
                    RegenTriggers.HAND.trigger((EntityPlayerMP)player);
                    if (player.func_184591_cq() == EnumHandSide.LEFT) {
                        cap.setCutOffHand(EnumHandSide.RIGHT);
                    } else {
                        cap.setCutOffHand(EnumHandSide.LEFT);
                    }
                    InventoryHelper.func_180173_a((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)hand);
                }
                event.setAmount(0.5f);
                PlayerUtil.sendMessage(player, new TextComponentTranslation("regeneration.messages.reduced_dmg", new Object[0]), true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void adMortemInimicus(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        IRegeneration cap = CapabilityRegeneration.getForPlayer(player);
        if (!(event.getSource() != RegenObjects.REGEN_DMG_CRITICAL && event.getSource() != RegenObjects.REGEN_DMG_KILLED || player.field_70170_p.field_72995_K)) {
            cap.setDnaType(DnaHandler.DNA_BORING.getRegistryName());
            if (RegenConfig.loseRegensOnDeath) {
                cap.extractRegeneration(cap.getRegenerationsLeft());
            }
            cap.synchronise();
        }
        boolean notDead = cap.getStateManager().onKilled(event.getSource());
        event.setCanceled(notDead);
    }

    @SubscribeEvent
    public static void onKnockback(LivingKnockBackEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && CapabilityRegeneration.getForPlayer((EntityPlayer)event.getEntityLiving()).getState() == PlayerUtil.RegenState.REGENERATING) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        NBTTagCompound nbt = event.player.getEntityData();
        NBTTagCompound persist = nbt.func_74775_l("PlayerPersisted");
        if (!persist.func_74767_n("loggedInBefore")) {
            CapabilityRegeneration.getForPlayer(event.player).receiveRegenerations(RegenConfig.freeRegenerations);
        }
        persist.func_74757_a("loggedInBefore", true);
        nbt.func_74782_a("PlayerPersisted", (NBTBase)persist);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        EntityPlayer player = e.player;
        if (!player.field_70170_p.field_72995_K && RegenConfig.enableUpdateChecker) {
            ForgeVersion.CheckResult version = ForgeVersion.getResult((ModContainer)Loader.instance().activeModContainer());
            if (version.status.equals((Object)ForgeVersion.Status.OUTDATED)) {
                TextComponentString url = new TextComponentString(TextFormatting.AQUA + TextFormatting.BOLD.toString() + "UPDATE");
                url.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft.curseforge.com/projects/regeneration"));
                url.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Open URL")));
                player.func_145747_a(new TextComponentString(TextFormatting.GOLD + "[Regeneration] : ").func_150257_a((ITextComponent)url));
                String changes = (String)version.changes.get(version.target);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Changes: " + TextFormatting.BLUE + changes));
            }
        }
    }

    @SubscribeEvent
    public static void addRunAwayTask(EntityJoinWorldEvent e) {
        if (e.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (e.getEntity() instanceof EntityCreature) {
            EntityCreature living = (EntityCreature)e.getEntity();
            Predicate pred = entity -> {
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    IRegeneration data = CapabilityRegeneration.getForPlayer(player);
                    return data.getState() == PlayerUtil.RegenState.REGENERATING || data.areHandsGlowing();
                }
                return false;
            };
            living.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity(living, EntityPlayer.class, pred, 6.0f, 1.0, 1.2));
        }
        if (e.getEntity() instanceof EntityPlayer) {
            NetworkHandler.INSTANCE.sendToAll((IMessage)new MessageRemovePlayer(e.getEntity().func_110124_au()));
        }
    }

    @SubscribeEvent
    public static void onCut(PlayerInteractEvent.RightClickItem event) {
        if (RegenUtil.isSharp(event.getItemStack())) {
            EntityPlayer player = event.getEntityPlayer();
            IRegeneration cap = CapabilityRegeneration.getForPlayer(player);
            if (!player.field_70170_p.field_72995_K && cap.getState() == PlayerUtil.RegenState.POST && player.func_70093_af() && !cap.hasDroppedHand()) {
                ItemStack hand = new ItemStack(RegenObjects.Items.HAND);
                ItemHand.setTextureString(hand, cap.getEncodedSkin());
                ItemHand.setSkinType(hand, cap.getSkinType().name());
                ItemHand.setOwner(hand, player.func_110124_au());
                ItemHand.setTimeCreated(hand, System.currentTimeMillis());
                ItemHand.setTrait(hand, cap.getDnaType().toString());
                cap.setDroppedHand(true);
                RegenTriggers.HAND.trigger((EntityPlayerMP)player);
                if (player.func_184591_cq() == EnumHandSide.LEFT) {
                    cap.setCutOffHand(EnumHandSide.RIGHT);
                } else {
                    cap.setCutOffHand(EnumHandSide.LEFT);
                }
                InventoryHelper.func_180173_a((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)hand);
            }
        }
    }
}

