/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.handlers;

import java.util.ArrayList;
import java.util.List;
import me.swirtzly.regeneration.common.block.BlockHandInJar;
import me.swirtzly.regeneration.common.entity.EntityItemOverride;
import me.swirtzly.regeneration.common.entity.EntityLindos;
import me.swirtzly.regeneration.common.entity.EntityWatcher;
import me.swirtzly.regeneration.common.item.ItemArchInterface;
import me.swirtzly.regeneration.common.item.ItemFobWatch;
import me.swirtzly.regeneration.common.item.ItemHand;
import me.swirtzly.regeneration.common.item.ItemLindos;
import me.swirtzly.regeneration.util.RegenDamageSource;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="regeneration")
public class RegenObjects {
    public static List<Item> ITEMS = new ArrayList<Item>();
    public static List<Item> ITEM_BLOCKS = new ArrayList<Item>();
    public static DamageSource REGEN_DMG_ENERGY_EXPLOSION = new RegenDamageSource("regen_energy");
    public static DamageSource REGEN_DMG_HEALING = new RegenDamageSource("regen_heal").func_76359_i();
    public static DamageSource REGEN_DMG_CRITICAL = new RegenDamageSource("regen_crit").func_76359_i();
    public static DamageSource REGEN_DMG_KILLED = new RegenDamageSource("regen_killed").func_76359_i();
    public static DamageSource REGEN_DMG_LINDOS = new RegenDamageSource("lindos").func_76359_i();

    @SubscribeEvent
    public static void addItems(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RegenObjects.setUpItem(new ItemFobWatch(), "fob_watch"), RegenObjects.setUpItem(new ItemLindos(), "lindos_vial"), RegenObjects.setUpItem(new ItemHand(), "hand"), RegenObjects.setUpItem(new ItemArchInterface(), "arch")});
        e.getRegistry().registerAll((IForgeRegistryEntry[])ITEM_BLOCKS.toArray(new Item[ITEM_BLOCKS.size()]));
    }

    private static Item setUpItem(Item item, String name) {
        item.setRegistryName("regeneration", name);
        item.func_77655_b(name);
        ITEMS.add(item);
        return item;
    }

    private static Block setUpBlock(Block block, String name) {
        block.setRegistryName("regeneration", name);
        block.func_149663_c("regeneration." + name);
        return block;
    }

    private static void registerBlocks(IForgeRegistry<Block> reg, Block ... blocks) {
        reg.registerAll((IForgeRegistryEntry[])blocks);
        for (Block block : blocks) {
            ITEM_BLOCKS.add(((Item)new ItemBlock(block).setRegistryName(block.getRegistryName())).func_77655_b(block.func_149739_a()));
        }
    }

    @SubscribeEvent
    public static void addEntities(RegistryEvent.Register<EntityEntry> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new EntityEntry[]{EntityEntries.ENTITY_ITEM, EntityEntries.ENTITY_LINDOS, EntityEntries.ENTITY_WATCHER});
    }

    @SubscribeEvent
    public static void addBlocks(RegistryEvent.Register<Block> e) {
        RegenObjects.registerBlocks((IForgeRegistry<Block>)e.getRegistry(), RegenObjects.setUpBlock((Block)new BlockHandInJar(), "hand_jar"));
    }

    @SubscribeEvent
    public static void addSounds(RegistryEvent.Register<SoundEvent> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{RegenObjects.setUpSound("fob_watch"), RegenObjects.setUpSound("critical_stage"), RegenObjects.setUpSound("heart_beat"), RegenObjects.setUpSound("hand_glow"), RegenObjects.setUpSound("fob_watch_dialogue"), RegenObjects.setUpSound("grace_hum"), RegenObjects.setUpSound("regen_breath"), RegenObjects.setUpSound("alarm"), RegenObjects.setUpSound("jar_bubbles")});
        for (int i = 0; i < 7; ++i) {
            e.getRegistry().register((IForgeRegistryEntry)RegenObjects.setUpSound("regeneration_" + i));
        }
    }

    private static SoundEvent setUpSound(String soundName) {
        return (SoundEvent)new SoundEvent(new ResourceLocation("regeneration", soundName)).setRegistryName(soundName);
    }

    @GameRegistry.ObjectHolder(value="regeneration")
    public static class Blocks {
        public static final Block HAND_JAR = null;
    }

    public static class EntityEntries {
        public static final EntityEntry ENTITY_ITEM = EntityEntryBuilder.create().entity(EntityItemOverride.class).id(new ResourceLocation("regeneration", "fob_watch"), 0).name("fob").tracker(80, 3, false).build();
        public static final EntityEntry ENTITY_LINDOS = EntityEntryBuilder.create().entity(EntityLindos.class).id(new ResourceLocation("regeneration", "lindos"), 1).name("lindos").tracker(80, 3, false).build();
        public static final EntityEntry ENTITY_WATCHER = EntityEntryBuilder.create().entity(EntityWatcher.class).id(new ResourceLocation("regeneration", "watcher"), 2).name("lindos").tracker(80, 3, false).build();
    }

    @GameRegistry.ObjectHolder(value="regeneration")
    public static class Sounds {
        public static final SoundEvent FOB_WATCH = null;
        public static final SoundEvent FOB_WATCH_DIALOGUE = null;
        public static final SoundEvent CRITICAL_STAGE = null;
        public static final SoundEvent HEART_BEAT = null;
        public static final SoundEvent HAND_GLOW = null;
        public static final SoundEvent GRACE_HUM = null;
        public static final SoundEvent REGEN_BREATH = null;
        public static final SoundEvent ALARM = null;
        public static final SoundEvent JAR_BUBBLES = null;
        public static final SoundEvent REGENERATION_0 = null;
        public static final SoundEvent REGENERATION_1 = null;
        public static final SoundEvent REGENERATION_2 = null;
        public static final SoundEvent REGENERATION_3 = null;
        public static final SoundEvent REGENERATION_4 = null;
        public static final SoundEvent REGENERATION_5 = null;
        public static final SoundEvent REGENERATION_6 = null;
    }

    @GameRegistry.ObjectHolder(value="regeneration")
    public static class Items {
        public static final Item FOB_WATCH = null;
        public static final Item LINDOS_VIAL = null;
        public static final Item HAND = null;
        public static final Item ARCH = null;
    }
}

