/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.network;

import io.netty.buffer.ByteBuf;
import me.swirtzly.regeneration.client.skinhandling.SkinInfo;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.util.PlayerUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageNextSkin
implements IMessage {
    private boolean isAlex;
    private String encodedSkin;

    public MessageNextSkin() {
    }

    public MessageNextSkin(String pixelData, boolean isAlex) {
        this.encodedSkin = pixelData;
        this.isAlex = isAlex;
    }

    public void fromBytes(ByteBuf buf) {
        this.encodedSkin = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.isAlex = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.encodedSkin);
        buf.writeBoolean(this.isAlex);
    }

    public static class Handler
    implements IMessageHandler<MessageNextSkin, IMessage> {
        public IMessage onMessage(MessageNextSkin message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_71121_q().func_152344_a(() -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                IRegeneration data = CapabilityRegeneration.getForPlayer((EntityPlayer)player);
                data.setNextSkin(message.encodedSkin);
                data.setNextSkinType(message.isAlex ? SkinInfo.SkinType.ALEX : SkinInfo.SkinType.STEVE);
                data.synchronise();
                PlayerUtil.sendMessage((EntityPlayer)player, new TextComponentTranslation("regeneration.messages.new_skin", new Object[0]), true);
            });
            return null;
        }
    }
}

