/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.util.ClientUtil;
import me.swirtzly.regeneration.util.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessagePlayRegenerationSound
implements IMessage {
    private String sound;
    private String playerUUID;

    public MessagePlayRegenerationSound() {
    }

    public MessagePlayRegenerationSound(SoundEvent sound, String playerUUID) {
        this.playerUUID = playerUUID;
        this.sound = sound.getRegistryName().toString();
    }

    public void fromBytes(ByteBuf buf) {
        this.playerUUID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.sound = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerUUID);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.sound);
    }

    public static class Handler
    implements IMessageHandler<MessagePlayRegenerationSound, IMessage> {
        public IMessage onMessage(MessagePlayRegenerationSound message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                EntityPlayer player = Minecraft.func_71410_x().field_71441_e.func_152378_a(UUID.fromString(message.playerUUID));
                if (player != null) {
                    IRegeneration data = CapabilityRegeneration.getForPlayer(player);
                    ClientUtil.playSound(player, new ResourceLocation(message.sound), SoundCategory.PLAYERS, true, () -> !data.getState().equals((Object)PlayerUtil.RegenState.REGENERATING), 1.0f);
                }
            });
            return null;
        }
    }
}

