/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.network;

import io.netty.buffer.ByteBuf;
import me.swirtzly.regeneration.client.skinhandling.SkinInfo;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.network.MessageRemovePlayer;
import me.swirtzly.regeneration.network.NetworkHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageUpdateSkin
implements IMessage {
    private boolean isAlex;
    private String encodedSkin;

    public MessageUpdateSkin() {
    }

    public MessageUpdateSkin(String pixelData, boolean isAlex) {
        this.encodedSkin = pixelData;
        this.isAlex = isAlex;
    }

    public void fromBytes(ByteBuf buf) {
        this.encodedSkin = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.isAlex = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.encodedSkin);
        buf.writeBoolean(this.isAlex);
    }

    public static class Handler
    implements IMessageHandler<MessageUpdateSkin, IMessage> {
        public IMessage onMessage(MessageUpdateSkin message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_71121_q().func_152344_a(() -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                IRegeneration cap = CapabilityRegeneration.getForPlayer((EntityPlayer)player);
                cap.setEncodedSkin(message.encodedSkin);
                cap.setSkinType(message.isAlex ? SkinInfo.SkinType.ALEX.name() : SkinInfo.SkinType.STEVE.name());
                cap.synchronise();
                NetworkHandler.INSTANCE.sendToAll((IMessage)new MessageRemovePlayer(player.func_110124_au()));
            });
            return null;
        }
    }
}

