/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import me.swirtzly.regeneration.client.MovingSoundBase;
import me.swirtzly.regeneration.client.skinhandling.SkinChangingHandler;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.network.MessageUpdateSkin;
import me.swirtzly.regeneration.network.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientUtil {
    public static final ModelPlayer playerModelSteve = new ModelPlayer(0.1f, false);
    public static final ModelPlayer playerModelAlex = new ModelPlayer(0.1f, true);
    public static String keyBind = "???";

    public static void createToast(TextComponentTranslation title, TextComponentTranslation subtitle) {
        Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new SystemToast(SystemToast.Type.TUTORIAL_HINT, (ITextComponent)title, (ITextComponent)subtitle));
    }

    public static void playPositionedSoundRecord(SoundEvent sound, float pitch, float volume) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_194007_a((SoundEvent)sound, (float)pitch, (float)volume));
    }

    public static void sendSkinResetPacket() {
        NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageUpdateSkin("none", SkinChangingHandler.getSkinType((EntityPlayer)Minecraft.func_71410_x().field_71439_g, true).getMojangType().equals("slim")));
    }

    public static void sendSkinChange(boolean isAlex) {
        IRegeneration data = CapabilityRegeneration.getForPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageUpdateSkin(data.getEncodedSkin(), isAlex));
    }

    @SideOnly(value=Side.CLIENT)
    public static void playSound(Object entity, ResourceLocation soundName, SoundCategory category, boolean repeat, Supplier<Boolean> stopCondition, float volume) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MovingSoundBase(entity, new SoundEvent(soundName), category, repeat, stopCondition, volume));
    }

    public static void copyAnglesToWear(ModelPlayer biped) {
        ModelBase.func_178685_a((ModelRenderer)biped.field_178723_h, (ModelRenderer)biped.field_178732_b);
        ModelBase.func_178685_a((ModelRenderer)biped.field_178724_i, (ModelRenderer)biped.field_178734_a);
        ModelBase.func_178685_a((ModelRenderer)biped.field_178721_j, (ModelRenderer)biped.field_178731_d);
        ModelBase.func_178685_a((ModelRenderer)biped.field_178722_k, (ModelRenderer)biped.field_178733_c);
        ModelBase.func_178685_a((ModelRenderer)biped.field_78115_e, (ModelRenderer)biped.field_178730_v);
        ModelBase.func_178685_a((ModelRenderer)biped.field_78116_c, (ModelRenderer)biped.field_178720_f);
        ClientUtil.copyRotationPoints(biped.field_178723_h, biped.field_178732_b);
        ClientUtil.copyRotationPoints(biped.field_178724_i, biped.field_178734_a);
        ClientUtil.copyRotationPoints(biped.field_178721_j, biped.field_178731_d);
        ClientUtil.copyRotationPoints(biped.field_178722_k, biped.field_178733_c);
        ClientUtil.copyRotationPoints(biped.field_78115_e, biped.field_178730_v);
        ClientUtil.copyRotationPoints(biped.field_78116_c, biped.field_178720_f);
    }

    public static void copyRotationPoints(ModelRenderer src, ModelRenderer dest) {
        dest.field_78800_c = src.field_78800_c;
        dest.field_78797_d = src.field_78797_d;
        dest.field_78798_e = src.field_78798_e;
    }

    public static void takeScreenshot() {
        File ah = Minecraft.func_71410_x().field_71412_D;
        ScreenShotHelper.func_148259_a((File)ah, (String)"bio.png", (int)1920, (int)1080, (Framebuffer)Minecraft.func_71410_x().func_147110_a());
        try {
            System.out.println(SkinChangingHandler.imageToPixelData(new File(ah + "/screenshots/bio.png")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class ImageFixer {
        private static int[] imageData;
        private static int imageWidth;
        private static int imageHeight;

        public static BufferedImage convertSkinTo64x64(BufferedImage image) {
            boolean flag;
            if (image == null) {
                return null;
            }
            if (image.getHeight() == 64 && image.getWidth() == 64) {
                return image;
            }
            imageWidth = 64;
            imageHeight = 64;
            BufferedImage bufferedimage = new BufferedImage(imageWidth, imageHeight, 2);
            Graphics graphics = bufferedimage.getGraphics();
            graphics.drawImage(image, 0, 0, null);
            boolean bl = flag = image.getHeight() == 32;
            if (flag) {
                graphics.setColor(new Color(0, 0, 0, 0));
                graphics.fillRect(0, 32, 64, 32);
                graphics.drawImage(bufferedimage, 24, 48, 20, 52, 4, 16, 8, 20, null);
                graphics.drawImage(bufferedimage, 28, 48, 24, 52, 8, 16, 12, 20, null);
                graphics.drawImage(bufferedimage, 20, 52, 16, 64, 8, 20, 12, 32, null);
                graphics.drawImage(bufferedimage, 24, 52, 20, 64, 4, 20, 8, 32, null);
                graphics.drawImage(bufferedimage, 28, 52, 24, 64, 0, 20, 4, 32, null);
                graphics.drawImage(bufferedimage, 32, 52, 28, 64, 12, 20, 16, 32, null);
                graphics.drawImage(bufferedimage, 40, 48, 36, 52, 44, 16, 48, 20, null);
                graphics.drawImage(bufferedimage, 44, 48, 40, 52, 48, 16, 52, 20, null);
                graphics.drawImage(bufferedimage, 36, 52, 32, 64, 48, 20, 52, 32, null);
                graphics.drawImage(bufferedimage, 40, 52, 36, 64, 44, 20, 48, 32, null);
                graphics.drawImage(bufferedimage, 44, 52, 40, 64, 40, 20, 44, 32, null);
                graphics.drawImage(bufferedimage, 48, 52, 44, 64, 52, 20, 56, 32, null);
            }
            graphics.dispose();
            imageData = ((DataBufferInt)bufferedimage.getRaster().getDataBuffer()).getData();
            ImageFixer.setAreaOpaque(0, 0, 32, 16);
            if (flag) {
                ImageFixer.setAreaTransparent(32, 0, 64, 32);
            }
            ImageFixer.setAreaOpaque(0, 16, 64, 32);
            ImageFixer.setAreaOpaque(16, 48, 48, 64);
            return bufferedimage;
        }

        private static void setAreaTransparent(int x, int y, int width, int height) {
            for (int i = x; i < width; ++i) {
                for (int j = y; j < height; ++j) {
                    int k = imageData[i + j * imageWidth];
                    if ((k >> 24 & 0xFF) >= 128) continue;
                    return;
                }
            }
            for (int l = x; l < width; ++l) {
                for (int i1 = y; i1 < height; ++i1) {
                    int n = l + i1 * imageWidth;
                    imageData[n] = imageData[n] & 0xFFFFFF;
                }
            }
        }

        private static void setAreaOpaque(int x, int y, int width, int height) {
            for (int i = x; i < width; ++i) {
                for (int j = y; j < height; ++j) {
                    int n = i + j * imageWidth;
                    imageData[n] = imageData[n] | 0xFF000000;
                }
            }
        }
    }
}

