/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import me.swirtzly.regeneration.RegenerationMod;
import me.swirtzly.regeneration.client.image.ImageDownloadAlt;
import me.swirtzly.regeneration.client.skinhandling.SkinChangingHandler;
import me.swirtzly.regeneration.util.ClientUtil;
import me.swirtzly.regeneration.util.Trending;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ImageBufferDownload;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;

public class FileUtil {
    private static String[] extensions = new String[]{"png"};

    public static void createDefaultFolders() throws IOException {
        if (!SkinChangingHandler.SKIN_DIRECTORY.exists()) {
            FileUtils.forceMkdir((File)SkinChangingHandler.SKIN_DIRECTORY);
        }
        if (!SkinChangingHandler.SKIN_DIRECTORY_ALEX.exists()) {
            FileUtils.forceMkdir((File)SkinChangingHandler.SKIN_DIRECTORY_ALEX);
        }
        if (!SkinChangingHandler.SKIN_DIRECTORY_STEVE.exists()) {
            FileUtils.forceMkdir((File)SkinChangingHandler.SKIN_DIRECTORY_STEVE);
        }
        if (Objects.requireNonNull(SkinChangingHandler.SKIN_DIRECTORY_ALEX.list()).length == 0 || Objects.requireNonNull(SkinChangingHandler.SKIN_DIRECTORY_STEVE.list()).length == 0) {
            RegenerationMod.LOG.warn("One of the skin directories is empty, so we're going to fill both.");
            Trending.handleDownloads();
        }
    }

    public static void downloadAsPng(URL url, String filename, File alexDir, File steveDir) throws IOException {
        File file;
        URLConnection uc = url.openConnection();
        uc.connect();
        uc = url.openConnection();
        uc.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.75 Safari/537.36");
        SkinChangingHandler.SKIN_LOG.info("Downloading Skin from: {}", (Object)url.toString());
        BufferedImage img = ImageIO.read(uc.getInputStream());
        img = ClientUtil.ImageFixer.convertSkinTo64x64(img);
        File file2 = file = ImageDownloadAlt.isAlexSkin(img) ? alexDir : steveDir;
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!steveDir.exists()) {
            steveDir.mkdirs();
        }
        if (!alexDir.exists()) {
            alexDir.mkdirs();
        }
        ImageIO.write((RenderedImage)img, "png", new File(file, filename + ".png"));
    }

    public static void doSetupOnThread() {
        AtomicBoolean notDownloaded = new AtomicBoolean(true);
        new Thread(() -> {
            while (notDownloaded.get()) {
                try {
                    FileUtil.createDefaultFolders();
                    Trending.downloadTrendingSkins();
                    Trending.downloadPreviousSkins();
                    notDownloaded.set(false);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, "Regeneration Download Daemon").start();
    }

    public static void unzipSkinPack(String url) throws IOException {
        File tempZip = new File(SkinChangingHandler.SKIN_DIRECTORY + "/temp/" + System.currentTimeMillis() + ".zip");
        RegenerationMod.LOG.info("Downloading " + url + " to " + tempZip.getAbsolutePath());
        FileUtils.copyURLToFile((URL)new URL(url), (File)tempZip);
        try (ZipFile file = new ZipFile(tempZip);){
            FileSystem fileSystem = FileSystems.getDefault();
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    Files.createDirectories(fileSystem.getPath(SkinChangingHandler.SKIN_DIRECTORY + File.separator + entry.getName(), new String[0]), new FileAttribute[0]);
                    continue;
                }
                InputStream is = file.getInputStream(entry);
                BufferedInputStream bis = new BufferedInputStream(is);
                String uncompressedFileName = SkinChangingHandler.SKIN_DIRECTORY + File.separator + entry.getName();
                Path uncompressedFilePath = fileSystem.getPath(uncompressedFileName, new String[0]);
                RegenerationMod.LOG.info("Extracting file: " + uncompressedFilePath);
                Files.createFile(uncompressedFilePath, new FileAttribute[0]);
                FileOutputStream fileOutput = new FileOutputStream(uncompressedFileName);
                while (bis.available() > 0) {
                    fileOutput.write(bis.read());
                }
                fileOutput.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (tempZip.exists()) {
            FileUtils.forceDelete((File)tempZip.getParentFile());
        }
    }

    public static String getJsonFromURL(String URL2) {
        URL url = null;
        try {
            url = new URL(URL2);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = FileUtil.bufferedReaderToString(in);
            line = line.replace("<pre>", "");
            line = line.replace("</pre>", "");
            return line;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String bufferedReaderToString(BufferedReader e) {
        StringBuilder builder = new StringBuilder();
        String aux = "";
        try {
            while ((aux = e.readLine()) != null) {
                builder.append(aux);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return builder.toString();
    }

    public static List<File> listAllSkins(SkinChangingHandler.EnumChoices choices) {
        ArrayList<File> resultList = new ArrayList<File>();
        File directory = null;
        switch (choices) {
            case EITHER: {
                directory = SkinChangingHandler.SKIN_DIRECTORY;
                break;
            }
            case ALEX: {
                directory = SkinChangingHandler.SKIN_DIRECTORY_ALEX;
                break;
            }
            case STEVE: {
                directory = SkinChangingHandler.SKIN_DIRECTORY_STEVE;
            }
        }
        Collection files = FileUtils.listFiles((File)directory, (String[])extensions, (boolean)true);
        for (Object file : files) {
            resultList.add((File)file);
        }
        Collections.sort(resultList);
        return resultList;
    }

    public static List<File> similarWords(String word, List<File> allWords) {
        ArrayList<File> similarWordList = new ArrayList<File>();
        for (File currentWord : allWords) {
            if (!currentWord.getName().contains(word)) continue;
            similarWordList.add(currentWord);
        }
        return similarWordList;
    }

    public static ThreadDownloadImageData getDownloadImageSkin(ResourceLocation resourceLocationIn, String url) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        ITextureObject object = texturemanager.func_110581_b(resourceLocationIn);
        if (object == null) {
            object = new ThreadDownloadImageData(null, url, DefaultPlayerSkin.func_177334_a((UUID)AbstractClientPlayer.func_175147_b((String)"")), (IImageBuffer)new ImageBufferDownload());
            texturemanager.func_110579_a(resourceLocationIn, object);
        }
        return (ThreadDownloadImageData)object;
    }

    public static interface IEnum<E extends Enum<E>> {
        public int ordinal();

        default public E next() {
            Enum[] ies = this.getAllValues();
            return (E)(this.ordinal() != ies.length - 1 ? ies[this.ordinal() + 1] : null);
        }

        default public E previous() {
            return (E)(this.ordinal() != 0 ? this.getAllValues()[this.ordinal() - 1] : null);
        }

        default public E[] getAllValues() {
            IEnum[] ies = (IEnum[])this.getClass().getEnumConstants();
            return (Enum[])ies;
        }
    }
}

