/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.util;

import java.util.ArrayList;
import java.util.List;
import me.swirtzly.regeneration.client.skinhandling.SkinChangingHandler;
import me.swirtzly.regeneration.network.MessageSetPerspective;
import me.swirtzly.regeneration.network.MessageUpdateModel;
import me.swirtzly.regeneration.network.NetworkHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIZombieAttack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerUtil {
    public static ArrayList<Potion> POTIONS = new ArrayList();

    public static void createPostList() {
        POTIONS.add(MobEffects.field_76437_t);
        POTIONS.add(MobEffects.field_76419_f);
        POTIONS.add(MobEffects.field_76429_m);
        POTIONS.add(MobEffects.field_180152_w);
        POTIONS.add(MobEffects.field_76438_s);
        POTIONS.add(MobEffects.field_76427_o);
        POTIONS.add(MobEffects.field_76422_e);
    }

    public static void sendMessage(EntityPlayer player, String message, boolean hotBar) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation(message, new Object[0]), hotBar);
        }
    }

    public static void sendMessage(EntityPlayer player, TextComponentTranslation translation, boolean hotBar) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)translation, hotBar);
        }
    }

    public static void sendMessageToAll(TextComponentTranslation translation) {
        List players = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
        players.forEach(playerMP -> PlayerUtil.sendMessage((EntityPlayer)playerMP, translation, false));
    }

    public static void setPerspective(EntityPlayerMP player, boolean thirdperson, boolean resetPitch) {
        NetworkHandler.INSTANCE.sendTo((IMessage)new MessageSetPerspective(thirdperson, resetPitch), player);
    }

    public static boolean canEntityAttack(Entity entity) {
        if (entity instanceof EntityLiving) {
            EntityLiving ent = (EntityLiving)entity;
            for (EntityAITasks.EntityAITaskEntry task : ent.field_70714_bg.field_75782_a) {
                if (!(task.field_75733_a instanceof EntityAIAttackMelee) && !(task.field_75733_a instanceof EntityAIAttackRanged) && !(task.field_75733_a instanceof EntityAIAttackRangedBow) && !(task.field_75733_a instanceof EntityAINearestAttackableTarget) && !(task.field_75733_a instanceof EntityAIZombieAttack) && !(task.field_75733_a instanceof EntityAIOwnerHurtByTarget)) continue;
                return true;
            }
        }
        return false;
    }

    public static void updateModel(SkinChangingHandler.EnumChoices choice) {
        NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageUpdateModel(choice.name()));
    }

    public static void openDoors(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        AxisAlignedBB box = player.func_174813_aQ().func_186662_g(20.0);
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)new BlockPos(box.field_72340_a, box.field_72338_b, box.field_72339_c), (BlockPos)new BlockPos(box.field_72336_d, box.field_72337_e, box.field_72334_f))) {
            IBlockState blockState = player.field_70170_p.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (player.func_180425_c().func_177956_o() < pos.func_177956_o()) {
                if (!(block instanceof BlockTrapDoor)) continue;
                IBlockState newState = blockState.func_177226_a((IProperty)BlockTrapDoor.field_176283_b, (Comparable)Boolean.valueOf(true));
                PlayerUtil.markUpdate(player.field_70170_p, pos, newState);
                int j = blockState.func_185904_a() == Material.field_151573_f ? 1036 : 1013;
                player.field_70170_p.func_180498_a(player, j, pos, 0);
                return;
            }
            if (!(block instanceof BlockDoor)) continue;
            IBlockState down = player.field_70170_p.func_180495_p(pos);
            IBlockState newState = down.func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(true));
            PlayerUtil.markUpdate(player.field_70170_p, pos, newState);
            player.field_70170_p.func_180498_a(player, ((Boolean)blockState.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue() ? (blockState.func_185904_a() == Material.field_151573_f ? 1005 : 1006) : (blockState.func_185904_a() == Material.field_151573_f ? 1011 : 1012), pos, 0);
            return;
        }
    }

    private static void markUpdate(World world, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos, state, 10);
        world.func_175704_b(pos, pos);
    }

    public static boolean applyPotionIfAbsent(EntityPlayer player, Potion potion, int length, int amplifier, boolean ambient, boolean showParticles) {
        if (potion == null) {
            return false;
        }
        if (player.func_70660_b(potion) == null) {
            player.func_70690_d(new PotionEffect(potion, length, amplifier, ambient, showParticles));
            return true;
        }
        return false;
    }

    public static void lookAt(double px, double py, double pz, EntityPlayer me) {
        double dirx = (double)me.func_180425_c().func_177958_n() - px;
        double diry = (double)me.func_180425_c().func_177956_o() - py;
        double dirz = (double)me.func_180425_c().func_177952_p() - pz;
        double len = Math.sqrt(dirx * dirx + diry * diry + dirz * dirz);
        double pitch = Math.asin(diry /= len);
        double yaw = Math.atan2(dirz /= len, dirx /= len);
        pitch = pitch * 180.0 / Math.PI;
        yaw = yaw * 180.0 / Math.PI;
        me.field_70125_A = (float)pitch;
        me.field_70177_z = (float)(yaw += 90.0);
    }

    public static boolean isInHand(EnumHand hand, EntityLivingBase holder, Item item) {
        ItemStack heldItem = holder.func_184586_b(hand);
        return heldItem.func_77973_b() == item;
    }

    public static boolean isInMainHand(EntityLivingBase holder, Item item) {
        return PlayerUtil.isInHand(EnumHand.MAIN_HAND, holder, item);
    }

    public static boolean isInOffHand(EntityLivingBase holder, Item item) {
        return PlayerUtil.isInHand(EnumHand.OFF_HAND, holder, item);
    }

    public static boolean isInEitherHand(EntityLivingBase holder, Item item) {
        return PlayerUtil.isInMainHand(holder, item) || PlayerUtil.isInOffHand(holder, item);
    }

    public static boolean isInOneHand(EntityLivingBase holder, Item item) {
        boolean mainHand = PlayerUtil.isInMainHand(holder, item) && !PlayerUtil.isInOffHand(holder, item);
        boolean offHand = PlayerUtil.isInOffHand(holder, item) && !PlayerUtil.isInMainHand(holder, item);
        return mainHand || offHand;
    }

    public static enum RegenState {
        ALIVE,
        GRACE,
        GRACE_CRIT,
        POST,
        REGENERATING;


        public boolean isGraceful() {
            return this == GRACE || this == GRACE_CRIT;
        }

        public TextComponentTranslation getText() {
            return new TextComponentTranslation("transition.regeneration." + this.name().toLowerCase(), new Object[0]);
        }

        public static enum Transition {
            HAND_GLOW_START,
            HAND_GLOW_TRIGGER,
            ENTER_CRITICAL,
            CRITICAL_DEATH,
            FINISH_REGENERATION,
            END_POST;

        }
    }
}

