/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.util;

import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.common.tiles.TileEntityHandInJar;
import me.swirtzly.regeneration.handlers.RegenObjects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class RegenUtil {
    private static Random rand = new Random();

    public static boolean isSlimSkin(UUID playerUUID) {
        return (playerUUID.hashCode() & 1) == 1;
    }

    public static <T extends Enum<?>> T randomEnum(Class<T> clazz) {
        int x = rand.nextInt(((Enum[])clazz.getEnumConstants()).length);
        return (T)((Enum[])clazz.getEnumConstants())[x];
    }

    public static float randFloat(float min, float max) {
        return rand.nextFloat() * (max - min) + min;
    }

    public static void genCrater(World world, BlockPos pos, int radius) {
        for (int x = pos.func_177958_n() - radius; x < pos.func_177958_n() + radius; ++x) {
            for (int y = pos.func_177956_o() - radius; y < pos.func_177956_o() + radius; ++y) {
                for (int z = pos.func_177952_p() - radius; z < pos.func_177952_p() + radius; ++z) {
                    IBlockState block;
                    double squareDistance = Math.pow(x - pos.func_177958_n(), 2.0) + Math.pow(y - pos.func_177956_o(), 2.0) + Math.pow(z - pos.func_177952_p(), 2.0);
                    if (!(squareDistance <= Math.pow(radius, 2.0)) || (block = world.func_180495_p(new BlockPos(x, y, z))).func_177230_c() == Blocks.field_150357_h) continue;
                    BlockPos blockPos = new BlockPos(x, y, z);
                    if (!(block.func_185887_b(world, blockPos) < 3.0f)) continue;
                    if (!world.field_72995_K) {
                        TileEntity tileEntity;
                        if (world.func_175625_s(new BlockPos(x, y, z)) != null && (tileEntity = world.func_175625_s(new BlockPos(x, y, z))) instanceof IInventory) {
                            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
                            world.func_175666_e(pos, block.func_177230_c());
                        }
                        InventoryHelper.func_180173_a((World)world, (double)x, (double)y, (double)z, (ItemStack)new ItemStack(block.func_177230_c()));
                    }
                    world.func_175656_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    public static void regenerationExplosion(EntityPlayer player) {
        RegenUtil.explodeKnockback((Entity)player, player.field_70170_p, player.func_180425_c(), RegenConfig.onRegen.regenerativeKnockback, RegenConfig.onRegen.regenerativeKnockbackRange);
        RegenUtil.explodeKill((Entity)player, player.field_70170_p, player.func_180425_c(), RegenConfig.onRegen.regenerativeKillRange);
    }

    public static void explodeKnockback(Entity exploder, World world, BlockPos pos, float knockback, int range) {
        world.func_72839_b(exploder, RegenUtil.getReach(pos, range)).forEach(entity -> {
            if (entity instanceof EntityLivingBase && !exploder.field_70128_L) {
                EntityLivingBase victim = (EntityLivingBase)entity;
                if (entity instanceof EntityPlayer && !RegenConfig.onRegen.regenerationKnocksbackPlayers || !victim.func_184222_aU()) {
                    return;
                }
                float densMod = world.func_72842_a(new Vec3d((Vec3i)pos), entity.func_174813_aQ());
                int xr = (int)(-(victim.field_70165_t - exploder.field_70165_t));
                int zr = (int)(-(victim.field_70161_v - exploder.field_70161_v));
                victim.func_70653_a(exploder, knockback * densMod, (double)xr, (double)zr);
            }
        });
    }

    public static void explodeKill(Entity exploder, World world, BlockPos pos, int range) {
        world.func_72839_b(exploder, RegenUtil.getReach(pos, range)).forEach(entity -> {
            if (entity instanceof EntityCreature && entity.func_184222_aU() || entity instanceof EntityPlayer && RegenConfig.onRegen.regenerationKillsPlayers) {
                entity.func_70097_a(RegenObjects.REGEN_DMG_ENERGY_EXPLOSION, 4.0f);
            }
        });
    }

    public static AxisAlignedBB getReach(BlockPos pos, int range) {
        return new AxisAlignedBB(pos.func_177981_b(range).func_177964_d(range).func_177985_f(range), pos.func_177979_c(range).func_177970_e(range).func_177965_g(range));
    }

    public static void resetNextSkin(EntityPlayer player) {
        IRegeneration data = CapabilityRegeneration.getForPlayer(player);
        data.setNextSkin("NONE");
        data.synchronise();
    }

    public static SoundEvent getRandomSound(SoundEvent[] soundEvents, Random random) {
        return soundEvents[random.nextInt(soundEvents.length)];
    }

    public static boolean isSharp(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemSword;
    }

    public static RayTraceResult getPosLookingAt(Entity entity) {
        Vec3d lookVec = entity.func_70040_Z();
        double distance = 10.0;
        int i = 0;
        while ((double)i < distance * 2.0) {
            float scale = (float)i / 2.0f;
            Vec3d pos = entity.func_174791_d().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0).func_178787_e(lookVec.func_186678_a((double)scale));
            if (entity.field_70170_p.func_175665_u(new BlockPos(pos)) && !entity.field_70170_p.func_175623_d(new BlockPos(pos))) {
                return new RayTraceResult(pos, null);
            }
            Vec3d min = pos.func_72441_c(0.25, 0.25, 0.25);
            Vec3d max = pos.func_72441_c(-0.25, -0.25, -0.25);
            Iterator iterator = entity.field_70170_p.func_72839_b(entity, new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c)).iterator();
            if (iterator.hasNext()) {
                Entity e = (Entity)iterator.next();
                return new RayTraceResult(e);
            }
            ++i;
        }
        return new RayTraceResult(entity.func_174791_d().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0).func_178787_e(lookVec.func_186678_a(distance)), null);
    }

    public static TileEntityHandInJar getContainer(RayTraceResult result, World world) {
        BlockPos pos;
        if (result.field_72313_a == RayTraceResult.Type.BLOCK && world.func_175625_s(pos = result.func_178782_a()) instanceof TileEntityHandInJar) {
            return (TileEntityHandInJar)world.func_175625_s(pos);
        }
        return null;
    }
}

