/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.util;

import java.nio.FloatBuffer;
import me.swirtzly.regeneration.util.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.ModelLoader;
import org.lwjgl.opengl.GL11;

public class RenderUtil {
    private static final ResourceLocation VIGNETTE_TEX_PATH = new ResourceLocation("regeneration", "textures/misc/vignette.png");
    public static float renderTick = Minecraft.func_71410_x().func_184121_ak();
    private static float lastBrightnessX = OpenGlHelper.lastBrightnessX;
    private static float lastBrightnessY = OpenGlHelper.lastBrightnessY;

    public static void setLightmapTextureCoords(float x, float y) {
        lastBrightnessX = OpenGlHelper.lastBrightnessX;
        lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)x, (float)y);
    }

    public static void restoreLightMap() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static void setItemRender(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    public static void drawGlowingLine(Vec3d start, Vec3d end, float thickness, Vec3d color, float alpha) {
        if (start == null || end == null) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bb = tessellator.func_178180_c();
        int smoothFactor = Minecraft.func_71410_x().field_71474_y.field_74348_k;
        int layers = 10 + smoothFactor * 20;
        GlStateManager.func_179094_E();
        start = start.func_186678_a(-1.0);
        end = end.func_186678_a(-1.0);
        GlStateManager.func_179137_b((double)(-start.field_72450_a), (double)(-start.field_72448_b), (double)(-start.field_72449_c));
        start = end.func_178788_d(start);
        end = end.func_178788_d(end);
        double x = end.field_72450_a - start.field_72450_a;
        double y = end.field_72448_b - start.field_72448_b;
        double z = end.field_72449_c - start.field_72449_c;
        double diff = MathHelper.func_76133_a((double)(x * x + z * z));
        float yaw = (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(y, diff) * 180.0 / Math.PI));
        GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        for (int layer = 0; layer <= layers; ++layer) {
            if (layer < layers) {
                GlStateManager.func_179131_c((float)((float)color.field_72450_a), (float)((float)color.field_72448_b), (float)((float)color.field_72449_c), (float)(1.0f / (float)layers / 2.0f));
                GlStateManager.func_179132_a((boolean)false);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GlStateManager.func_179132_a((boolean)true);
            }
            double size = (double)thickness + (layer < layers ? (double)layer * (1.25 / (double)layers) : 0.0);
            double d = (layer < layers ? 1.0 - (double)layer * (1.0 / (double)layers) : 0.0) * 0.1;
            double width = 0.0625 * size;
            double height = 0.0625 * size;
            double length = start.func_72438_d(end) + d;
            bb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            bb.func_181662_b(-width, height, length).func_181675_d();
            bb.func_181662_b(width, height, length).func_181675_d();
            bb.func_181662_b(width, height, -d).func_181675_d();
            bb.func_181662_b(-width, height, -d).func_181675_d();
            bb.func_181662_b(width, -height, -d).func_181675_d();
            bb.func_181662_b(width, -height, length).func_181675_d();
            bb.func_181662_b(-width, -height, length).func_181675_d();
            bb.func_181662_b(-width, -height, -d).func_181675_d();
            bb.func_181662_b(-width, -height, -d).func_181675_d();
            bb.func_181662_b(-width, -height, length).func_181675_d();
            bb.func_181662_b(-width, height, length).func_181675_d();
            bb.func_181662_b(-width, height, -d).func_181675_d();
            bb.func_181662_b(width, height, length).func_181675_d();
            bb.func_181662_b(width, -height, length).func_181675_d();
            bb.func_181662_b(width, -height, -d).func_181675_d();
            bb.func_181662_b(width, height, -d).func_181675_d();
            bb.func_181662_b(width, -height, length).func_181675_d();
            bb.func_181662_b(width, height, length).func_181675_d();
            bb.func_181662_b(-width, height, length).func_181675_d();
            bb.func_181662_b(-width, -height, length).func_181675_d();
            bb.func_181662_b(width, -height, -d).func_181675_d();
            bb.func_181662_b(width, height, -d).func_181675_d();
            bb.func_181662_b(-width, height, -d).func_181675_d();
            bb.func_181662_b(-width, -height, -d).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179121_F();
    }

    public static void setupRenderLightning() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)32772);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        RenderUtil.setLightmapTextureCoords(240.0f, 240.0f);
    }

    public static void finishRenderLightning() {
        RenderUtil.restoreLightMap();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public static void drawRect(int left, int top, int right, int bottom, float red, float green, float blue, float alpha) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderVignette(Vec3d color, float a, PlayerUtil.RegenState state) {
        GlStateManager.func_179131_c((float)((float)color.field_72450_a), (float)((float)color.field_72448_b), (float)((float)color.field_72449_c), (float)a);
        GlStateManager.func_179118_c();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(VIGNETTE_TEX_PATH);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        ScaledResolution scaledRes = new ScaledResolution(Minecraft.func_71410_x());
        int z = -89;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(0.0, (double)scaledRes.func_78328_b(), (double)z).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)scaledRes.func_78326_a(), (double)scaledRes.func_78328_b(), (double)z).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)scaledRes.func_78326_a(), 0.0, (double)z).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, (double)z).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static double calculateColorBrightness(Vec3d c) {
        float r = (float)c.field_72450_a;
        float g = (float)c.field_72448_b;
        float b = (float)c.field_72449_c;
        r = (double)r <= 0.03928 ? r / 12.92f : (float)Math.pow(((double)r + 0.055) / 1.055, 2.4);
        g = (double)g <= 0.03928 ? g / 12.92f : (float)Math.pow(((double)g + 0.055) / 1.055, 2.4);
        b = (double)b <= 0.03928 ? b / 12.92f : (float)Math.pow(((double)b + 0.055) / 1.055, 2.4);
        return 0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b;
    }

    public static void drawModelToGui(ModelBase model, int xPos, int yPos, float scale, float rotation) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GL11.glBlendFunc((int)770, (int)771);
        GlStateManager.func_179109_b((float)xPos, (float)yPos, (float)100.0f);
        GlStateManager.func_179114_b((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74520_c();
        GlStateManager.func_187424_a((int)2899, (FloatBuffer)RenderHelper.func_74521_a((float)0.75f, (float)0.75f, (float)0.75f, (float)1.0f));
        GlStateManager.func_179152_a((float)(38.0f * scale), (float)(34.0f * scale), (float)(38.0f * scale));
        GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)1.0f);
        model.func_78088_a((Entity)Minecraft.func_71410_x().field_71439_g, 0.0f, 0.0f, (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa, 0.0f, 0.0f, 0.0625f);
        RenderHelper.func_74518_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179097_i();
        GlStateManager.func_179121_F();
    }

    public static void renderFire(Minecraft mc, String texture) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        TextureAtlasSprite sprite = mc.func_147117_R().getTextureExtry(texture);
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g());
        buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g());
        buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h());
        buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h());
        buffer.func_181662_b(1.0, 0.0, 1.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g());
        buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g());
        buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h());
        buffer.func_181662_b(1.0, 1.0, 1.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h());
        buffer.func_181662_b(0.0, 0.0, 1.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g());
        buffer.func_181662_b(1.0, 0.0, 1.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g());
        buffer.func_181662_b(1.0, 1.0, 1.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h());
        buffer.func_181662_b(0.0, 1.0, 1.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h());
        buffer.func_181662_b(0.0, 0.0, 1.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g());
        buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g());
        buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h());
        buffer.func_181662_b(0.0, 1.0, 1.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h());
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }
}

