/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Objects;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.RegenerationMod;
import me.swirtzly.regeneration.client.skinhandling.SkinChangingHandler;
import me.swirtzly.regeneration.util.FileUtil;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.FileUtils;

public class Trending {
    public static File TRENDING_ALEX = new File(SkinChangingHandler.SKIN_DIRECTORY_ALEX + "/namemc");
    public static File TRENDING_STEVE = new File(SkinChangingHandler.SKIN_DIRECTORY_STEVE + "/namemc");
    public static File USER_ALEX = new File(SkinChangingHandler.SKIN_DIRECTORY_ALEX + "/the_past");
    public static File USER_STEVE = new File(SkinChangingHandler.SKIN_DIRECTORY_STEVE + "/the_past");

    public static void downloadPreviousSkins() {
        if (!RegenConfig.skins.downloadPastSkins) {
            return;
        }
        RegenerationMod.LOG.warn("Refreshing users past skins");
        if (!USER_ALEX.exists()) {
            USER_ALEX.mkdirs();
        }
        long attr = USER_ALEX.lastModified();
        if (System.currentTimeMillis() - attr >= 86400000L || Objects.requireNonNull(USER_ALEX.list()).length == 0) {
            for (int i = 0; i < 5; ++i) {
                try {
                    String url = "https://namemc.com/minecraft-skins/profile/" + Minecraft.func_71410_x().func_110432_I().func_148255_b() + "?page=" + i;
                    for (String skin : Trending.getSkins(url)) {
                        FileUtil.downloadAsPng(new URL(skin), Minecraft.func_71410_x().func_110432_I().func_111285_a() + "_" + System.currentTimeMillis(), USER_ALEX, USER_STEVE);
                    }
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getSkins(String downloadUrl) throws IOException {
        ArrayList<String> skins = new ArrayList<String>();
        try (BufferedReader br = null;){
            String line;
            URL url = new URL(downloadUrl);
            URLConnection uc = url.openConnection();
            uc.connect();
            uc = url.openConnection();
            uc.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.75 Safari/537.36");
            br = new BufferedReader(new InputStreamReader(uc.getInputStream()));
            while ((line = br.readLine()) != null) {
                if (!line.contains("<a href=\"/skin/")) continue;
                String downloadLine = line.replaceAll("<a href=\"/skin/", "").replaceAll("\">", "").replaceAll("        ", "");
                skins.add("https://namemc.com/texture/" + downloadLine + ".png");
            }
        }
        return skins;
    }

    public static void downloadTrendingSkins() throws IOException {
        if (!RegenConfig.skins.downloadTrendingSkins) {
            return;
        }
        File trendingDir = TRENDING_ALEX;
        if (!trendingDir.exists()) {
            trendingDir.mkdirs();
        }
        long attr = trendingDir.lastModified();
        if (System.currentTimeMillis() - attr >= 86400000L || Objects.requireNonNull(trendingDir.list()).length == 0) {
            FileUtils.deleteDirectory((File)trendingDir);
            RegenerationMod.LOG.warn("Refreshing Trending skins");
            for (String skin : Trending.getSkins("https://namemc.com/minecraft-skins")) {
                String cleanName = skin.replaceAll("https://namemc.com/texture/", "").replaceAll(".png", "");
                FileUtil.downloadAsPng(new URL(skin), "trending_" + cleanName, TRENDING_ALEX, TRENDING_STEVE);
            }
        }
    }

    public static void handleDownloads() throws IOException {
        String[] links;
        if (!RegenConfig.skins.downloadInternalSkins) {
            return;
        }
        String PACKS_URL = "https://raw.githubusercontent.com/Swirtzly/Regeneration/skins/index.json";
        for (String link : links = (String[])RegenerationMod.GSON.fromJson(FileUtil.getJsonFromURL(PACKS_URL), String[].class)) {
            FileUtil.unzipSkinPack(link);
        }
    }
}

