/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.client;

import java.util.Random;
import java.util.UUID;
import me.suff.regeneration.RegenConfig;
import me.suff.regeneration.RegenerationMod;
import me.suff.regeneration.client.RegenKeyBinds;
import me.suff.regeneration.client.events.AnimationEvent;
import me.suff.regeneration.client.gui.GuiCustomizer;
import me.suff.regeneration.client.rendering.ATypeRenderer;
import me.suff.regeneration.client.skinhandling.SkinChangingHandler;
import me.suff.regeneration.client.skinhandling.SkinInfo;
import me.suff.regeneration.common.capability.CapabilityRegeneration;
import me.suff.regeneration.common.capability.IRegeneration;
import me.suff.regeneration.common.item.ItemFobWatch;
import me.suff.regeneration.handlers.RegenObjects;
import me.suff.regeneration.network.MessageForceRegen;
import me.suff.regeneration.network.MessageRepairArms;
import me.suff.regeneration.network.MessageTriggerRegeneration;
import me.suff.regeneration.network.NetworkHandler;
import me.suff.regeneration.util.ClientUtil;
import me.suff.regeneration.util.EnumCompatModids;
import me.suff.regeneration.util.RegenState;
import me.suff.regeneration.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.model.ModelBase;
import net.minecraft.client.renderer.entity.model.ModelPlayer;
import net.minecraft.client.renderer.entity.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.MovementInput;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClientEventHandler {
    private static boolean initialJoin = false;

    @SubscribeEvent(receiveCanceled=true)
    public void onAnimate(AnimationEvent.SetRotationAngles event) {
        if (event.getEntity() instanceof EntityPlayer) {
            CapabilityRegeneration.getForPlayer((EntityPlayer)event.getEntity()).ifPresent(data -> {
                if (data.getState() == RegenState.REGENERATING) {
                    ((ATypeRenderer)data.getType().getRenderer()).onAnimateRegen(event);
                }
            });
            boolean isOpen = false;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            ItemStack stack = player.func_184614_ca();
            ItemStack offStack = player.func_184592_cb();
            if (stack.func_77973_b() instanceof ItemFobWatch) {
                boolean bl = isOpen = ItemFobWatch.getOpen(stack) == 1;
                if (isOpen) {
                    event.model.field_178723_h.field_78796_g = -0.1f + event.model.field_78116_c.field_78796_g;
                    event.model.field_178724_i.field_78796_g = 0.1f + event.model.field_78116_c.field_78796_g + 0.4f;
                    event.model.field_178723_h.field_78795_f = -1.5707964f + event.model.field_78116_c.field_78795_f;
                    event.model.field_178724_i.field_78795_f = -1.5707964f + event.model.field_78116_c.field_78795_f;
                    event.setCanceled(true);
                }
            } else if (offStack.func_77973_b() instanceof ItemFobWatch) {
                boolean bl = isOpen = ItemFobWatch.getOpen(stack) == 1;
                if (isOpen) {
                    event.model.field_178723_h.field_78796_g = -0.1f + event.model.field_78116_c.field_78796_g - 0.4f;
                    event.model.field_178724_i.field_78796_g = 0.1f + event.model.field_78116_c.field_78796_g;
                    event.model.field_178723_h.field_78795_f = -1.5707964f + event.model.field_78116_c.field_78795_f;
                    event.model.field_178724_i.field_78795_f = -1.5707964f + event.model.field_78116_c.field_78795_f;
                    event.setCanceled(true);
                }
            }
            if (event.model instanceof ModelPlayer) {
                ModelPlayer playerModel = (ModelPlayer)event.model;
                ModelBase.func_178685_a((ModelRenderer)event.model.field_178723_h, (ModelRenderer)playerModel.field_178732_b);
                ModelBase.func_178685_a((ModelRenderer)event.model.field_178724_i, (ModelRenderer)playerModel.field_178734_a);
            }
        }
    }

    @SubscribeEvent
    public void onJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !initialJoin && Minecraft.func_71410_x().field_71439_g == event.getEntity()) {
            EntityPlayerSP localPlayer = Minecraft.func_71410_x().field_71439_g;
            NetworkHandler.INSTANCE.sendToServer((Object)new MessageRepairArms(localPlayer.func_175154_l().equals("slim") ? SkinInfo.SkinType.ALEX : SkinInfo.SkinType.STEVE));
            initialJoin = true;
        }
    }

    @SubscribeEvent
    public void onTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null) {
            if (SkinChangingHandler.PLAYER_SKINS.size() > 0 || SkinChangingHandler.TYPE_BACKUPS.size() > 0) {
                SkinChangingHandler.TYPE_BACKUPS.clear();
                SkinChangingHandler.PLAYER_SKINS.clear();
                RegenerationMod.LOG.warn("CLEARED CACHE OF PLAYER_SKINS AND TYPE_BACKUPS");
            }
            initialJoin = false;
        }
    }

    @SubscribeEvent
    public void onFov(FOVUpdateEvent event) {
        CapabilityRegeneration.getForPlayer(event.getEntity()).ifPresent(data -> {
            if (data.getState() == RegenState.REGENERATING && ((Boolean)RegenConfig.CLIENT.fovChange.get()).booleanValue()) {
                event.setNewfov((float)data.getTicksAnimated());
            }
        });
    }

    @SubscribeEvent
    public void onKeyPress(InputUpdateEvent e) {
        if (EnumCompatModids.LCCORE.isLoaded()) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r == null && minecraft.field_71439_g != null) {
            ClientUtil.keyBind = RegenKeyBinds.getRegenerateNowDisplayName();
        }
        if (minecraft.field_71439_g != null) {
            CapabilityRegeneration.getForPlayer((EntityPlayer)minecraft.field_71439_g).ifPresent(data -> {
                if (RegenKeyBinds.REGEN_NOW.func_151468_f() && data.getState().isGraceful()) {
                    NetworkHandler.INSTANCE.sendToServer((Object)new MessageTriggerRegeneration());
                }
                if (RegenKeyBinds.REGEN_FORCEFULLY.func_151468_f() && data.getState() == RegenState.ALIVE) {
                    NetworkHandler.INSTANCE.sendToServer((Object)new MessageForceRegen());
                }
                if (RegenKeyBinds.REGEN_CUSTOMISE.func_151468_f()) {
                    Minecraft.func_71410_x().func_147108_a(null);
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiCustomizer());
                }
            });
        }
    }

    @SubscribeEvent
    public void onSortofWorldJoin(LivingEvent.LivingUpdateEvent e) {
        if (!(e.getEntity() instanceof EntityPlayer) || Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        EntityPlayer player = (EntityPlayer)e.getEntity();
        if (player.field_70173_aa == 50) {
            UUID clientUUID = Minecraft.func_71410_x().field_71439_g.func_110124_au();
            CapabilityRegeneration.getForPlayer(player).ifPresent(cap -> {
                if (cap.areHandsGlowing()) {
                    ClientUtil.playSound((Entity)cap.getPlayer(), RegenObjects.Sounds.HAND_GLOW.getRegistryName(), SoundCategory.PLAYERS, true, () -> !cap.areHandsGlowing(), 0.5f);
                }
                if (cap.getState().equals((Object)RegenState.REGENERATING)) {
                    ClientUtil.playSound((Entity)cap.getPlayer(), RegenObjects.Sounds.REGENERATION.getRegistryName(), SoundCategory.PLAYERS, true, () -> !cap.getState().equals((Object)RegenState.REGENERATING), 1.0f);
                }
                if (cap.getState().isGraceful() && clientUUID == player.func_110124_au()) {
                    ClientUtil.playSound((Entity)cap.getPlayer(), RegenObjects.Sounds.CRITICAL_STAGE.getRegistryName(), SoundCategory.PLAYERS, true, () -> !cap.getState().equals((Object)RegenState.GRACE_CRIT), 1.0f);
                    ClientUtil.playSound((Entity)cap.getPlayer(), RegenObjects.Sounds.HEART_BEAT.getRegistryName(), SoundCategory.PLAYERS, true, () -> !cap.getState().isGraceful(), 0.2f);
                    ClientUtil.playSound((Entity)cap.getPlayer(), RegenObjects.Sounds.GRACE_HUM.getRegistryName(), SoundCategory.AMBIENT, true, () -> cap.getState() != RegenState.GRACE, 1.5f);
                }
            });
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent e) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        SkinInfo skin = SkinChangingHandler.PLAYER_SKINS.get(player.func_110124_au());
        if (skin != null) {
            SkinChangingHandler.setPlayerSkin((AbstractClientPlayer)player, skin.getSkinTextureLocation());
        }
        float factor = 0.2f;
        if (player.func_184614_ca().func_77973_b() != Items.field_190931_a || mc.field_71474_y.field_74320_O > 0) {
            return;
        }
        CapabilityRegeneration.getForPlayer((EntityPlayer)player).ifPresent(cap -> {
            if (!cap.areHandsGlowing()) {
                return;
            }
            GlStateManager.func_179094_E();
            float leftHandedFactor = mc.field_71474_y.field_186715_A.equals((Object)EnumHandSide.RIGHT) ? 1.0f : -1.0f;
            GlStateManager.func_179109_b((float)(0.33f * leftHandedFactor), (float)-0.23f, (float)-0.5f);
            GlStateManager.func_179109_b((float)(-0.8f * player.field_70733_aJ * leftHandedFactor), (float)(-0.8f * player.field_70733_aJ), (float)(-0.4f * player.field_70733_aJ));
            GlStateManager.func_179109_b((float)(-(player.field_71154_f - player.field_71163_h) / 400.0f), (float)((player.field_71155_g - player.field_71164_i) / 500.0f), (float)0.0f);
            RenderUtil.setupRenderLightning();
            GlStateManager.func_179114_b((float)(((float)mc.field_71439_g.field_70173_aa + RenderUtil.renderTick) / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            for (int i = 0; i < 15; ++i) {
                GlStateManager.func_179114_b((float)(((float)mc.field_71439_g.field_70173_aa + RenderUtil.renderTick) * (float)i / 70.0f), (float)1.0f, (float)1.0f, (float)0.0f);
                Vec3d primaryColor = cap.getPrimaryColor();
                Random rand = player.field_70170_p.field_73012_v;
                RenderUtil.drawGlowingLine(new Vec3d((double)(-factor / 2.0f + rand.nextFloat() * factor), (double)(-factor / 2.0f + rand.nextFloat() * factor), (double)(-factor / 2.0f + rand.nextFloat() * factor)), new Vec3d((double)(-factor / 2.0f + rand.nextFloat() * factor), (double)(-factor / 2.0f + rand.nextFloat() * factor), (double)(-factor / 2.0f + rand.nextFloat() * factor)), 0.1f, primaryColor, 0.0f);
            }
            RenderUtil.finishRenderLightning();
            GlStateManager.func_179121_F();
        });
    }

    @SubscribeEvent
    public void onRenderGui(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        CapabilityRegeneration.getForPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g).ifPresent(cap -> {
            String warning = null;
            switch (cap.getState()) {
                case GRACE: {
                    RenderUtil.renderVignette(cap.getPrimaryColor(), 0.3f, cap.getState());
                    warning = new TextComponentTranslation("regeneration.messages.warning.grace", new Object[]{new TextComponentTranslation(ClientUtil.keyBind, new Object[0]).func_150261_e()}).func_150261_e();
                    break;
                }
                case GRACE_CRIT: {
                    RenderUtil.renderVignette(new Vec3d(1.0, 0.0, 0.0), 0.5f, cap.getState());
                    warning = new TextComponentTranslation("regeneration.messages.warning.grace_critical", new Object[]{new TextComponentTranslation(ClientUtil.keyBind, new Object[0]).func_150261_e()}).func_150261_e();
                    break;
                }
                case REGENERATING: {
                    RenderUtil.renderVignette(cap.getSecondaryColor(), 0.5f, cap.getState());
                }
            }
            if (warning != null) {
                Minecraft.func_71410_x().field_71466_p.func_211126_b(warning, (float)(Minecraft.func_71410_x().field_195558_d.func_198107_o() / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(warning) / 2), 4.0f, -1);
            }
        });
    }

    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent e) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null || mc.field_71441_e == null) {
            return;
        }
        if (e.getName().equals("entity.generic.explode")) {
            SimpleSound sound = SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187539_bB, (float)1.0f, (float)0.2f);
            mc.field_71441_e.field_73010_i.forEach(arg_0 -> ClientEventHandler.lambda$onPlaySound$12(mc, e, (ISound)sound, arg_0));
            CapabilityRegeneration.getForPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g).ifPresent(arg_0 -> ClientEventHandler.lambda$onPlaySound$13(e, (ISound)sound, arg_0));
        }
    }

    @SubscribeEvent
    public void onSetupFogDensity(EntityViewRenderEvent.FogDensity event) {
        Minecraft.func_71410_x().field_71439_g.getCapability(CapabilityRegeneration.CAPABILITY).ifPresent(data -> {
            if (data.getState() == RegenState.GRACE_CRIT) {
                GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                event.setCanceled(true);
                float amount = MathHelper.func_76134_b((float)((float)data.getPlayer().field_70173_aa * 0.06f)) * -0.09f;
                event.setDensity(amount);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientChatRecieved(ClientChatReceivedEvent e) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (e.getType() != ChatType.CHAT) {
            return;
        }
        CapabilityRegeneration.getForPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g).ifPresent(data -> {
            if (data.getState() != RegenState.POST) {
                return;
            }
            if (player.field_70170_p.field_73012_v.nextBoolean()) {
                String[] words;
                String message = e.getMessage().func_150261_e();
                TextComponentString newMessage = new TextComponentString("");
                for (String word : words = message.split(" ")) {
                    TextComponentString txtComp;
                    if (word.equals(words[0])) {
                        TextComponentString name = new TextComponentString(word + " ");
                        newMessage.func_150257_a((ITextComponent)name);
                        continue;
                    }
                    if (player.field_70170_p.field_73012_v.nextBoolean()) {
                        txtComp = new TextComponentString(this.getColoredText("&k" + word + "&r "));
                        txtComp.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(word)));
                        newMessage.func_150257_a((ITextComponent)txtComp);
                        continue;
                    }
                    txtComp = new TextComponentString(word + " ");
                    newMessage.func_150257_a((ITextComponent)txtComp);
                }
                e.setMessage((ITextComponent)newMessage);
            }
        });
    }

    public String getColoredText(String msg) {
        return msg.replaceAll("&", String.valueOf('\u00a7'));
    }

    @SubscribeEvent
    public void keyInput(InputUpdateEvent e) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        CapabilityRegeneration.getForPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g).ifPresent(cap -> {
            if (cap.getState() == RegenState.REGENERATING) {
                MovementInput moveType = e.getMovementInput();
                moveType.field_187258_f = false;
                moveType.field_187257_e = false;
                moveType.field_187256_d = false;
                moveType.field_78901_c = false;
                moveType.field_192832_b = 0.0f;
                moveType.field_78899_d = false;
                moveType.field_78902_a = 0.0f;
            }
        });
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntityLiving();
            SkinChangingHandler.PLAYER_SKINS.remove(player.func_110124_au());
            if (player.func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                ClientUtil.sendSkinResetPacket();
            }
        }
    }

    @SubscribeEvent
    public void onClientLeaveServer(TickEvent.ClientTickEvent e) {
        if (Minecraft.func_71410_x().field_71441_e == null && Minecraft.func_71410_x().field_71439_g == null) {
            SkinChangingHandler.PLAYER_SKINS.clear();
            SkinChangingHandler.TYPE_BACKUPS.clear();
        }
    }

    private static /* synthetic */ void lambda$onPlaySound$13(PlaySoundEvent e, ISound sound, IRegeneration cap) {
        if (cap.getState() == RegenState.REGENERATING) {
            e.setResultSound(sound);
        }
    }

    private static /* synthetic */ void lambda$onPlaySound$12(Minecraft mc, PlaySoundEvent e, ISound sound, EntityPlayer player) {
        CapabilityRegeneration.getForPlayer(player).ifPresent(cap -> {
            if (mc.field_71439_g != player && mc.field_71439_g.func_70032_d((Entity)player) < 40.0f && cap.getState().equals((Object)RegenState.REGENERATING)) {
                e.setResultSound(sound);
            }
        });
    }
}

