/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.client.rendering;

import java.util.Random;
import me.suff.regeneration.client.rendering.ATypeRenderer;
import me.suff.regeneration.common.capability.CapabilityRegeneration;
import me.suff.regeneration.common.capability.IRegeneration;
import me.suff.regeneration.util.RegenState;
import me.suff.regeneration.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.ModelBase;
import net.minecraft.client.renderer.entity.model.ModelPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class LayerRegeneration
implements LayerRenderer<EntityPlayer> {
    public static final ModelPlayer playerModelSteve = new ModelPlayer(0.1f, false);
    private static final ResourceLocation GLOW_TEXTURE = new ResourceLocation("regeneration", "textures/misc/post.png");
    private RenderPlayer playerRenderer;

    public LayerRegeneration(RenderPlayer playerRenderer) {
        this.playerRenderer = playerRenderer;
    }

    public void render(EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        CapabilityRegeneration.getForPlayer(player).ifPresent(cap -> {
            if (cap.getState() == RegenState.REGENERATING) {
                ((ATypeRenderer)cap.getType().getRenderer()).onRenderRegenerationLayer(cap.getType(), (RenderLivingBase<?>)this.playerRenderer, (IRegeneration)cap, player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
            } else if (cap.areHandsGlowing()) {
                this.renderGlowingHands(player, (IRegeneration)cap, scale);
            }
            if (cap.getState() == RegenState.POST && player.field_70737_aN > 0) {
                this.renderPost(player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
            }
        });
    }

    private void renderGlowingHands(EntityPlayer player, IRegeneration handler, float scale) {
        Vec3d primaryColor = handler.getPrimaryColor();
        Vec3d secondaryColor = handler.getSecondaryColor();
        Minecraft mc = Minecraft.func_71410_x();
        Random rand = player.field_70170_p.field_73012_v;
        float f = 0.2f;
        for (int j = 0; j < 2; ++j) {
            RenderUtil.setupRenderLightning();
            if (j == 0) {
                this.playerRenderer.func_177087_b().field_178723_h.func_78794_c(scale);
            } else {
                this.playerRenderer.func_177087_b().field_178724_i.func_78794_c(scale);
            }
            GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
            if (player.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.3f, (float)0.0f);
            GlStateManager.func_179114_b((float)(((float)mc.field_71439_g.field_70173_aa + RenderUtil.renderTick) / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            for (int i = 0; i < 7; ++i) {
                GlStateManager.func_179114_b((float)(((float)mc.field_71439_g.field_70173_aa + RenderUtil.renderTick) * (float)i / 70.0f), (float)1.0f, (float)1.0f, (float)0.0f);
                RenderUtil.drawGlowingLine(new Vec3d((double)(-f / 2.0f + rand.nextFloat() * f), (double)(-f / 2.0f + rand.nextFloat() * f), (double)(-f / 2.0f + rand.nextFloat() * f)), new Vec3d((double)(-f / 2.0f + rand.nextFloat() * f), (double)(-f / 2.0f + rand.nextFloat() * f), (double)(-f / 2.0f + rand.nextFloat() * f)), 0.1f, primaryColor, 0.0f);
                RenderUtil.drawGlowingLine(new Vec3d((double)(-f / 2.0f + rand.nextFloat() * f), (double)(-f / 2.0f + rand.nextFloat() * f), (double)(-f / 2.0f + rand.nextFloat() * f)), new Vec3d((double)(-f / 2.0f + rand.nextFloat() * f), (double)(-f / 2.0f + rand.nextFloat() * f), (double)(-f / 2.0f + rand.nextFloat() * f)), 0.1f, secondaryColor, 0.0f);
            }
            RenderUtil.finishRenderLightning();
        }
    }

    public void renderPost(EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        boolean flag = player.func_82150_aj();
        ModelPlayer playerModel = this.playerRenderer.func_177087_b();
        GlStateManager.func_179132_a((!flag ? 1 : 0) != 0);
        this.playerRenderer.func_110776_a(GLOW_TEXTURE);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        float f = (float)player.field_70173_aa + partialTicks;
        GlStateManager.func_179109_b((float)(f * 0.01f), (float)(f * 0.01f), (float)0.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        playerModel.func_178686_a((ModelBase)this.playerRenderer.func_177087_b());
        Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
        playerModel.func_78088_a((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)flag);
    }

    public boolean func_177142_b() {
        return false;
    }
}

