/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.client.skinhandling;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ImageDownloadAlt
extends SimpleTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final AtomicInteger TEXTURE_DOWNLOADER_THREAD_ID = new AtomicInteger(0);
    @Nullable
    private final File cacheFile;
    private final String imageUrl;
    @Nullable
    private final IImageBuffer imageBuffer;
    private final AbstractClientPlayer player;
    @Nullable
    private Thread imageThread;
    private volatile boolean textureUploaded;

    public ImageDownloadAlt(@Nullable File cacheFileIn, String imageUrlIn, ResourceLocation textureResourceLocation, @Nullable IImageBuffer imageBufferIn, AbstractClientPlayer player) {
        super(textureResourceLocation);
        this.cacheFile = cacheFileIn;
        this.imageUrl = imageUrlIn;
        this.imageBuffer = imageBufferIn;
        this.player = player;
    }

    private void uploadImage(NativeImage nativeImageIn) {
        TextureUtil.func_110991_a((int)this.func_110552_b(), (int)nativeImageIn.func_195702_a(), (int)nativeImageIn.func_195714_b());
        nativeImageIn.func_195697_a(0, 0, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(NativeImage nativeImageIn) {
        if (this.imageBuffer != null) {
            this.imageBuffer.func_152634_a();
        }
        ImageDownloadAlt imageDownloadAlt = this;
        synchronized (imageDownloadAlt) {
            this.uploadImage(nativeImageIn);
            this.textureUploaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_195413_a(IResourceManager manager) throws IOException {
        if (!this.textureUploaded) {
            ImageDownloadAlt imageDownloadAlt = this;
            synchronized (imageDownloadAlt) {
                super.func_195413_a(manager);
                this.textureUploaded = true;
            }
        }
        if (this.imageThread == null) {
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                LOGGER.debug("Loading http texture from local cache ({})", (Object)this.cacheFile);
                try (NativeImage nativeimage = null;){
                    nativeimage = NativeImage.func_195713_a((InputStream)new FileInputStream(this.cacheFile));
                    if (this.imageBuffer != null) {
                        nativeimage = this.imageBuffer.func_195786_a(nativeimage);
                    }
                    this.setImage(nativeimage);
                }
            } else {
                this.loadTextureFromServer();
            }
        }
    }

    protected void loadTextureFromServer() {
        this.imageThread = new Thread("Texture Downloader #" + TEXTURE_DOWNLOADER_THREAD_ID.incrementAndGet()){

            @Override
            public void run() {
                HttpURLConnection httpurlconnection = null;
                LOGGER.debug("Downloading http texture from {} to {}", (Object)ImageDownloadAlt.this.imageUrl, (Object)ImageDownloadAlt.this.cacheFile);
                try {
                    httpurlconnection = (HttpURLConnection)new URL(ImageDownloadAlt.this.imageUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
                    httpurlconnection.setDoInput(true);
                    httpurlconnection.setDoOutput(false);
                    httpurlconnection.connect();
                    if (httpurlconnection.getResponseCode() / 100 == 2) {
                        InputStream inputstream;
                        if (ImageDownloadAlt.this.cacheFile != null) {
                            FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)ImageDownloadAlt.this.cacheFile);
                            inputstream = new FileInputStream(ImageDownloadAlt.this.cacheFile);
                        } else {
                            inputstream = httpurlconnection.getInputStream();
                        }
                        Minecraft.func_71410_x().func_152344_a(() -> {
                            NativeImage nativeimage = null;
                            try {
                                nativeimage = NativeImage.func_195713_a((InputStream)inputstream);
                                if (ImageDownloadAlt.this.imageBuffer != null) {
                                    nativeimage = ImageDownloadAlt.this.imageBuffer.func_195786_a(nativeimage);
                                }
                            }
                            catch (IOException ioexception) {
                                LOGGER.warn("Error while loading the skin texture", (Throwable)ioexception);
                            }
                            finally {
                                if (nativeimage != null) {
                                    nativeimage.close();
                                }
                                IOUtils.closeQuietly((InputStream)inputstream);
                            }
                        });
                        return;
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Couldn't download http texture", (Throwable)exception);
                    return;
                }
                finally {
                    if (httpurlconnection != null) {
                        httpurlconnection.disconnect();
                    }
                }
            }
        };
        this.imageThread.setDaemon(true);
        this.imageThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER));
        this.imageThread.start();
    }
}

