/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.client.skinhandling;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import me.suff.regeneration.RegenConfig;
import me.suff.regeneration.RegenerationMod;
import me.suff.regeneration.client.rendering.ATypeRenderer;
import me.suff.regeneration.client.skinhandling.ImageBufferDownloadAlt;
import me.suff.regeneration.client.skinhandling.ImageDownloadAlt;
import me.suff.regeneration.client.skinhandling.ImageFixer;
import me.suff.regeneration.client.skinhandling.SkinInfo;
import me.suff.regeneration.common.capability.CapabilityRegeneration;
import me.suff.regeneration.common.capability.IRegeneration;
import me.suff.regeneration.network.MessageUpdateSkin;
import me.suff.regeneration.network.NetworkHandler;
import me.suff.regeneration.util.ClientUtil;
import me.suff.regeneration.util.RegenState;
import me.suff.regeneration.util.RegenUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.system.MemoryStack;

@OnlyIn(value=Dist.CLIENT)
public class SkinChangingHandler {
    public static final File SKIN_DIRECTORY = new File((String)RegenConfig.CLIENT.skinDir.get() + "/Regeneration Data/skins/");
    public static final Map<UUID, SkinInfo> PLAYER_SKINS = new HashMap<UUID, SkinInfo>();
    public static final File SKIN_DIRECTORY_STEVE = new File(SKIN_DIRECTORY, "/steve");
    public static final File SKIN_DIRECTORY_ALEX = new File(SKIN_DIRECTORY, "/alex");
    public static final Logger SKIN_LOG = LogManager.getLogger(SkinChangingHandler.class);
    public static final Map<UUID, SkinInfo.SkinType> TYPE_BACKUPS = new HashMap<UUID, SkinInfo.SkinType>();
    private static final Random RAND = new Random();

    private static String imageToPixelData(File file) throws IOException {
        byte[] fileContent = FileUtils.readFileToByteArray((File)file);
        return Base64.getEncoder().encodeToString(fileContent);
    }

    private static NativeImage toImage(EntityPlayer player, String imageData, boolean write) throws IOException {
        NativeImage image = SkinChangingHandler.decodeToImage(imageData);
        if (image == null || write) {
            // empty if block
        }
        return image;
    }

    public static NativeImage decodeToImage(String imageString) throws IOException {
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.UTF8((CharSequence)imageString, false);
            ByteBuffer bytebuffer1 = Base64.getDecoder().decode(bytebuffer);
            ByteBuffer bytebuffer2 = memorystack.malloc(bytebuffer1.remaining());
            bytebuffer2.put(bytebuffer1);
            bytebuffer2.rewind();
            NativeImage nativeImage = NativeImage.func_195704_a((ByteBuffer)bytebuffer2);
            return nativeImage;
        }
    }

    public static void sendSkinUpdate(Random random, EntityPlayer player) {
        if (Minecraft.func_71410_x().field_71439_g.func_110124_au() != player.func_110124_au()) {
            return;
        }
        CapabilityRegeneration.getForPlayer(player).ifPresent(cap -> {
            if (((Boolean)RegenConfig.CLIENT.changeMySkin.get()).booleanValue()) {
                boolean isAlex = cap.getPreferredModel().isAlex();
                File skin = SkinChangingHandler.chooseRandomSkin(random, isAlex);
                RegenerationMod.LOG.info(skin + " was choosen");
                String pixelData = "none";
                try {
                    pixelData = SkinChangingHandler.imageToPixelData(skin);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                cap.setEncodedSkin(pixelData);
                NetworkHandler.sendToServer(new MessageUpdateSkin(pixelData, isAlex));
            } else {
                ClientUtil.sendSkinResetPacket();
            }
        });
    }

    private static File chooseRandomSkin(Random rand, boolean isAlex) {
        File skins = isAlex ? SKIN_DIRECTORY_ALEX : SKIN_DIRECTORY_STEVE;
        Collection folderFiles = FileUtils.listFiles((File)skins, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        if (folderFiles.isEmpty()) {
            folderFiles = FileUtils.listFiles((File)skins, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        }
        return (File)folderFiles.toArray()[rand.nextInt(folderFiles.size())];
    }

    private static SkinInfo getSkinInfo(AbstractClientPlayer player, IRegeneration data, boolean write) throws IOException {
        ResourceLocation resourceLocation;
        SkinInfo.SkinType skinType = null;
        if (data.getEncodedSkin().equals("none") || data.getEncodedSkin().equals(" ") || data.getEncodedSkin().equals("")) {
            resourceLocation = SkinChangingHandler.getMojangSkin(player);
            skinType = SkinChangingHandler.wasAlex((EntityPlayer)player) ? SkinInfo.SkinType.ALEX : SkinInfo.SkinType.STEVE;
        } else {
            NativeImage bufferedImage = SkinChangingHandler.toImage((EntityPlayer)player, data.getEncodedSkin(), write);
            if ((bufferedImage = ImageFixer.parseUserSkin(bufferedImage)) == null) {
                resourceLocation = DefaultPlayerSkin.func_177334_a((UUID)player.func_110124_au());
            } else {
                DynamicTexture tex = new DynamicTexture(bufferedImage);
                resourceLocation = Minecraft.func_71410_x().func_110434_K().func_110578_a(player.func_200200_C_().func_150261_e().toLowerCase() + "_skin_" + System.currentTimeMillis(), tex);
                skinType = data.getSkinType();
            }
        }
        return new SkinInfo(resourceLocation, skinType);
    }

    public static boolean wasAlex(EntityPlayer player) {
        if (TYPE_BACKUPS.containsKey(player.func_110124_au())) {
            return TYPE_BACKUPS.get(player.func_110124_au()).getMojangType().equals("slim");
        }
        return true;
    }

    private static ResourceLocation getMojangSkin(AbstractClientPlayer player) {
        Map map = Minecraft.func_71410_x().func_152342_ad().func_152788_a(player.func_146103_bH());
        if (map.isEmpty()) {
            map = Minecraft.func_71410_x().func_152347_ac().getTextures(Minecraft.func_71410_x().func_152347_ac().fillProfileProperties(player.func_146103_bH(), false), false);
        }
        if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            MinecraftProfileTexture profile = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
            File dir = new File((File)ObfuscationReflectionHelper.getPrivateValue(SkinManager.class, (Object)Minecraft.func_71410_x().func_152342_ad(), (int)2), profile.getHash().substring(0, 2));
            File file = new File(dir, profile.getHash());
            if (file.exists()) {
                file.delete();
            }
            ResourceLocation location = new ResourceLocation("skins/" + profile.getHash());
            SkinChangingHandler.loadTexture(file, location, DefaultPlayerSkin.func_177335_a(), profile.getUrl(), player);
            SkinChangingHandler.setPlayerSkin(player, location);
            return player.func_110306_p();
        }
        return DefaultPlayerSkin.func_177335_a();
    }

    private static ITextureObject loadTexture(File file, ResourceLocation resource, ResourceLocation def, String par1Str, AbstractClientPlayer player) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        Object object = texturemanager.func_110581_b(resource);
        if (object == null) {
            object = new ImageDownloadAlt(file, par1Str, def, new ImageBufferDownloadAlt(), player);
            texturemanager.func_110579_a(resource, object);
        }
        return object;
    }

    public static void setPlayerSkin(AbstractClientPlayer player, ResourceLocation texture) {
        if (player.func_110306_p() == texture) {
            return;
        }
        NetworkPlayerInfo playerInfo = (NetworkPlayerInfo)ObfuscationReflectionHelper.getPrivateValue(AbstractClientPlayer.class, (Object)player, (int)0);
        if (playerInfo == null) {
            return;
        }
        Map playerTextures = (Map)ObfuscationReflectionHelper.getPrivateValue(NetworkPlayerInfo.class, (Object)playerInfo, (int)1);
        playerTextures.put(MinecraftProfileTexture.Type.SKIN, texture);
        if (texture == null) {
            ObfuscationReflectionHelper.setPrivateValue(NetworkPlayerInfo.class, (Object)playerInfo, (Object)false, (int)4);
        }
    }

    public static void setPlayerSkinType(AbstractClientPlayer player, SkinInfo.SkinType skinType) {
        if (skinType.getMojangType().equals(player.func_175154_l())) {
            return;
        }
        if (!TYPE_BACKUPS.containsKey(player.func_110124_au())) {
            TYPE_BACKUPS.put(player.func_110124_au(), player.func_175154_l().equals("slim") ? SkinInfo.SkinType.ALEX : SkinInfo.SkinType.STEVE);
        }
        NetworkPlayerInfo playerInfo = (NetworkPlayerInfo)ObfuscationReflectionHelper.getPrivateValue(AbstractClientPlayer.class, (Object)player, (int)0);
        ObfuscationReflectionHelper.setPrivateValue(NetworkPlayerInfo.class, (Object)playerInfo, (Object)skinType.getMojangType(), (int)5);
    }

    public static void addType(AbstractClientPlayer player) {
        if (player == null || TYPE_BACKUPS.containsKey(player.func_110124_au())) {
            return;
        }
        TYPE_BACKUPS.put(player.func_110124_au(), player.func_175154_l().equals("slim") ? SkinInfo.SkinType.ALEX : SkinInfo.SkinType.STEVE);
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre e) {
        AbstractClientPlayer player = (AbstractClientPlayer)e.getEntityPlayer();
        SkinChangingHandler.addType(player);
        CapabilityRegeneration.getForPlayer((EntityPlayer)player).ifPresent(cap -> {
            if (player.field_70173_aa == 20) {
                SkinInfo oldSkinInfo = PLAYER_SKINS.get(player.func_110124_au());
                if (oldSkinInfo != null) {
                    // empty if block
                }
                PLAYER_SKINS.remove(player.func_110124_au());
            }
            if (cap.getState() == RegenState.REGENERATING) {
                if ((double)cap.getTicksAnimated() > 0.7) {
                    this.setSkinFromData(player, CapabilityRegeneration.getForPlayer((EntityPlayer)player), false);
                }
                ((ATypeRenderer)cap.getType().getRenderer()).onRenderRegeneratingPlayerPre(cap.getType(), e, (IRegeneration)cap);
            } else if (!PLAYER_SKINS.containsKey(player.func_110124_au())) {
                this.setSkinFromData(player, CapabilityRegeneration.getForPlayer((EntityPlayer)player), true);
            } else {
                SkinInfo skin = PLAYER_SKINS.get(player.func_110124_au());
                if (skin == null) {
                    return;
                }
                if (skin.getSkinTextureLocation() != null) {
                    SkinChangingHandler.setPlayerSkin(player, skin.getSkinTextureLocation());
                }
                if (skin.getSkintype() != null) {
                    SkinChangingHandler.setPlayerSkinType(player, skin.getSkintype());
                }
            }
        });
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Post e) {
        AbstractClientPlayer player = (AbstractClientPlayer)e.getEntityPlayer();
        CapabilityRegeneration.getForPlayer((EntityPlayer)player).ifPresent(cap -> {
            if (cap.getState() == RegenState.REGENERATING) {
                ((ATypeRenderer)cap.getType().getRenderer()).onRenderRegeneratingPlayerPost(cap.getType(), e, (IRegeneration)cap);
            }
        });
    }

    private void setSkinFromData(AbstractClientPlayer player, LazyOptional<IRegeneration> cap, boolean write) {
        cap.ifPresent(data -> {
            SkinInfo skinInfo = null;
            try {
                skinInfo = SkinChangingHandler.getSkinInfo(player, data, write);
            }
            catch (IOException e1) {
                RegenerationMod.LOG.error("Error creating skin for: " + player.func_200200_C_().func_150261_e() + " " + e1.getMessage());
            }
            if (skinInfo != null) {
                SkinChangingHandler.setPlayerSkin(player, skinInfo.getSkinTextureLocation());
            }
            if (skinInfo != null) {
                SkinChangingHandler.setPlayerSkinType(player, skinInfo.getSkintype());
            }
            PLAYER_SKINS.put(player.func_146103_bH().getId(), skinInfo);
        });
    }

    public static enum EnumChoices implements RegenUtil.IEnum
    {
        ALEX(true),
        STEVE(false),
        EITHER(true);

        private boolean isAlex;

        private EnumChoices(boolean b) {
            this.isAlex = b;
        }

        public boolean isAlex() {
            if (this == EITHER) {
                return RAND.nextBoolean();
            }
            return this.isAlex;
        }
    }
}

