/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.common.capability;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.suff.regeneration.RegenConfig;
import me.suff.regeneration.RegenerationMod;
import me.suff.regeneration.client.skinhandling.SkinChangingHandler;
import me.suff.regeneration.client.skinhandling.SkinInfo;
import me.suff.regeneration.common.capability.IRegeneration;
import me.suff.regeneration.common.capability.IRegenerationStateManager;
import me.suff.regeneration.common.entity.EntityLindos;
import me.suff.regeneration.common.types.IRegenType;
import me.suff.regeneration.common.types.TypeFiery;
import me.suff.regeneration.debugger.util.DebuggableScheduledAction;
import me.suff.regeneration.handlers.ActingForwarder;
import me.suff.regeneration.handlers.RegenObjects;
import me.suff.regeneration.network.MessageSynchronisationRequest;
import me.suff.regeneration.network.MessageSynchroniseRegeneration;
import me.suff.regeneration.network.NetworkHandler;
import me.suff.regeneration.util.PlayerUtil;
import me.suff.regeneration.util.RegenState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.apache.commons.lang3.tuple.Pair;

public class CapabilityRegeneration
implements IRegeneration {
    @CapabilityInject(value=IRegeneration.class)
    public static final Capability<IRegeneration> CAPABILITY = null;
    public static final ResourceLocation CAP_REGEN_ID = new ResourceLocation("regeneration", "regeneration");
    private final EntityPlayer player;
    private final RegenerationStateManager stateManager;
    public String deathSource = "";
    private boolean didSetup = false;
    private boolean traitActive = true;
    private int regenerationsLeft;
    private RegenState state = RegenState.ALIVE;
    private IRegenType<?> type = new TypeFiery();
    private String ENCODED_SKIN = "none";
    private SkinInfo.SkinType skinType = SkinInfo.SkinType.ALEX;
    private SkinChangingHandler.EnumChoices preferredModel = SkinChangingHandler.EnumChoices.EITHER;
    private float primaryRed = 0.93f;
    private float primaryGreen = 0.61f;
    private float primaryBlue = 0.0f;
    private float secondaryRed = 1.0f;
    private float secondaryGreen = 0.5f;
    private float secondaryBlue = 0.18f;
    private ResourceLocation traitLocation = new ResourceLocation("regeneration", "boring");
    private int ticksAnimated = 0;
    private SkinInfo.SkinType vanillaSkin = SkinInfo.SkinType.ALEX;
    private boolean handsAreGlowingClient;

    public CapabilityRegeneration() {
        this.player = null;
        this.stateManager = null;
    }

    public CapabilityRegeneration(EntityPlayer player) {
        this.player = player;
        this.stateManager = !player.field_70170_p.field_72995_K ? new RegenerationStateManager() : null;
    }

    @Nonnull
    public static LazyOptional<IRegeneration> getForPlayer(EntityPlayer player) {
        return player.getCapability(CAPABILITY, null);
    }

    @Override
    public void tick() {
        if (!this.didSetup && this.player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.sendToServer((Object)new MessageSynchronisationRequest(this.player.func_110124_au()));
            this.didSetup = true;
        }
        if (this.getEncodedSkin().toLowerCase().equals("NONE") && this.getSkinType() != this.getVanillaType()) {
            this.setSkinType(this.getVanillaType().name());
        }
        if (this.getRegenerationsLeft() > (Integer)RegenConfig.COMMON.regenCapacity.get() && !((Boolean)RegenConfig.COMMON.infiniteRegeneration.get()).booleanValue()) {
            this.regenerationsLeft = (Integer)RegenConfig.COMMON.regenCapacity.get();
            RegenerationMod.LOG.info("Correcting the amount of Regenerations &s has", (Object)this.player.func_200200_C_());
        }
        if (!this.player.field_70170_p.field_72995_K && this.state != RegenState.ALIVE) {
            this.stateManager.tick();
        }
        if (this.state == RegenState.REGENERATING) {
            this.type.onUpdateMidRegen(this.player, CapabilityRegeneration.getForPlayer(this.player));
            this.setTicksAnimated(this.ticksAnimated + 1);
        } else {
            this.setTicksAnimated(0);
        }
    }

    @Override
    public void sync() {
        if (this.player.field_70170_p.field_72995_K) {
            throw new IllegalStateException("Don't sync client -> server");
        }
        this.handsAreGlowingClient = this.state.isGraceful() && this.stateManager.handGlowTimer.getTransition() == RegenState.Transition.HAND_GLOW_TRIGGER;
        NBTTagCompound nbt = this.serializeNBT();
        nbt.func_82580_o("stateManager");
        NetworkHandler.sendPacketToAll(new MessageSynchroniseRegeneration(this.player.func_110124_au(), nbt));
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("state", this.state.toString());
        nbt.func_74768_a("regenerationsLeft", this.regenerationsLeft);
        nbt.func_74782_a("style", (INBTBase)this.getStyle());
        nbt.func_74782_a("type", (INBTBase)this.type.serializeNBT());
        nbt.func_74778_a("encoded_skin", this.ENCODED_SKIN);
        nbt.func_74778_a("skinType", this.skinType.name());
        nbt.func_74778_a("preferredModel", this.preferredModel.name());
        nbt.func_74757_a("handsAreGlowing", this.handsAreGlowingClient);
        nbt.func_74757_a("traitActive", this.traitActive);
        nbt.func_74778_a("v_type", this.vanillaSkin.name());
        nbt.func_74776_a("PrimaryRed", this.primaryRed);
        nbt.func_74776_a("PrimaryGreen", this.primaryGreen);
        nbt.func_74776_a("PrimaryBlue", this.primaryBlue);
        nbt.func_74776_a("SecondaryRed", this.secondaryRed);
        nbt.func_74776_a("SecondaryGreen", this.secondaryGreen);
        nbt.func_74776_a("SecondaryBlue", this.secondaryBlue);
        nbt.func_74776_a("ticksAnimated", (float)this.ticksAnimated);
        if (!this.player.field_70170_p.field_72995_K) {
            nbt.func_74782_a("stateManager", (INBTBase)this.stateManager.serializeNBT());
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.regenerationsLeft = Math.min((Integer)RegenConfig.COMMON.regenCapacity.get(), nbt.func_74762_e(nbt.func_74764_b("livesLeft") ? "livesLeft" : "regenerationsLeft"));
        if (nbt.func_74764_b("skinType")) {
            this.setSkinType(nbt.func_74779_i("skinType"));
        } else {
            this.setSkinType("ALEX");
        }
        if (nbt.func_74764_b("preferredModel")) {
            this.setPreferredModel(nbt.func_74779_i("preferredModel"));
        } else {
            this.setPreferredModel("ALEX");
        }
        if (nbt.func_74764_b("v_type")) {
            this.vanillaSkin = SkinInfo.SkinType.valueOf(nbt.func_74779_i("v_type"));
        }
        if (nbt.func_74764_b("regenerationsLeft")) {
            this.regenerationsLeft = nbt.func_74762_e("regenerationsLeft");
        }
        if (nbt.func_74764_b("traitActive")) {
            this.setDnaActive(nbt.func_74767_n("traitAlive"));
        } else {
            this.setDnaActive(true);
        }
        if (nbt.func_74764_b("handsAreGlowing")) {
            this.handsAreGlowingClient = nbt.func_74767_n("handsAreGlowing");
        }
        this.type = nbt.func_74764_b("type") ? IRegenType.getType(this.type, (NBTTagCompound)nbt.func_74781_a("type")) : new TypeFiery();
        this.state = nbt.func_74764_b("state") ? RegenState.valueOf(nbt.func_74779_i("state")) : RegenState.ALIVE;
        this.setEncodedSkin(nbt.func_74779_i("encoded_skin"));
        this.primaryRed = nbt.func_74760_g("PrimaryRed");
        this.primaryGreen = nbt.func_74760_g("PrimaryGreen");
        this.primaryBlue = nbt.func_74760_g("PrimaryBlue");
        this.secondaryRed = nbt.func_74760_g("SecondaryRed");
        this.secondaryGreen = nbt.func_74760_g("SecondaryGreen");
        this.secondaryBlue = nbt.func_74760_g("SecondaryBlue");
        this.ticksAnimated = nbt.func_74762_e("ticksAnimated");
        if (nbt.func_74764_b("stateManager") && this.stateManager != null) {
            this.stateManager.deserializeNBT((NBTTagCompound)nbt.func_74781_a("stateManager"));
        }
    }

    @Override
    public int getRegenerationsLeft() {
        return this.regenerationsLeft;
    }

    @Override
    @Deprecated
    public void setRegenerationsLeft(int amount) {
        this.regenerationsLeft = amount;
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public IRegenType<?> getType() {
        return this.type;
    }

    @Override
    public String getEncodedSkin() {
        return this.ENCODED_SKIN;
    }

    @Override
    public void setEncodedSkin(String string) {
        this.ENCODED_SKIN = string;
    }

    @Override
    public NBTTagCompound getStyle() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("PrimaryRed", this.primaryRed);
        nbt.func_74776_a("PrimaryGreen", this.primaryGreen);
        nbt.func_74776_a("PrimaryBlue", this.primaryBlue);
        nbt.func_74776_a("SecondaryRed", this.secondaryRed);
        nbt.func_74776_a("SecondaryGreen", this.secondaryGreen);
        nbt.func_74776_a("SecondaryBlue", this.secondaryBlue);
        return nbt;
    }

    @Override
    public void setStyle(NBTTagCompound nbt) {
        this.primaryRed = nbt.func_74760_g("PrimaryRed");
        this.primaryGreen = nbt.func_74760_g("PrimaryGreen");
        this.primaryBlue = nbt.func_74760_g("PrimaryBlue");
        this.secondaryRed = nbt.func_74760_g("SecondaryRed");
        this.secondaryGreen = nbt.func_74760_g("SecondaryGreen");
        this.secondaryBlue = nbt.func_74760_g("SecondaryBlue");
    }

    @Override
    public Vec3d getPrimaryColor() {
        return new Vec3d((double)this.primaryRed, (double)this.primaryGreen, (double)this.primaryBlue);
    }

    @Override
    public Vec3d getSecondaryColor() {
        return new Vec3d((double)this.secondaryRed, (double)this.secondaryGreen, (double)this.secondaryBlue);
    }

    @Override
    public void receiveRegenerations(int amount) {
        this.regenerationsLeft = ((Boolean)RegenConfig.COMMON.infiniteRegeneration.get()).booleanValue() ? (Integer)RegenConfig.COMMON.regenCapacity.get() : (this.regenerationsLeft += amount);
        this.sync();
    }

    @Override
    public void extractRegeneration(int amount) {
        this.regenerationsLeft = ((Boolean)RegenConfig.COMMON.infiniteRegeneration.get()).booleanValue() ? (Integer)RegenConfig.COMMON.regenCapacity.get() : (this.regenerationsLeft -= amount);
        this.sync();
    }

    @Override
    public SkinInfo.SkinType getSkinType() {
        return this.skinType;
    }

    @Override
    public void setSkinType(String skinType) {
        this.skinType = SkinInfo.SkinType.valueOf(skinType);
    }

    @Override
    public SkinChangingHandler.EnumChoices getPreferredModel() {
        return this.preferredModel;
    }

    @Override
    public void setPreferredModel(String skinType) {
        this.preferredModel = SkinChangingHandler.EnumChoices.valueOf(skinType);
    }

    @Override
    public boolean areHandsGlowing() {
        return this.handsAreGlowingClient;
    }

    @Override
    public String getDeathSource() {
        return this.deathSource;
    }

    @Override
    public void setDeathSource(String source) {
        this.deathSource = source;
    }

    @Override
    public int getTicksAnimated() {
        return this.ticksAnimated;
    }

    @Override
    public void setTicksAnimated(int ticks) {
        this.ticksAnimated = ticks;
    }

    @Override
    public ResourceLocation getDnaType() {
        return this.traitLocation;
    }

    @Override
    public void setDnaType(ResourceLocation resgitryName) {
        this.traitLocation = resgitryName;
    }

    @Override
    public boolean isDnaActive() {
        return this.traitActive;
    }

    @Override
    public void setDnaActive(boolean alive) {
        this.traitActive = alive;
    }

    @Override
    public SkinInfo.SkinType getVanillaType() {
        return this.vanillaSkin;
    }

    @Override
    public void setVanillaType(SkinInfo.SkinType type) {
        this.vanillaSkin = type;
    }

    @Override
    public IRegenerationStateManager getStateManager() {
        return this.stateManager;
    }

    @Override
    public RegenState getState() {
        return this.state;
    }

    @Override
    public void triggerRegeneration() {
        if (this.player.field_70170_p.field_72995_K) {
            throw new IllegalStateException("Triggering regeneration via capability instance on the client side");
        }
        this.stateManager.triggerRegeneration();
    }

    public class RegenerationStateManager
    implements IRegenerationStateManager {
        private final Map<RegenState.Transition, Runnable> transitionCallbacks = new HashMap<RegenState.Transition, Runnable>();
        private DebuggableScheduledAction nextTransition;
        private DebuggableScheduledAction handGlowTimer;

        private RegenerationStateManager() {
            this.transitionCallbacks.put(RegenState.Transition.ENTER_CRITICAL, this::enterCriticalPhase);
            this.transitionCallbacks.put(RegenState.Transition.CRITICAL_DEATH, this::midSequenceKill);
            this.transitionCallbacks.put(RegenState.Transition.FINISH_REGENERATION, this::finishRegeneration);
            this.transitionCallbacks.put(RegenState.Transition.END_POST, this::endPost);
            Runnable err = () -> {
                throw new IllegalStateException("Can't use HAND_GLOW_* transitions as state transitions");
            };
            this.transitionCallbacks.put(RegenState.Transition.HAND_GLOW_START, err);
            this.transitionCallbacks.put(RegenState.Transition.HAND_GLOW_TRIGGER, err);
        }

        private void scheduleTransitionInTicks(RegenState.Transition transition, long inTicks) {
            if (this.nextTransition != null && this.nextTransition.getTicksLeft() > 0L) {
                throw new IllegalStateException("Overwriting non-completed/cancelled transition: \n Attempted Transition: " + transition.name() + "\n Current: " + this.nextTransition.transition.name() + "\n Affected Player: " + CapabilityRegeneration.this.player.func_200200_C_());
            }
            if (transition == RegenState.Transition.HAND_GLOW_START || transition == RegenState.Transition.HAND_GLOW_TRIGGER) {
                throw new IllegalStateException("Can't use HAND_GLOW_* transitions as state transitions");
            }
            this.nextTransition = new DebuggableScheduledAction(transition, CapabilityRegeneration.this.player, this.transitionCallbacks.get((Object)transition), inTicks);
        }

        private void scheduleTransitionInSeconds(RegenState.Transition transition, long inSeconds) {
            this.scheduleTransitionInTicks(transition, inSeconds * 20L);
        }

        private void scheduleNextHandGlow() {
            if (CapabilityRegeneration.this.state.isGraceful() && this.handGlowTimer.getTicksLeft() > 0L) {
                throw new IllegalStateException("Overwriting running hand-glow timer with new next hand glow");
            }
            this.handGlowTimer = new DebuggableScheduledAction(RegenState.Transition.HAND_GLOW_START, CapabilityRegeneration.this.player, this::scheduleHandGlowTrigger, (Integer)RegenConfig.COMMON.handGlowInterval.get() * 20);
            CapabilityRegeneration.this.sync();
        }

        private void scheduleHandGlowTrigger() {
            if (CapabilityRegeneration.this.state.isGraceful() && this.handGlowTimer.getTicksLeft() > 0L) {
                throw new IllegalStateException("Overwriting running hand-glow timer with trigger timer prematurely");
            }
            this.handGlowTimer = new DebuggableScheduledAction(RegenState.Transition.HAND_GLOW_TRIGGER, CapabilityRegeneration.this.player, this::triggerRegeneration, (Integer)RegenConfig.COMMON.handGlowTriggerDelay.get() * 20);
            ActingForwarder.onHandsStartGlowing(CapabilityRegeneration.getForPlayer(CapabilityRegeneration.this.player));
            CapabilityRegeneration.this.sync();
        }

        @Override
        public boolean onKilled(DamageSource source) {
            if (source == DamageSource.field_76368_d || source == DamageSource.field_191291_g) {
                return false;
            }
            if (CapabilityRegeneration.this.state == RegenState.ALIVE) {
                if (!CapabilityRegeneration.this.canRegenerate()) {
                    return false;
                }
                this.scheduleTransitionInSeconds(RegenState.Transition.ENTER_CRITICAL, ((Integer)RegenConfig.COMMON.gracePhaseLength.get()).intValue());
                this.scheduleHandGlowTrigger();
                CapabilityRegeneration.this.state = RegenState.GRACE;
                CapabilityRegeneration.this.sync();
                ActingForwarder.onEnterGrace(CapabilityRegeneration.getForPlayer(CapabilityRegeneration.this.player));
                return true;
            }
            if (CapabilityRegeneration.this.state.isGraceful()) {
                this.triggerRegeneration();
                return true;
            }
            if (CapabilityRegeneration.this.state == RegenState.REGENERATING) {
                this.nextTransition.cancel();
                this.midSequenceKill();
                return false;
            }
            if (CapabilityRegeneration.this.state == RegenState.POST) {
                CapabilityRegeneration.this.state = RegenState.ALIVE;
                this.nextTransition.cancel();
                this.midSequenceKill();
                return false;
            }
            throw new IllegalStateException("Unknown state: " + (Object)((Object)CapabilityRegeneration.this.state));
        }

        @Override
        public void onPunchEntity(LivingHurtEvent event) {
            EntityLivingBase entity = event.getEntityLiving();
            if (CapabilityRegeneration.this.state.isGraceful() && entity.func_110143_aJ() < entity.func_110138_aP() && CapabilityRegeneration.this.areHandsGlowing() && CapabilityRegeneration.this.player.func_70093_af()) {
                float healthNeeded = entity.func_110138_aP() - entity.func_110143_aJ();
                entity.func_70691_i(healthNeeded);
                PlayerUtil.sendMessage(CapabilityRegeneration.this.player, new TextComponentTranslation("message.regeneration.healed", new Object[]{entity.func_200200_C_()}), true);
                event.setAmount(0.0f);
                CapabilityRegeneration.this.player.func_70097_a(RegenObjects.REGEN_DMG_HEALING, healthNeeded);
            }
        }

        @Override
        public void onPunchBlock(PlayerInteractEvent.LeftClickBlock e) {
            if (CapabilityRegeneration.this.getState().isGraceful() && CapabilityRegeneration.this.areHandsGlowing()) {
                IBlockState block = e.getWorld().func_180495_p(e.getPos());
                if (block.func_177230_c() == Blocks.field_150433_aE || block.func_177230_c() == Blocks.field_196604_cC) {
                    e.getWorld().func_184133_a(null, e.getPos(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                this.handGlowTimer.cancel();
                this.scheduleNextHandGlow();
                if (!((CapabilityRegeneration)CapabilityRegeneration.this).player.field_70170_p.field_72995_K) {
                    PlayerUtil.sendMessage(CapabilityRegeneration.this.player, new TextComponentTranslation("regeneration.messages.regen_delayed", new Object[0]), true);
                }
                e.setCanceled(true);
            }
        }

        private void tick() {
            if (((CapabilityRegeneration)CapabilityRegeneration.this).player.field_70170_p.field_72995_K) {
                throw new IllegalStateException("Ticking state manager on the client");
            }
            if (CapabilityRegeneration.this.state == RegenState.ALIVE) {
                throw new IllegalStateException("Ticking dormant state manager (state == ALIVE)");
            }
            if (CapabilityRegeneration.this.state.isGraceful()) {
                this.handGlowTimer.tick();
            }
            ActingForwarder.onRegenTick(CapabilityRegeneration.getForPlayer(CapabilityRegeneration.this.player));
            this.nextTransition.tick();
        }

        private void triggerRegeneration() {
            CapabilityRegeneration.this.state = RegenState.REGENERATING;
            if (((Boolean)RegenConfig.COMMON.sendRegenDeathMessages.get()).booleanValue()) {
                TextComponentTranslation text = new TextComponentTranslation("regeneration.messages.regen_chat_message", new Object[]{CapabilityRegeneration.this.player.func_200200_C_()});
                text.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(CapabilityRegeneration.this.getDeathSource())));
                PlayerUtil.sendMessageToAll(text);
            }
            this.nextTransition.cancel();
            if (CapabilityRegeneration.this.state.isGraceful()) {
                this.handGlowTimer.cancel();
            }
            this.scheduleTransitionInTicks(RegenState.Transition.FINISH_REGENERATION, CapabilityRegeneration.this.type.getAnimationLength());
            ActingForwarder.onRegenTrigger(CapabilityRegeneration.getForPlayer(CapabilityRegeneration.this.player));
            CapabilityRegeneration.this.type.onStartRegeneration(CapabilityRegeneration.this.player, CapabilityRegeneration.getForPlayer(CapabilityRegeneration.this.player));
            CapabilityRegeneration.this.sync();
        }

        private void enterCriticalPhase() {
            CapabilityRegeneration.this.state = RegenState.GRACE_CRIT;
            this.scheduleTransitionInSeconds(RegenState.Transition.CRITICAL_DEATH, ((Integer)RegenConfig.COMMON.criticalPhaseLength.get()).intValue());
            ActingForwarder.onGoCritical(CapabilityRegeneration.getForPlayer(CapabilityRegeneration.this.player));
            CapabilityRegeneration.this.sync();
        }

        private void midSequenceKill() {
            CapabilityRegeneration.this.state = RegenState.ALIVE;
            this.nextTransition = null;
            this.handGlowTimer = null;
            CapabilityRegeneration.this.type.onFinishRegeneration(CapabilityRegeneration.this.player, CapabilityRegeneration.getForPlayer(CapabilityRegeneration.this.player));
            CapabilityRegeneration.this.player.func_70606_j(-1.0f);
            if (((Boolean)RegenConfig.COMMON.loseRegensOnDeath.get()).booleanValue()) {
                CapabilityRegeneration.this.extractRegeneration(CapabilityRegeneration.this.getRegenerationsLeft());
            }
            CapabilityRegeneration.this.sync();
        }

        private void endPost() {
            CapabilityRegeneration.this.state = RegenState.ALIVE;
            CapabilityRegeneration.this.sync();
            this.nextTransition = null;
            PlayerUtil.sendMessage(CapabilityRegeneration.this.player, new TextComponentTranslation("regeneration.messages.post_ended", new Object[0]), true);
            if (((CapabilityRegeneration)CapabilityRegeneration.this).player.field_70170_p.field_73012_v.nextBoolean()) {
                EntityLindos lindos = new EntityLindos(((CapabilityRegeneration)CapabilityRegeneration.this).player.field_70170_p);
                lindos.func_70012_b(((CapabilityRegeneration)CapabilityRegeneration.this).player.field_70165_t, ((CapabilityRegeneration)CapabilityRegeneration.this).player.field_70163_u + (double)CapabilityRegeneration.this.player.func_70047_e(), ((CapabilityRegeneration)CapabilityRegeneration.this).player.field_70161_v, 0.0f, 0.0f);
                ((CapabilityRegeneration)CapabilityRegeneration.this).player.field_70170_p.func_72838_d((Entity)lindos);
                ((CapabilityRegeneration)CapabilityRegeneration.this).player.field_70170_p.func_184133_a(null, CapabilityRegeneration.this.player.func_180425_c(), RegenObjects.Sounds.REGEN_BREATH, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }

        private void finishRegeneration() {
            CapabilityRegeneration.this.setTicksAnimated(0);
            CapabilityRegeneration.this.state = RegenState.POST;
            this.scheduleTransitionInSeconds(RegenState.Transition.END_POST, ((CapabilityRegeneration)CapabilityRegeneration.this).player.field_70170_p.field_73012_v.nextInt(300));
            this.handGlowTimer = null;
            CapabilityRegeneration.this.type.onFinishRegeneration(CapabilityRegeneration.this.player, CapabilityRegeneration.getForPlayer(CapabilityRegeneration.this.player));
            ActingForwarder.onRegenFinish(CapabilityRegeneration.getForPlayer(CapabilityRegeneration.this.player));
            CapabilityRegeneration.this.sync();
        }

        @Override
        @Deprecated
        public Pair<RegenState.Transition, Long> getScheduledEvent() {
            return this.nextTransition == null ? null : Pair.of((Object)((Object)this.nextTransition.transition), (Object)this.nextTransition.getTicksLeft());
        }

        @Override
        @Deprecated
        public void fastForward() {
            while (!this.nextTransition.tick()) {
            }
        }

        @Override
        @Deprecated
        public void fastForwardHandGlow() {
            while (!this.handGlowTimer.tick()) {
            }
        }

        @Override
        public double getStateProgress() {
            return this.nextTransition.getProgress();
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.nextTransition != null && this.nextTransition.getTicksLeft() >= 0L) {
                nbt.func_74778_a("transitionId", this.nextTransition.transition.toString());
                nbt.func_74772_a("transitionInTicks", this.nextTransition.getTicksLeft());
            }
            if (this.handGlowTimer != null && this.handGlowTimer.getTicksLeft() >= 0L) {
                nbt.func_74778_a("handGlowState", this.handGlowTimer.transition.toString());
                nbt.func_74772_a("handGlowScheduledTicks", this.handGlowTimer.getTicksLeft());
            }
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            if (nbt.func_74764_b("transitionId")) {
                this.scheduleTransitionInTicks(RegenState.Transition.valueOf(nbt.func_74779_i("transitionId")), nbt.func_74763_f("transitionInTicks"));
            }
            if (nbt.func_74764_b("handGlowState")) {
                Runnable callback;
                RegenState.Transition transition = RegenState.Transition.valueOf(nbt.func_74779_i("handGlowState"));
                if (transition == RegenState.Transition.HAND_GLOW_START) {
                    callback = this::scheduleHandGlowTrigger;
                } else if (transition == RegenState.Transition.HAND_GLOW_TRIGGER) {
                    callback = this::triggerRegeneration;
                } else {
                    throw new IllegalStateException("Illegal hand glow timer transition");
                }
                this.handGlowTimer = new DebuggableScheduledAction(transition, CapabilityRegeneration.this.player, callback, nbt.func_74763_f("handGlowScheduledTicks"));
            }
        }
    }
}

