/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.common.capability;

import me.suff.regeneration.RegenConfig;
import me.suff.regeneration.client.skinhandling.SkinChangingHandler;
import me.suff.regeneration.client.skinhandling.SkinInfo;
import me.suff.regeneration.common.capability.IRegenerationStateManager;
import me.suff.regeneration.common.capability.PlayerCanRegenEvent;
import me.suff.regeneration.common.types.IRegenType;
import me.suff.regeneration.util.RegenState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.eventbus.api.Event;

public interface IRegeneration
extends INBTSerializable<NBTTagCompound> {
    public EntityPlayer getPlayer();

    public int getRegenerationsLeft();

    @Deprecated
    public void setRegenerationsLeft(int var1);

    public void triggerRegeneration();

    public void tick();

    public void sync();

    public NBTTagCompound getStyle();

    public void setStyle(NBTTagCompound var1);

    public Vec3d getPrimaryColor();

    public Vec3d getSecondaryColor();

    default public boolean canRegenerate() {
        return ((Boolean)RegenConfig.COMMON.infiniteRegeneration.get() != false || this.getRegenerationsLeft() > 0) && this.getPlayer().field_70163_u > 0.0 && !MinecraftForge.EVENT_BUS.post((Event)new PlayerCanRegenEvent(this.getPlayer()));
    }

    public void receiveRegenerations(int var1);

    public void extractRegeneration(int var1);

    public RegenState getState();

    public IRegenType<?> getType();

    public IRegenerationStateManager getStateManager();

    public String getEncodedSkin();

    public void setEncodedSkin(String var1);

    public SkinInfo.SkinType getSkinType();

    public void setSkinType(String var1);

    public SkinChangingHandler.EnumChoices getPreferredModel();

    public void setPreferredModel(String var1);

    public boolean areHandsGlowing();

    public String getDeathSource();

    public void setDeathSource(String var1);

    public int getTicksAnimated();

    public void setTicksAnimated(int var1);

    public ResourceLocation getDnaType();

    public void setDnaType(ResourceLocation var1);

    public boolean isDnaActive();

    public void setDnaActive(boolean var1);

    public SkinInfo.SkinType getVanillaType();

    public void setVanillaType(SkinInfo.SkinType var1);
}

