/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.suff.regeneration.RegenerationMod;
import me.suff.regeneration.common.capability.CapabilityRegeneration;
import me.suff.regeneration.util.RegenState;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class CommandRegen {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"regen-debug").requires(s -> s.func_197034_c(ServerLifecycleHooks.getCurrentServer().func_110455_j()))).then(Commands.func_197057_a((String)"glow").executes(ctx -> CommandRegen.glow((CommandSource)ctx.getSource())))).then(Commands.func_197057_a((String)"fast-forward").executes(ctx -> CommandRegen.fastForward((CommandSource)ctx.getSource())))).then(Commands.func_197057_a((String)"open").executes(ctx -> CommandRegen.open((CommandSource)ctx.getSource())))).then(Commands.func_197057_a((String)"set-regens").then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CommandRegen.setRegens((CommandSource)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"))))));
    }

    private static int glow(CommandSource source) {
        try {
            CapabilityRegeneration.getForPlayer((EntityPlayer)source.func_197035_h()).ifPresent(cap -> cap.getStateManager().fastForwardHandGlow());
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return 1;
    }

    private static int fastForward(CommandSource source) {
        try {
            CapabilityRegeneration.getForPlayer((EntityPlayer)source.func_197035_h()).ifPresent(cap -> {
                if (cap.getState() == RegenState.ALIVE) {
                    throw new CommandException((ITextComponent)new TextComponentTranslation("regeneration.messages.fast_forward_cmd_fail", new Object[0]));
                }
                cap.getStateManager().fastForward();
            });
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return 1;
    }

    private static int open(CommandSource source) {
        RegenerationMod.DEBUGGER.open();
        return 1;
    }

    private static int setRegens(CommandSource source, int amount) {
        try {
            CapabilityRegeneration.getForPlayer((EntityPlayer)source.func_197035_h()).ifPresent(cap -> cap.setRegenerationsLeft(amount));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return 1;
    }
}

