/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.common.entity;

import me.suff.regeneration.handlers.RegenObjects;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EntityItemOverride
extends Entity {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(EntityItemOverride.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Float> HEIGHT = EntityDataManager.func_187226_a(EntityItemOverride.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> WIDTH = EntityDataManager.func_187226_a(EntityItemOverride.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityItemOverride(World worldIn, double x, double y, double z, ItemStack stack) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.setItem(stack);
        this.field_70177_z = (float)(Math.random() * 360.0);
    }

    public EntityItemOverride(World worldIn, double x, double y, double z, ItemStack stack, float height, float width) {
        this(worldIn);
        this.setEntitySize(height, width);
        this.func_70107_b(x, y, z);
        this.setItem(stack);
        this.field_70177_z = (float)(Math.random() * 360.0);
    }

    public EntityItemOverride(World worldIn) {
        super(RegenObjects.EntityEntries.ITEM_OVERRIDE_ENTITY_TYPE, worldIn);
        this.func_70105_a(this.getWidth(), this.getHeight());
        this.field_70178_ae = true;
    }

    public static void givePlayerItemStack(EntityPlayer player, ItemStack stack) {
        if (player.func_184614_ca().func_190926_b()) {
            player.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
        } else if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, true);
        }
    }

    public void setEntitySize(float height, float width) {
        this.setHeight(height);
        this.setWidth(width);
        this.func_70105_a(width, height);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
        this.func_184212_Q().func_187214_a(HEIGHT, (Object)Float.valueOf(0.25f));
        this.func_184212_Q().func_187214_a(WIDTH, (Object)Float.valueOf(0.25f));
    }

    public void func_70037_a(NBTTagCompound compound) {
        NBTTagCompound itemCompound = (NBTTagCompound)compound.func_74781_a("Item");
        this.setItem(ItemStack.func_199557_a((NBTTagCompound)itemCompound));
        if (this.getItem().func_190926_b()) {
            this.func_174812_G();
        }
        this.setHeight(compound.func_74760_g("Height"));
        this.setWidth(compound.func_74760_g("Width"));
    }

    public void func_70014_b(NBTTagCompound compound) {
        if (!this.getItem().func_190926_b()) {
            compound.func_74782_a("Item", (INBTBase)this.getItem().func_77955_b(new NBTTagCompound()));
        }
        compound.func_74776_a("Height", this.getHeight());
        compound.func_74776_a("Width", this.getWidth());
    }

    public ItemStack getItem() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
    }

    public void setItem(ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM, (Object)stack);
    }

    public float getHeight() {
        return ((Float)this.func_184212_Q().func_187225_a(HEIGHT)).floatValue();
    }

    public void setHeight(float height) {
        this.func_184212_Q().func_187227_b(HEIGHT, (Object)Float.valueOf(height));
    }

    public float getWidth() {
        return ((Float)this.func_184212_Q().func_187225_a(WIDTH)).floatValue();
    }

    public void setWidth(float width) {
        this.func_184212_Q().func_187227_b(WIDTH, (Object)Float.valueOf(width));
    }

    public boolean func_190530_aW() {
        return true;
    }

    protected void func_70081_e(int amount) {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        EntityItemOverride.givePlayerItemStack(player, this.getItem());
        this.func_70106_y();
        return EnumActionResult.SUCCESS;
    }

    public void func_70071_h_() {
        double d5;
        double d4;
        double d3;
        double d6;
        boolean flag;
        super.func_70071_h_();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        double d0 = this.field_70159_w;
        double d1 = this.field_70181_x;
        double d2 = this.field_70179_y;
        ItemStack itemStack = this.getItem();
        if (itemStack.func_77973_b() instanceof IEntityOverride) {
            IEntityOverride iEntityOverride = (IEntityOverride)itemStack.func_77973_b();
            if (iEntityOverride.shouldDie(itemStack)) {
                this.func_70106_y();
            }
            iEntityOverride.update(this);
        }
        this.func_70105_a(this.getWidth(), this.getHeight());
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        this.field_70145_X = this.field_70170_p.field_72995_K ? false : this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        boolean bl = flag = (int)this.field_70169_q != (int)this.field_70165_t || (int)this.field_70167_r != (int)this.field_70163_u || (int)this.field_70166_s != (int)this.field_70161_v;
        if ((flag || this.field_70173_aa % 25 == 0) && this.field_70170_p.func_180495_p(new BlockPos((Entity)this)).func_185904_a() == Material.field_151587_i) {
            this.field_70181_x = 0.2f;
            this.field_70159_w = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.field_70179_y = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
        }
        float f = 0.98f;
        if (this.field_70122_E) {
            BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
            IBlockState underState = this.field_70170_p.func_180495_p(underPos);
            f = underState.func_177230_c().getSlipperiness(underState, (IWorldReader)this.field_70170_p, underPos, (Entity)this) * 0.98f;
        }
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)f;
        if (this.field_70122_E) {
            this.field_70181_x *= -0.5;
        }
        this.func_70072_I();
        if (!this.field_70170_p.field_72995_K && (d6 = (d3 = this.field_70159_w - d0) * d3 + (d4 = this.field_70181_x - d1) * d4 + (d5 = this.field_70179_y - d2) * d5) > 0.01) {
            this.field_70160_al = true;
        }
    }

    public ITextComponent func_145748_c_() {
        return this.getItem().func_200301_q();
    }

    public static interface IEntityOverride {
        public void update(EntityItemOverride var1);

        public boolean shouldDie(ItemStack var1);
    }
}

