/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.common.item;

import java.util.List;
import javax.annotation.Nullable;
import me.suff.regeneration.common.capability.CapabilityRegeneration;
import me.suff.regeneration.common.capability.IRegeneration;
import me.suff.regeneration.common.entity.EntityItemOverride;
import me.suff.regeneration.common.item.ItemOverrideBase;
import me.suff.regeneration.handlers.RegenObjects;
import me.suff.regeneration.util.PlayerUtil;
import me.suff.regeneration.util.RegenState;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ItemLindos
extends ItemOverrideBase {
    public ItemLindos() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200917_a(1));
        this.func_185043_a(new ResourceLocation("amount"), (stack, world, entityLivingBase) -> {
            if (stack.func_77978_p() != null) {
                int amount = ItemLindos.getAmount(stack);
                if (!ItemLindos.hasWater(stack)) {
                    return 0.0f;
                }
                if (ItemLindos.hasWater(stack) && ItemLindos.getAmount(stack) <= 0) {
                    return 2.0f;
                }
                if (amount == 100) {
                    return 1.0f;
                }
                if (amount >= 90) {
                    return 0.2f;
                }
                if (amount >= 50) {
                    return 0.5f;
                }
                if (amount >= 10) {
                    return 0.1f;
                }
            }
            return 2.0f;
        });
    }

    public static NBTTagCompound getStackTag(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("amount", 0);
        }
        return stack.func_77978_p();
    }

    public static int getAmount(ItemStack stack) {
        return ItemLindos.getStackTag(stack).func_74762_e("amount");
    }

    public static void setAmount(ItemStack stack, int amount) {
        ItemLindos.getStackTag(stack).func_74768_a("amount", MathHelper.func_76125_a((int)amount, (int)0, (int)100));
    }

    public static boolean hasWater(ItemStack stack) {
        return ItemLindos.getStackTag(stack).func_74767_n("water");
    }

    public static void setWater(ItemStack stack, boolean water) {
        ItemLindos.getStackTag(stack).func_74757_a("water", water);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74757_a("live", true);
        } else {
            stack.func_77978_p().func_74757_a("live", true);
        }
        if (!worldIn.field_72995_K) {
            worldIn.func_72872_a(EntityPlayer.class, entityIn.func_174813_aQ().func_72321_a(10.0, 10.0, 10.0)).forEach(player -> CapabilityRegeneration.getForPlayer((EntityPlayer)entityIn).ifPresent(data -> {
                if (data.getState() == RegenState.REGENERATING && worldIn.field_73012_v.nextInt(100) > 50 && isSelected) {
                    ItemLindos.setAmount(stack, ItemLindos.getAmount(stack) + 1);
                }
            }));
            if (entityIn instanceof EntityPlayer) {
                EntityPlayer player2 = (EntityPlayer)entityIn;
                CapabilityRegeneration.getForPlayer(player2).ifPresent(data -> {
                    if (isSelected && data.areHandsGlowing() && player.field_70173_aa % 40 == 0) {
                        ItemLindos.setAmount(stack, ItemLindos.getAmount(stack) + 2);
                    }
                });
            }
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        IRegeneration cap = (IRegeneration)CapabilityRegeneration.getForPlayer(player).orElse(null);
        if (!worldIn.field_72995_K) {
            RayTraceResult raytraceresult = this.func_77621_a(player.field_70170_p, player, true);
            if (raytraceresult == null || raytraceresult.func_178782_a() == null) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)player.func_184586_b(handIn));
            }
            BlockPos blockPos = raytraceresult.func_178782_a();
            IBlockState iblockstate = player.field_70170_p.func_180495_p(blockPos);
            Material material = iblockstate.func_185904_a();
            if (material == Material.field_151586_h) {
                if (!ItemLindos.hasWater(stack)) {
                    player.field_70170_p.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 11);
                    player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                    ItemLindos.setWater(stack, true);
                    player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                    PlayerUtil.sendMessage(player, new TextComponentTranslation("nbt.item.water_filled", new Object[0]), true);
                } else {
                    PlayerUtil.sendMessage(player, new TextComponentTranslation("nbt.item.water_already_filled", new Object[0]), true);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)player.func_184586_b(handIn));
            }
            if (cap.getState() == RegenState.POST || cap.getState() == RegenState.REGENERATING || player.func_184812_l_()) {
                PlayerUtil.sendMessage(player, new TextComponentTranslation("regeneration.messages.cannot_use", new Object[0]), true);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)player.func_184586_b(handIn));
            }
            if (ItemLindos.hasWater(stack)) {
                if (ItemLindos.getAmount(stack) == 100) {
                    if (cap.getRegenerationsLeft() < 1) {
                        cap.receiveRegenerations(1);
                    }
                    player.func_70097_a(RegenObjects.REGEN_DMG_LINDOS, 2.1474836E9f);
                    ItemLindos.setAmount(stack, 0);
                    ItemLindos.setWater(stack, false);
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(handIn));
                }
                PlayerUtil.sendMessage(player, new TextComponentTranslation("regeneration.messages.empty_vial", new Object[0]), true);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)player.func_184586_b(handIn));
            }
            PlayerUtil.sendMessage(player, new TextComponentTranslation("regeneration.messages.no_water", new Object[0]), true);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)player.func_184586_b(handIn));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)player.func_184586_b(handIn));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag idk) {
        super.func_77624_a(stack, world, tooltip, idk);
        tooltip.add((ITextComponent)new TextComponentTranslation("nbt.item.lindos", new Object[]{ItemLindos.getAmount(stack)}));
        tooltip.add((ITextComponent)new TextComponentTranslation("nbt.item.water", new Object[]{ItemLindos.hasWater(stack)}));
    }

    @Override
    public void update(EntityItemOverride itemOverride) {
        if (itemOverride.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack itemStack = itemOverride.getItem();
        if (itemStack.func_77973_b() == this && itemOverride.func_70090_H() && itemStack.func_77978_p() != null) {
            ItemLindos.setWater(itemStack, true);
        }
    }
}

