/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.common.types;

import me.suff.regeneration.client.rendering.ATypeRenderer;
import me.suff.regeneration.common.capability.IRegeneration;
import me.suff.regeneration.common.types.TypeFiery;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public interface IRegenType<R extends ATypeRenderer<?>>
extends INBTSerializable<NBTTagCompound> {
    public static IRegenType<?> getType(IRegenType<?> currentType, NBTTagCompound nbt) {
        try {
            Class<?> nbtClass = Class.forName(nbt.func_74779_i("name"));
            if (currentType == null || currentType.getClass() != nbtClass) {
                return (IRegenType)nbtClass.newInstance();
            }
            currentType.deserializeNBT(nbt);
            return currentType;
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            System.err.println("WARNING: Malformed type NBT, reverting to default");
            e.printStackTrace();
            return new TypeFiery();
        }
    }

    public int getAnimationLength();

    public R getRenderer();

    default public void onStartRegeneration(EntityPlayer player, LazyOptional<IRegeneration> capability) {
    }

    default public void onUpdateMidRegen(EntityPlayer player, LazyOptional<IRegeneration> capability) {
    }

    default public void onFinishRegeneration(EntityPlayer player, LazyOptional<IRegeneration> capability) {
    }

    public double getAnimationProgress();

    default public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("name", this.getClass().getName());
        return nbt;
    }

    default public void deserializeNBT(NBTTagCompound nbt) {
        if (!nbt.func_74779_i("name").equals(this.getClass().getName())) {
            throw new IllegalStateException("Deserialising wrong type instance (nbt: " + nbt.func_74779_i("name") + ", instance: " + this.getClass().getName());
        }
    }
}

