/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.common.types;

import me.suff.regeneration.RegenConfig;
import me.suff.regeneration.client.rendering.TypeFieryRenderer;
import me.suff.regeneration.common.capability.IRegeneration;
import me.suff.regeneration.common.types.IRegenType;
import me.suff.regeneration.util.PlayerUtil;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;

public class TypeFiery
implements IRegenType<TypeFieryRenderer> {
    private long animationTicks;

    @Override
    public void onUpdateMidRegen(EntityPlayer player, LazyOptional<IRegeneration> capability) {
        ++this.animationTicks;
        player.func_70066_B();
        if (!player.field_70170_p.field_72995_K) {
            PlayerUtil.setPerspective((EntityPlayerMP)player, true);
        }
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.field_70170_p.func_180495_p(player.func_180425_c()).func_177230_c() instanceof BlockFire) {
            player.field_70170_p.func_175698_g(player.func_180425_c());
        }
        double x = player.field_70165_t + player.func_70681_au().nextGaussian() * 2.0;
        double y = player.field_70163_u + 0.5 + player.func_70681_au().nextGaussian() * 2.0;
        double z = player.field_70161_v + player.func_70681_au().nextGaussian() * 2.0;
        player.field_70170_p.func_72885_a((Entity)player, x, y, z, 0.1f, ((Boolean)RegenConfig.COMMON.fieryRegen.get()).booleanValue(), false);
        for (BlockPos bs : BlockPos.func_177980_a((BlockPos)player.func_180425_c().func_177978_c().func_177976_e(), (BlockPos)player.func_180425_c().func_177968_d().func_177974_f())) {
            if (!(player.field_70170_p.func_180495_p(bs).func_177230_c() instanceof BlockFire)) continue;
            player.field_70170_p.func_175698_g(bs);
        }
    }

    @Override
    public void onFinishRegeneration(EntityPlayer player, LazyOptional<IRegeneration> capability) {
        PlayerUtil.setPerspective((EntityPlayerMP)player, false);
        this.animationTicks = 0L;
    }

    @Override
    public int getAnimationLength() {
        return 280;
    }

    @Override
    public double getAnimationProgress() {
        return Math.min(1.0, (double)this.animationTicks / (double)this.getAnimationLength());
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = IRegenType.super.serializeNBT();
        nbt.func_74772_a("animationTicks", this.animationTicks);
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        IRegenType.super.deserializeNBT(nbt);
        long nbtTicks = nbt.func_74763_f("animationTicks");
        if (nbtTicks > this.animationTicks) {
            this.animationTicks = nbtTicks;
        }
    }

    @Override
    public TypeFieryRenderer getRenderer() {
        return TypeFieryRenderer.INSTANCE;
    }
}

