/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.debugger;

import com.mojang.authlib.GameProfile;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import me.suff.regeneration.common.capability.IRegeneration;
import me.suff.regeneration.debugger.IDebugChannel;
import me.suff.regeneration.debugger.PanelHeader;
import me.suff.regeneration.debugger.PanelStatus;
import me.suff.regeneration.debugger.util.ConditionalDebugChannelProxy;
import me.suff.regeneration.debugger.util.EventQueueDebugChannelProxy;
import me.suff.regeneration.debugger.util.TextPaneLogger;
import me.suff.regeneration.util.RegenState;
import net.minecraftforge.common.util.LazyOptional;

class PanelPlayerTab
extends JPanel {
    private final PanelHeader pnlHeader;
    private final PanelStatus pnlStatus;
    private final TextPaneLogger console;

    public PanelPlayerTab(GameProfile gp) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 1.0};
        gridBagLayout.rowWeights = new double[]{0.0, 1.0};
        this.setLayout(gridBagLayout);
        this.pnlHeader = new PanelHeader(gp);
        GridBagConstraints gbc_pnlHeader = new GridBagConstraints();
        gbc_pnlHeader.insets = new Insets(10, 10, 10, 10);
        gbc_pnlHeader.fill = 1;
        gbc_pnlHeader.gridx = 0;
        gbc_pnlHeader.gridy = 0;
        this.add((Component)this.pnlHeader, gbc_pnlHeader);
        this.pnlStatus = new PanelStatus();
        GridBagConstraints gbc_pnlStatus = new GridBagConstraints();
        gbc_pnlStatus.insets = new Insets(0, 0, 0, 25);
        gbc_pnlStatus.fill = 2;
        gbc_pnlStatus.gridx = 1;
        gbc_pnlStatus.gridy = 0;
        this.add((Component)this.pnlStatus, gbc_pnlStatus);
        JTextPane consoleArea = new JTextPane();
        GridBagConstraints gbc_txtConsole = new GridBagConstraints();
        gbc_txtConsole.gridwidth = 2;
        gbc_txtConsole.insets = new Insets(0, 0, 0, 0);
        gbc_txtConsole.fill = 1;
        gbc_txtConsole.gridx = 0;
        gbc_txtConsole.gridy = 1;
        this.add((Component)new JScrollPane(consoleArea), gbc_txtConsole);
        consoleArea.setEditable(false);
        this.console = new TextPaneLogger(consoleArea);
    }

    public IDebugChannel createChannel() {
        class DebugChannelImpl
        implements IDebugChannel {
            DebugChannelImpl() {
            }

            @Override
            public void notifyLoaded() {
                PanelPlayerTab.this.console.println("Player was fully loaded", Color.WHITE, Color.BLACK);
            }

            @Override
            public void notifyExecution(RegenState.Transition action, long atTick) {
                PanelPlayerTab.this.console.println(this.getPrefix(action) + "EXECUTING " + (Object)((Object)action) + " (after " + atTick + ")", action.color, Color.ORANGE);
            }

            @Override
            public void notifySchedule(RegenState.Transition action, long inTicks) {
                PanelPlayerTab.this.console.println(this.getPrefix(action) + "SCHEDULED " + (Object)((Object)action) + " in " + inTicks + " (" + (float)inTicks / 20.0f + "s)", action.color, new Color(204, 255, 255));
            }

            @Override
            public void notifyCancel(RegenState.Transition action, long wasInTicks) {
                PanelPlayerTab.this.console.println(this.getPrefix(action) + "CANCELED " + (Object)((Object)action) + ", was in " + wasInTicks + " (" + (float)wasInTicks / 20.0f + "s)", action.color, Color.LIGHT_GRAY);
                if (wasInTicks == 0L) {
                    this.warn(action, "Cancelling action on tick it was scheduled for");
                } else if (wasInTicks < 0L) {
                    this.warn(action, "Canceled already canceled or completed action");
                }
            }

            @Override
            public void warn(RegenState.Transition action, String msg) {
                PanelPlayerTab.this.console.println(this.getPrefix(action) + "WARNING: " + msg, action.color, new Color(255, 255, 153));
            }

            @Override
            public void warn(String msg) {
                PanelPlayerTab.this.console.println("WARNING: " + msg, Color.BLACK, new Color(255, 255, 153));
            }

            @Override
            public void out(RegenState.Transition action, String msg) {
                PanelPlayerTab.this.console.println(this.getPrefix(action) + msg, action.color, new Color(255, 255, 153));
            }

            @Override
            public void out(String msg) {
                PanelPlayerTab.this.console.println("[OUT]    " + msg, Color.WHITE, Color.DARK_GRAY);
            }

            private String getPrefix(RegenState.Transition action) {
                return "[" + (Object)((Object)action) + "]    ";
            }
        }
        return new ConditionalDebugChannelProxy(new EventQueueDebugChannelProxy(new DebugChannelImpl()), () -> this.getParent().getParent().getParent().getParent().getParent().isVisible());
    }

    public void updateLabels(LazyOptional<IRegeneration> capability) {
        this.pnlStatus.updateLabels(capability);
    }
}

