/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.debugger;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import me.suff.regeneration.common.capability.IRegeneration;
import me.suff.regeneration.util.RegenState;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;

class PanelStatus
extends JPanel {
    private JLabel lblStateVal;
    private JLabel lblRegensLeftVal;
    private JLabel lblScheduledVal;

    public PanelStatus() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWeights = new double[]{1.0, 0.0, 1.0, 0.0, 1.0};
        gridBagLayout.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 1.0};
        this.setLayout(gridBagLayout);
        JLabel lblRegensLeft = new JLabel("Regenerations:");
        GridBagConstraints gbc_lblRegensLeft = new GridBagConstraints();
        gbc_lblRegensLeft.anchor = 17;
        gbc_lblRegensLeft.insets = new Insets(0, 0, 0, 5);
        gbc_lblRegensLeft.gridx = 1;
        gbc_lblRegensLeft.gridy = 1;
        this.add((Component)lblRegensLeft, gbc_lblRegensLeft);
        this.lblRegensLeftVal = new JLabel("?");
        GridBagConstraints gbc_lblRegensLeftVal = new GridBagConstraints();
        gbc_lblRegensLeftVal.anchor = 13;
        gbc_lblRegensLeftVal.insets = new Insets(0, 0, 0, 5);
        gbc_lblRegensLeftVal.gridx = 3;
        gbc_lblRegensLeftVal.gridy = 1;
        this.add((Component)this.lblRegensLeftVal, gbc_lblRegensLeftVal);
        JLabel lblState = new JLabel("State:");
        GridBagConstraints gbc_lblState = new GridBagConstraints();
        gbc_lblState.anchor = 17;
        gbc_lblState.insets = new Insets(0, 0, 0, 5);
        gbc_lblState.gridx = 1;
        gbc_lblState.gridy = 2;
        this.add((Component)lblState, gbc_lblState);
        this.lblStateVal = new JLabel("?");
        GridBagConstraints gbc_lblStateVal = new GridBagConstraints();
        gbc_lblStateVal.anchor = 13;
        gbc_lblStateVal.insets = new Insets(0, 0, 0, 5);
        gbc_lblStateVal.gridx = 3;
        gbc_lblStateVal.gridy = 2;
        this.add((Component)this.lblStateVal, gbc_lblStateVal);
        JLabel lblScheduled = new JLabel("Scheduled:");
        GridBagConstraints gbc_lblScheduled = new GridBagConstraints();
        gbc_lblScheduled.anchor = 17;
        gbc_lblScheduled.insets = new Insets(0, 0, 0, 5);
        gbc_lblScheduled.gridx = 1;
        gbc_lblScheduled.gridy = 3;
        this.add((Component)lblScheduled, gbc_lblScheduled);
        this.lblScheduledVal = new JLabel("nothing");
        GridBagConstraints gbc_lblScheduledVal = new GridBagConstraints();
        gbc_lblScheduledVal.anchor = 13;
        gbc_lblScheduledVal.insets = new Insets(0, 0, 0, 5);
        gbc_lblScheduledVal.gridx = 3;
        gbc_lblScheduledVal.gridy = 3;
        this.add((Component)this.lblScheduledVal, gbc_lblScheduledVal);
    }

    public void updateLabels(LazyOptional<IRegeneration> cap) {
        cap.ifPresent(data -> {
            this.lblStateVal.setText(data.getState().toString());
            this.lblRegensLeftVal.setText(data.getRegenerationsLeft() + "");
            Pair<RegenState.Transition, Long> scheduled = data.getStateManager().getScheduledEvent();
            this.lblScheduledVal.setForeground(scheduled == null ? Color.BLACK : ((RegenState.Transition)((Object)((Object)scheduled.getLeft()))).color);
            this.lblScheduledVal.setText(scheduled == null ? "nothing" : scheduled.getLeft() + " in " + scheduled.getRight() + " ticks (" + this.round((float)((Long)scheduled.getRight()).longValue() / 20.0f, 1) + "s)");
        });
    }

    private double round(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }
}

