/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.debugger.util;

import java.util.function.Supplier;
import me.suff.regeneration.debugger.IDebugChannel;
import me.suff.regeneration.util.RegenState;

public class ConditionalDebugChannelProxy
implements IDebugChannel {
    private final IDebugChannel target;
    private final Supplier<Boolean> condition;

    public ConditionalDebugChannelProxy(IDebugChannel target, Supplier<Boolean> condition) {
        this.target = target;
        this.condition = condition;
    }

    @Override
    public void notifyCancel(RegenState.Transition action, long wasInTicks) {
        if (this.condition.get().booleanValue()) {
            this.target.notifyCancel(action, wasInTicks);
        }
    }

    @Override
    public void notifyExecution(RegenState.Transition action, long atTick) {
        if (this.condition.get().booleanValue()) {
            this.target.notifyExecution(action, atTick);
        }
    }

    @Override
    public void notifySchedule(RegenState.Transition action, long inTicks) {
        if (this.condition.get().booleanValue()) {
            this.target.notifySchedule(action, inTicks);
        }
    }

    @Override
    public void warn(RegenState.Transition action, String msg) {
        if (this.condition.get().booleanValue()) {
            this.target.warn(action, msg);
        }
    }

    @Override
    public void warn(String msg) {
        if (this.condition.get().booleanValue()) {
            this.target.warn(msg);
        }
    }

    @Override
    public void out(RegenState.Transition action, String msg) {
        if (this.condition.get().booleanValue()) {
            this.target.out(action, msg);
        }
    }

    @Override
    public void out(String msg) {
        if (this.condition.get().booleanValue()) {
            this.target.out(msg);
        }
    }

    @Override
    public void notifyLoaded() {
        if (this.condition.get().booleanValue()) {
            this.target.notifyLoaded();
        }
    }
}

