/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.debugger.util;

import me.suff.regeneration.RegenerationMod;
import me.suff.regeneration.util.RegenState;
import me.suff.regeneration.util.ScheduledAction;
import net.minecraft.entity.player.EntityPlayer;

public class DebuggableScheduledAction
extends ScheduledAction {
    public final RegenState.Transition transition;
    private final EntityPlayer player;

    public DebuggableScheduledAction(RegenState.Transition transition, EntityPlayer player, Runnable callback, long inTicks) {
        super(callback, inTicks);
        this.transition = transition;
        this.player = player;
        RegenerationMod.DEBUGGER.getChannelFor(player).notifySchedule(transition, inTicks);
    }

    @Override
    public boolean tick() {
        boolean executed;
        boolean willExecute;
        if (this.scheduledTick == -1L) {
            RegenerationMod.DEBUGGER.getChannelFor(this.player).warn("Ticking finished/canceled ScheduledAction (" + (Object)((Object)this.transition) + ")");
        }
        boolean bl = willExecute = this.currentTick == this.scheduledTick;
        if (willExecute) {
            RegenerationMod.DEBUGGER.getChannelFor(this.player).notifyExecution(this.transition, this.currentTick);
        }
        if (willExecute != (executed = super.tick())) {
            throw new IllegalStateException("Execution prospect wasn't true (prospect: " + willExecute + ", result: " + executed + ", cTick: " + this.currentTick + ", scheduledTick: " + this.scheduledTick);
        }
        return executed;
    }

    @Override
    public void cancel() {
        RegenerationMod.DEBUGGER.getChannelFor(this.player).notifyCancel(this.transition, this.scheduledTick - this.currentTick);
        super.cancel();
    }

    @Override
    public double getProgress() {
        if (this.scheduledTick == -1L) {
            RegenerationMod.DEBUGGER.getChannelFor(this.player).warn("Querying progress of canceled/finished transition");
        }
        return super.getProgress();
    }

    public RegenState.Transition getTransition() {
        return this.transition;
    }
}

