/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.handlers;

import me.suff.regeneration.RegenConfig;
import me.suff.regeneration.client.skinhandling.SkinChangingHandler;
import me.suff.regeneration.common.capability.IRegeneration;
import me.suff.regeneration.handlers.IActingHandler;
import me.suff.regeneration.handlers.RegenObjects;
import me.suff.regeneration.util.ClientUtil;
import me.suff.regeneration.util.RegenState;
import me.suff.regeneration.util.RegenUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.util.LazyOptional;

class ActingClientHandler
implements IActingHandler {
    public static final IActingHandler INSTANCE = new ActingClientHandler();

    private ActingClientHandler() {
    }

    @Override
    public void onRegenTick(LazyOptional<IRegeneration> cap) {
    }

    @Override
    public void onEnterGrace(LazyOptional<IRegeneration> data) {
        data.ifPresent(cap -> {
            ClientUtil.playSound((Entity)cap.getPlayer(), RegenObjects.Sounds.HEART_BEAT.getRegistryName(), SoundCategory.PLAYERS, true, () -> !cap.getState().isGraceful(), 0.2f);
            ClientUtil.playSound((Entity)cap.getPlayer(), RegenObjects.Sounds.GRACE_HUM.getRegistryName(), SoundCategory.AMBIENT, true, () -> cap.getState() != RegenState.GRACE, 1.5f);
        });
    }

    @Override
    public void onHandsStartGlowing(LazyOptional<IRegeneration> data) {
        data.ifPresent(cap -> ClientUtil.playSound((Entity)cap.getPlayer(), RegenObjects.Sounds.HAND_GLOW.getRegistryName(), SoundCategory.PLAYERS, true, () -> !cap.areHandsGlowing(), 1.0f));
    }

    @Override
    public void onRegenFinish(LazyOptional<IRegeneration> data) {
        data.ifPresent(cap -> {
            ClientUtil.createToast(new TextComponentTranslation("regeneration.toast.regenerated", new Object[0]), new TextComponentTranslation("regeneration.toast.regenerations_left", new Object[]{cap.getRegenerationsLeft()}));
            if (((Boolean)RegenConfig.CLIENT.changeHand.get()).booleanValue() && cap.getPlayer().func_110124_au() == Minecraft.func_71410_x().field_71439_g.func_110124_au()) {
                Minecraft.func_71410_x().field_71474_y.field_186715_A = RegenUtil.randomEnum(EnumHandSide.class);
                Minecraft.func_71410_x().field_71474_y.func_82879_c();
                Minecraft.func_71410_x().field_71439_g.field_70125_A = 0.0f;
            }
        });
    }

    @Override
    public void onRegenTrigger(LazyOptional<IRegeneration> data) {
        data.ifPresent(cap -> {
            if (Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(cap.getPlayer().func_110124_au())) {
                SkinChangingHandler.sendSkinUpdate(cap.getPlayer().field_70170_p.field_73012_v, cap.getPlayer());
            }
        });
    }

    @Override
    public void onGoCritical(LazyOptional<IRegeneration> data) {
        data.ifPresent(cap -> {
            ClientUtil.createToast(new TextComponentTranslation("regeneration.toast.enter_critical", new Object[0]), new TextComponentTranslation("regeneration.toast.enter_critical.sub", new Object[]{(Integer)RegenConfig.COMMON.criticalPhaseLength.get() / 60}));
            ClientUtil.playSound((Entity)cap.getPlayer(), RegenObjects.Sounds.CRITICAL_STAGE.getRegistryName(), SoundCategory.PLAYERS, true, () -> cap.getState() != RegenState.GRACE_CRIT, 1.0f);
        });
    }
}

