/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.handlers;

import java.util.Random;
import java.util.UUID;
import me.suff.regeneration.RegenConfig;
import me.suff.regeneration.RegenerationMod;
import me.suff.regeneration.common.capability.IRegeneration;
import me.suff.regeneration.handlers.IActingHandler;
import me.suff.regeneration.handlers.RegenObjects;
import me.suff.regeneration.network.MessagePlayRegenerationSound;
import me.suff.regeneration.network.NetworkHandler;
import me.suff.regeneration.util.PlayerUtil;
import me.suff.regeneration.util.RegenUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.util.LazyOptional;

class ActingServerHandler
implements IActingHandler {
    public static final IActingHandler INSTANCE = new ActingServerHandler();
    private final UUID SLOWNESS_ID = UUID.fromString("f9aa2c36-f3f3-4d76-a148-86d6f2c87782");
    private final UUID MAX_HEALTH_ID = UUID.fromString("5d6f0ba2-1286-46fc-b896-461c5cfd99cc");
    private final double HEART_REDUCTION = 0.5;
    private final double SPEED_REDUCTION = 0.25;
    private final AttributeModifier slownessModifier = new AttributeModifier(this.SLOWNESS_ID, "slow", -0.25, 1);
    private final AttributeModifier heartModifier = new AttributeModifier(this.MAX_HEALTH_ID, "short-heart", -0.5, 1);

    public static SoundEvent getRandomSound(Random random) {
        SoundEvent[] SOUNDS = new SoundEvent[]{RegenObjects.Sounds.REGENERATION, RegenObjects.Sounds.REGENERATION_2, RegenObjects.Sounds.REGENERATION_3};
        return SOUNDS[random.nextInt(SOUNDS.length)];
    }

    @Override
    public void onRegenTick(LazyOptional<IRegeneration> data) {
        data.ifPresent(cap -> {
            EntityPlayer player = cap.getPlayer();
            float stateProgress = (float)cap.getStateManager().getStateProgress();
            switch (cap.getState()) {
                case POST: {
                    if (player.field_70173_aa % 210 != 0) break;
                    PlayerUtil.applyPotionIfAbsent(player, PlayerUtil.POTIONS.get(player.field_70170_p.field_73012_v.nextInt(PlayerUtil.POTIONS.size())), player.field_70170_p.field_73012_v.nextInt(400), 1, false, false);
                    break;
                }
                case REGENERATING: {
                    float dm = Math.max(1.0f, (float)(player.field_70170_p.func_175659_aa().func_151525_a() + 1) / 3.0f);
                    player.func_70691_i(stateProgress * 0.3f * dm);
                    player.func_85034_r(0);
                    RegenUtil.regenerationExplosion(player);
                    break;
                }
                case GRACE_CRIT: {
                    float nauseaPercentage = 0.5f;
                    if (stateProgress > nauseaPercentage && PlayerUtil.applyPotionIfAbsent(player, MobEffects.field_76431_k, (int)((float)((Integer)RegenConfig.COMMON.criticalPhaseLength.get() * 20) * (1.0f - nauseaPercentage) * 1.5f), 0, false, false)) {
                        RegenerationMod.DEBUGGER.getChannelFor(player).out("Applied nausea");
                    }
                    if (PlayerUtil.applyPotionIfAbsent(player, MobEffects.field_76437_t, (int)((float)((Integer)RegenConfig.COMMON.criticalPhaseLength.get() * 20) * (1.0f - stateProgress)), 0, false, false)) {
                        RegenerationMod.DEBUGGER.getChannelFor(player).out("Applied weakness");
                    }
                    if (!(player.field_70170_p.field_73012_v.nextDouble() < (double)((float)((Integer)RegenConfig.COMMON.criticalDamageChance.get()).intValue() / 100.0f))) break;
                    player.func_70097_a(RegenObjects.REGEN_DMG_CRITICAL, player.field_70170_p.field_73012_v.nextFloat() + 0.5f);
                    break;
                }
                case GRACE: {
                    float weaknessPercentage = 0.5f;
                    if (!(stateProgress > weaknessPercentage) || !PlayerUtil.applyPotionIfAbsent(player, MobEffects.field_76437_t, (int)((float)((Integer)RegenConfig.COMMON.gracePhaseLength.get() * 20) * (1.0f - weaknessPercentage) + (float)((Integer)RegenConfig.COMMON.criticalPhaseLength.get() * 20)), 0, false, false)) break;
                    RegenerationMod.DEBUGGER.getChannelFor(player).out("Applied weakness");
                    break;
                }
                case ALIVE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state " + (Object)((Object)cap.getState()));
                }
            }
        });
    }

    @Override
    public void onEnterGrace(LazyOptional<IRegeneration> data) {
        data.ifPresent(cap -> {
            EntityPlayer player = cap.getPlayer();
            RegenUtil.explodeKnockback((Entity)player, player.field_70170_p, player.func_180425_c(), (Double)RegenConfig.COMMON.regenerativeKnockback.get() / 2.0, (Integer)RegenConfig.COMMON.regenKnockbackRange.get());
            player.func_110149_m(player.func_110138_aP() * 0.5f);
            if (!player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_180374_a(this.heartModifier)) {
                player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(this.heartModifier);
            }
            cap.setDnaActive(false);
            RegenerationMod.DEBUGGER.getChannelFor(player).out("Applied health reduction");
            player.func_70606_j(player.func_110138_aP());
        });
    }

    @Override
    public void onHandsStartGlowing(LazyOptional<IRegeneration> data) {
        data.ifPresent(cap -> PlayerUtil.sendMessage(cap.getPlayer(), new TextComponentTranslation("regeneration.messages.regen_warning", new Object[0]), true));
    }

    @Override
    public void onGoCritical(LazyOptional<IRegeneration> data) {
        data.ifPresent(cap -> {
            if (!cap.getPlayer().func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(this.slownessModifier)) {
                cap.getPlayer().func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.slownessModifier);
            }
            RegenerationMod.DEBUGGER.getChannelFor(cap.getPlayer()).out("Applied speed reduction");
        });
    }

    @Override
    public void onRegenFinish(LazyOptional<IRegeneration> data) {
        data.ifPresent(cap -> {
            EntityPlayer player = cap.getPlayer();
            player.func_195064_c(new PotionEffect(MobEffects.field_76428_l, (Integer)RegenConfig.COMMON.postRegenerationDuration.get() * 2, (Integer)RegenConfig.COMMON.postRegenerationLevel.get() - 1, false, false));
            player.func_70606_j(player.func_110138_aP());
            player.func_110149_m((float)((Integer)RegenConfig.COMMON.absorbtionLevel.get() * 2));
        });
    }

    @Override
    public void onRegenTrigger(LazyOptional<IRegeneration> data) {
        data.ifPresent(cap -> {
            EntityPlayer player = cap.getPlayer();
            for (EntityPlayerMP netPlayer : player.field_70170_p.func_72872_a(EntityPlayerMP.class, player.func_174813_aQ().func_72321_a(45.0, 45.0, 45.0))) {
                NetworkHandler.sendTo(new MessagePlayRegenerationSound(ActingServerHandler.getRandomSound(player.field_70170_p.field_73012_v).getRegistryName(), player.func_110124_au()), netPlayer);
            }
            player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_188479_b(this.MAX_HEALTH_ID);
            RegenerationMod.DEBUGGER.getChannelFor(player).out("Removed health reduction");
            player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(this.SLOWNESS_ID);
            RegenerationMod.DEBUGGER.getChannelFor(player).out("Removed speed reduction");
            player.func_70606_j(Math.max(player.func_110143_aJ(), 8.0f));
            player.func_110149_m(0.0f);
            player.func_70066_B();
            player.func_184226_ay();
            player.func_184210_p();
            if (((Boolean)RegenConfig.COMMON.resetHunger.get()).booleanValue()) {
                player.func_71024_bL().func_75114_a(20);
            }
            if (((Boolean)RegenConfig.COMMON.resetOxygen.get()).booleanValue()) {
                player.func_70050_g(300);
            }
            cap.extractRegeneration(1);
        });
    }
}

