/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.handlers;

import com.mojang.brigadier.CommandDispatcher;
import java.awt.GraphicsEnvironment;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.suff.regeneration.RegenConfig;
import me.suff.regeneration.RegenerationMod;
import me.suff.regeneration.common.capability.CapabilityRegeneration;
import me.suff.regeneration.common.capability.IRegeneration;
import me.suff.regeneration.common.commands.CommandRegen;
import me.suff.regeneration.debugger.DummyRegenDebugger;
import me.suff.regeneration.debugger.GraphicalRegenDebugger;
import me.suff.regeneration.handlers.RegenObjects;
import me.suff.regeneration.util.PlayerUtil;
import me.suff.regeneration.util.RegenState;
import me.suff.regeneration.util.RegenUtil;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.forgespi.language.IModInfo;

public class RegenEventHandler {
    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (living instanceof EntityPlayer && living.func_70089_S()) {
            CapabilityRegeneration.getForPlayer((EntityPlayer)living).ifPresent(IRegeneration::tick);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Capability.IStorage storage = CapabilityRegeneration.CAPABILITY.getStorage();
        CapabilityRegeneration.getForPlayer(event.getOriginal()).ifPresent(old -> CapabilityRegeneration.getForPlayer(event.getEntityPlayer()).ifPresent(data -> {
            NBTTagCompound nbt = (NBTTagCompound)storage.writeNBT(CapabilityRegeneration.CAPABILITY, old, null);
            storage.readNBT(CapabilityRegeneration.CAPABILITY, data, null, (INBTBase)nbt);
        }));
    }

    @SubscribeEvent
    public void playerTracking(PlayerEvent.StartTracking event) {
        CapabilityRegeneration.getForPlayer(event.getEntityPlayer()).ifPresent(IRegeneration::sync);
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilityRegeneration.getForPlayer(event.getPlayer()).ifPresent(IRegeneration::sync);
    }

    @SubscribeEvent
    public void onDeathEvent(LivingDeathEvent e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            CapabilityRegeneration.getForPlayer((EntityPlayer)e.getEntityLiving()).ifPresent(IRegeneration::sync);
        }
    }

    @SubscribeEvent
    public void onPunchBlock(PlayerInteractEvent.LeftClickBlock e) {
        if (e.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        CapabilityRegeneration.getForPlayer(e.getEntityPlayer()).ifPresent(cap -> cap.getStateManager().onPunchBlock(e));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onHurt(LivingHurtEvent event) {
        Entity trueSource = event.getSource().func_76346_g();
        if (trueSource instanceof EntityPlayer && event.getEntityLiving() instanceof EntityLiving) {
            EntityPlayer player = (EntityPlayer)trueSource;
            CapabilityRegeneration.getForPlayer(player).ifPresent(cap -> cap.getStateManager().onPunchEntity(event));
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer) || event.getSource() == RegenObjects.REGEN_DMG_CRITICAL) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        CapabilityRegeneration.getForPlayer(player).ifPresent(cap -> {
            cap.setDeathSource(event.getSource().func_151519_b((EntityLivingBase)player).func_150261_e());
            if (cap.getState() == RegenState.POST && player.field_70163_u > 0.0) {
                if (event.getSource() == DamageSource.field_76379_h) {
                    PlayerUtil.applyPotionIfAbsent(player, MobEffects.field_76431_k, 200, 4, false, false);
                    if (event.getAmount() > 8.0f) {
                        if (player.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                            RegenUtil.genCrater(player.field_70170_p, player.func_180425_c(), 3);
                        }
                        event.setAmount(0.5f);
                        PlayerUtil.sendMessage(player, new TextComponentTranslation("regeneration.messages.fall_dmg", new Object[0]), true);
                        return;
                    }
                } else {
                    event.setAmount(0.5f);
                    PlayerUtil.sendMessage(player, new TextComponentTranslation("regeneration.messages.reduced_dmg", new Object[0]), true);
                }
                return;
            }
            if (cap.getState() == RegenState.REGENERATING && ((Boolean)RegenConfig.COMMON.regenFireImmune.get()).booleanValue() && event.getSource().func_76347_k()) {
                event.setCanceled(true);
            } else if (player.func_110143_aJ() + player.func_110139_bj() - event.getAmount() <= 0.0f) {
                boolean notDead = cap.getStateManager().onKilled(event.getSource());
                event.setCanceled(notDead);
            }
        });
    }

    @SubscribeEvent
    public void onKnockback(LivingKnockBackEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            CapabilityRegeneration.getForPlayer((EntityPlayer)event.getEntityLiving()).ifPresent(cap -> {
                if (cap.getState() == RegenState.REGENERATING) {
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public void registerLoot(LootTableLoadEvent event) {
        if (!event.getName().toString().toLowerCase().matches((String)RegenConfig.COMMON.lootRegex.get()) || ((Boolean)RegenConfig.COMMON.disableLoot.get()).booleanValue()) {
            return;
        }
        LootEntryTable entry = new LootEntryTable(RegenerationMod.LOOT_FILE, 1, 0, new LootCondition[0], "regeneration_inject_entry");
        LootPool pool = new LootPool(new LootEntry[]{entry}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(1.0f), "regeneration_inject_pool");
        event.getTable().addPool(pool);
    }

    @SubscribeEvent
    public void serverStart(FMLServerStartingEvent event) {
        CommandRegen.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        RegenerationMod.DEBUGGER = GraphicsEnvironment.isHeadless() ? new DummyRegenDebugger() : new GraphicalRegenDebugger();
        MinecraftForge.EVENT_BUS.register((Object)RegenerationMod.DEBUGGER);
    }

    @SubscribeEvent
    public void serverStop(FMLServerStoppingEvent event) {
        MinecraftForge.EVENT_BUS.unregister((Object)RegenerationMod.DEBUGGER);
        RegenerationMod.DEBUGGER.dispose();
        RegenerationMod.DEBUGGER = null;
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        EntityPlayer player = e.getPlayer();
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "NOTE: " + TextFormatting.BLUE + "Since Galaticraft have not yet updated their TAB Api system, I cannot add the Regeneration tab back to the inventory until they do. Until they do, I have added a keybind that will open up the GUI."));
            VersionChecker.CheckResult version = VersionChecker.getResult((IModInfo)((IModInfo)ModList.get().getModFileById("regeneration").getMods().get(0)));
            if (version.status.equals((Object)VersionChecker.Status.OUTDATED)) {
                TextComponentString url = new TextComponentString(TextFormatting.AQUA + TextFormatting.BOLD.toString() + "UPDATE");
                url.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft.curseforge.com/projects/regeneration"));
                url.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Open URL")));
                player.func_145747_a(new TextComponentString(TextFormatting.GOLD + "[Regeneration] : ").func_150257_a((ITextComponent)url));
                String changes = (String)version.changes.get(version.target);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Changes: " + TextFormatting.BLUE + changes));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity newEntity;
        ItemStack stack;
        Item item;
        Entity entity = event.getEntity();
        if (entity.getClass().equals(EntityItem.class) && (item = (stack = ((EntityItem)entity).func_92059_d()).func_77973_b()).hasCustomEntity(stack) && (newEntity = item.createEntity(event.getWorld(), entity, stack)) != null) {
            entity.func_70106_y();
            event.setCanceled(true);
            event.getWorld().func_72838_d(newEntity);
        }
    }

    public static class AddCapabilities {
        @SubscribeEvent
        public void attachCapabilities(final AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityPlayer) {
                event.addCapability(CapabilityRegeneration.CAP_REGEN_ID, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                    final CapabilityRegeneration regen;
                    final LazyOptional<IRegeneration> regenInstance;
                    {
                        this.regen = new CapabilityRegeneration((EntityPlayer)event.getObject());
                        this.regenInstance = LazyOptional.of(() -> this.regen);
                    }

                    public NBTTagCompound serializeNBT() {
                        return this.regen.serializeNBT();
                    }

                    public void deserializeNBT(NBTTagCompound nbt) {
                        this.regen.deserializeNBT(nbt);
                    }

                    @Nullable
                    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                        if (capability == CapabilityRegeneration.CAPABILITY) {
                            return this.regenInstance;
                        }
                        return LazyOptional.empty();
                    }
                });
            }
        }
    }
}

