/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.handlers;

import java.util.ArrayList;
import java.util.List;
import me.suff.regeneration.common.entity.EntityItemOverride;
import me.suff.regeneration.common.entity.EntityLindos;
import me.suff.regeneration.common.item.ItemFobWatch;
import me.suff.regeneration.common.item.ItemLindos;
import me.suff.regeneration.util.RegenDamageSource;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="regeneration", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegenObjects {
    public static List<Item> ITEMS = new ArrayList<Item>();
    public static DamageSource REGEN_DMG_ENERGY_EXPLOSION = new RegenDamageSource("regen_energy");
    public static DamageSource REGEN_DMG_HEALING = new RegenDamageSource("regen_heal");
    public static DamageSource REGEN_DMG_CRITICAL = new RegenDamageSource("regen_crit");
    public static DamageSource REGEN_DMG_FORCED = new RegenDamageSource("forced").func_76359_i();
    public static DamageSource REGEN_DMG_LINDOS = new RegenDamageSource("lindos");

    @SubscribeEvent
    public static void addItems(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RegenObjects.setUpItem(new ItemFobWatch(), "fob_watch"), RegenObjects.setUpItem(new ItemLindos(), "lindos_vial")});
    }

    private static Item setUpItem(Item item, String name) {
        item.setRegistryName("regeneration", name);
        ITEMS.add(item);
        return item;
    }

    @SubscribeEvent
    public static void addSounds(RegistryEvent.Register<SoundEvent> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{RegenObjects.setUpSound("regeneration"), RegenObjects.setUpSound("fob_watch"), RegenObjects.setUpSound("critical_stage"), RegenObjects.setUpSound("heart_beat"), RegenObjects.setUpSound("hand_glow"), RegenObjects.setUpSound("regeneration_2"), RegenObjects.setUpSound("fob_watch_dialogue"), RegenObjects.setUpSound("regeneration_3"), RegenObjects.setUpSound("grace_hum"), RegenObjects.setUpSound("regen_breath")});
    }

    @SubscribeEvent
    public static void addEntities(RegistryEvent.Register<EntityType<?>> event) {
        IForgeRegistry reg = event.getRegistry();
        reg.register((IForgeRegistryEntry)EntityEntries.ITEM_OVERRIDE_ENTITY_TYPE);
        reg.register((IForgeRegistryEntry)EntityEntries.ITEM_LINDOS_TYPE);
    }

    private static SoundEvent setUpSound(String soundName) {
        return (SoundEvent)new SoundEvent(new ResourceLocation("regeneration", soundName)).setRegistryName(soundName);
    }

    public static class EntityEntries {
        public static EntityType ITEM_OVERRIDE_ENTITY_TYPE = EntityType.func_200712_a((String)"regeneration:item_override", (EntityType.Builder)EntityType.Builder.func_201757_a(EntityItemOverride.class, EntityItemOverride::new).tracker(256, 20, false));
        public static EntityType ITEM_LINDOS_TYPE = EntityType.func_200712_a((String)"regeneration:lindos", (EntityType.Builder)EntityType.Builder.func_201757_a(EntityLindos.class, EntityLindos::new).tracker(256, 20, false));
    }

    @ObjectHolder(value="regeneration")
    public static class Sounds {
        public static final SoundEvent FOB_WATCH = null;
        public static final SoundEvent FOB_WATCH_DIALOGUE = null;
        public static final SoundEvent REGENERATION = null;
        public static final SoundEvent REGENERATION_2 = null;
        public static final SoundEvent CRITICAL_STAGE = null;
        public static final SoundEvent HEART_BEAT = null;
        public static final SoundEvent HAND_GLOW = null;
        public static final SoundEvent REGENERATION_3 = null;
        public static final SoundEvent GRACE_HUM = null;
        public static final SoundEvent REGEN_BREATH = null;
    }

    @ObjectHolder(value="regeneration")
    public static class Items {
        public static final Item FOB_WATCH = null;
        public static final Item LINDOS_VIAL = null;
    }
}

