/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.network;

import java.util.UUID;
import java.util.function.Supplier;
import me.suff.regeneration.common.capability.CapabilityRegeneration;
import me.suff.regeneration.util.ClientUtil;
import me.suff.regeneration.util.RegenState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessagePlayRegenerationSound {
    private ResourceLocation sound;
    private UUID playerUUID;

    public MessagePlayRegenerationSound(ResourceLocation sound, UUID playerUUID) {
        this.playerUUID = playerUUID;
        this.sound = sound;
    }

    public static void encode(MessagePlayRegenerationSound message, PacketBuffer buffer) {
        buffer.func_192572_a(message.sound);
        buffer.func_179252_a(message.playerUUID);
    }

    public static MessagePlayRegenerationSound decode(PacketBuffer buffer) {
        return new MessagePlayRegenerationSound(buffer.func_192575_l(), buffer.func_179253_g());
    }

    public static class Handler {
        public static void handle(MessagePlayRegenerationSound message, Supplier<NetworkEvent.Context> ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                EntityPlayer player = Minecraft.func_71410_x().field_71441_e.func_152378_a(message.playerUUID);
                if (player != null) {
                    CapabilityRegeneration.getForPlayer(player).ifPresent(data -> ClientUtil.playSound((Entity)player, message.sound, SoundCategory.PLAYERS, true, () -> !data.getState().equals((Object)RegenState.REGENERATING), 1.0f));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

