/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import me.suff.regeneration.RegenerationMod;
import me.suff.regeneration.Trending;
import me.suff.regeneration.client.skinhandling.ImageFixerLegacy;
import me.suff.regeneration.client.skinhandling.SkinChangingHandler;
import org.apache.commons.io.FileUtils;

public class FileUtil {
    public static void handleDownloads() throws IOException {
        String[] links;
        String PACKS_URL = "https://raw.githubusercontent.com/Suffril/Regeneration/skins/index.json";
        for (String link : links = (String[])RegenerationMod.GSON.fromJson(FileUtil.getJsonFromURL(PACKS_URL), String[].class)) {
            FileUtil.unzipSkinPack(link);
        }
    }

    public static void createDirAndSkins() {
        try {
            FileUtil.createDefaultFolders();
            Trending.downloadTrendingSkins();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createDefaultFolders() throws IOException {
        if (!SkinChangingHandler.SKIN_DIRECTORY.exists()) {
            FileUtils.forceMkdir((File)SkinChangingHandler.SKIN_DIRECTORY);
        }
        if (!SkinChangingHandler.SKIN_DIRECTORY_ALEX.exists()) {
            FileUtils.forceMkdir((File)SkinChangingHandler.SKIN_DIRECTORY_ALEX);
        }
        if (!SkinChangingHandler.SKIN_DIRECTORY_STEVE.exists()) {
            FileUtils.forceMkdir((File)SkinChangingHandler.SKIN_DIRECTORY_STEVE);
        }
        if (Objects.requireNonNull(SkinChangingHandler.SKIN_DIRECTORY_ALEX.list()).length == 0 || Objects.requireNonNull(SkinChangingHandler.SKIN_DIRECTORY_STEVE.list()).length == 0) {
            RegenerationMod.LOG.warn("One of the skin directories is empty, so we're going to fill both.");
            FileUtil.handleDownloads();
        }
    }

    public static void downloadSkinImage(URL url, File file, String filename) throws IOException {
        URLConnection uc = url.openConnection();
        uc.connect();
        uc = url.openConnection();
        uc.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.75 Safari/537.36");
        SkinChangingHandler.SKIN_LOG.info("Downloading Skin from: {}", (Object)url.toString());
        BufferedImage img = ImageIO.read(uc.getInputStream());
        ImageFixerLegacy.convertSkinTo64x64(img);
        if (!file.exists()) {
            file.mkdirs();
        }
        ImageIO.write((RenderedImage)img, "png", new File(file, filename + ".png"));
    }

    public static void doThreadStuff() {
        AtomicBoolean setUp = new AtomicBoolean(true);
        new Thread(() -> {
            while (setUp.get()) {
                try {
                    FileUtil.createDirAndSkins();
                    setUp.set(false);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, "Regeneration Download Daemon").start();
    }

    public static void unzipSkinPack(String url) throws IOException {
        File tempZip = new File(SkinChangingHandler.SKIN_DIRECTORY + "/temp/" + System.currentTimeMillis() + ".zip");
        RegenerationMod.LOG.info("Downloading " + url + " to " + tempZip.getAbsolutePath());
        FileUtils.copyURLToFile((URL)new URL(url), (File)tempZip);
        try (ZipFile file = new ZipFile(tempZip);){
            FileSystem fileSystem = FileSystems.getDefault();
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    Files.createDirectories(fileSystem.getPath(SkinChangingHandler.SKIN_DIRECTORY + File.separator + entry.getName(), new String[0]), new FileAttribute[0]);
                    continue;
                }
                InputStream is = file.getInputStream(entry);
                BufferedInputStream bis = new BufferedInputStream(is);
                String uncompressedFileName = SkinChangingHandler.SKIN_DIRECTORY + File.separator + entry.getName();
                Path uncompressedFilePath = fileSystem.getPath(uncompressedFileName, new String[0]);
                RegenerationMod.LOG.info("Extracting file: " + uncompressedFilePath);
                Files.createFile(uncompressedFilePath, new FileAttribute[0]);
                FileOutputStream fileOutput = new FileOutputStream(uncompressedFileName);
                while (bis.available() > 0) {
                    fileOutput.write(bis.read());
                }
                fileOutput.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (tempZip.exists()) {
            FileUtils.forceDelete((File)tempZip.getParentFile());
        }
    }

    public static String getJsonFromURL(String URL2) {
        URL url = null;
        try {
            url = new URL(URL2);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = FileUtil.bufferedReaderToString(in);
            line = line.replace("<pre>", "");
            line = line.replace("</pre>", "");
            return line;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String bufferedReaderToString(BufferedReader e) {
        StringBuilder builder = new StringBuilder();
        String aux = "";
        try {
            while ((aux = e.readLine()) != null) {
                builder.append(aux);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return builder.toString();
    }
}

