/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.util;

import java.util.Random;
import me.suff.regeneration.RegenConfig;
import me.suff.regeneration.handlers.RegenObjects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RegenUtil {
    static Random rand = new Random();

    public static <T extends Enum<?>> T randomEnum(Class<T> clazz) {
        int x = rand.nextInt(((Enum[])clazz.getEnumConstants()).length);
        return (T)((Enum[])clazz.getEnumConstants())[x];
    }

    public static float randFloat(float min, float max) {
        return rand.nextFloat() * (max - min) + min;
    }

    public static void genCrater(World world, BlockPos pos, int radius) {
        for (int x = pos.func_177958_n() - radius; x < pos.func_177958_n() + radius; ++x) {
            for (int y = pos.func_177956_o() - radius; y < pos.func_177956_o() + radius; ++y) {
                for (int z = pos.func_177952_p() - radius; z < pos.func_177952_p() + radius; ++z) {
                    IBlockState block;
                    double squareDistance = Math.pow(x - pos.func_177958_n(), 2.0) + Math.pow(y - pos.func_177956_o(), 2.0) + Math.pow(z - pos.func_177952_p(), 2.0);
                    if (!(squareDistance <= Math.pow(radius, 2.0)) || (block = world.func_180495_p(new BlockPos(x, y, z))).func_177230_c() == Blocks.field_150357_h) continue;
                    BlockPos blockPos = new BlockPos(x, y, z);
                    if (!(block.func_185887_b((IBlockReader)world, blockPos) < 3.0f)) continue;
                    if (!world.field_72995_K) {
                        TileEntity tileEntity;
                        if (world.func_175625_s(new BlockPos(x, y, z)) != null && (tileEntity = world.func_175625_s(new BlockPos(x, y, z))) instanceof IInventory) {
                            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
                            world.func_175666_e(pos, block.func_177230_c());
                        }
                        InventoryHelper.func_180173_a((World)world, (double)x, (double)y, (double)z, (ItemStack)new ItemStack((IItemProvider)block.func_177230_c()));
                    }
                    world.func_175656_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    public static void regenerationExplosion(EntityPlayer player) {
        RegenUtil.explodeKnockback((Entity)player, player.field_70170_p, player.func_180425_c(), (Double)RegenConfig.COMMON.regenerativeKnockback.get(), (Integer)RegenConfig.COMMON.regenKnockbackRange.get());
        RegenUtil.explodeKill((Entity)player, player.field_70170_p, player.func_180425_c(), (Integer)RegenConfig.COMMON.regenerativeKillRange.get());
    }

    public static void explodeKnockback(Entity exploder, World world, BlockPos pos, Double knockback, int range) {
        world.func_72839_b(exploder, RegenUtil.getReach(pos, range)).forEach(entity -> {
            if (entity instanceof EntityLivingBase && exploder.func_70089_S()) {
                EntityLivingBase victim = (EntityLivingBase)entity;
                if (entity instanceof EntityPlayer && !((Boolean)RegenConfig.COMMON.regenerationKnocksbackPlayers.get()).booleanValue()) {
                    return;
                }
                float densMod = world.func_72842_a(new Vec3d((Vec3i)pos), entity.func_174813_aQ());
                int xr = (int)(-(victim.field_70165_t - exploder.field_70165_t));
                int zr = (int)(-(victim.field_70161_v - exploder.field_70161_v));
                victim.func_70653_a(exploder, (float)(knockback * (double)densMod), (double)xr, (double)zr);
            }
        });
    }

    public static void explodeKill(Entity exploder, World world, BlockPos pos, int range) {
        world.func_72839_b(exploder, RegenUtil.getReach(pos, range)).forEach(entity -> {
            if (entity instanceof EntityCreature && entity.func_184222_aU() || entity instanceof EntityPlayer && ((Boolean)RegenConfig.COMMON.regenKillsPlayers.get()).booleanValue()) {
                entity.func_70097_a(RegenObjects.REGEN_DMG_ENERGY_EXPLOSION, Float.MAX_VALUE);
            }
        });
    }

    public static AxisAlignedBB getReach(BlockPos pos, int range) {
        return new AxisAlignedBB(pos.func_177981_b(range).func_177964_d(range).func_177985_f(range), pos.func_177979_c(range).func_177970_e(range).func_177965_g(range));
    }

    public static interface IEnum<E extends Enum<E>> {
        public int ordinal();

        default public E next() {
            Enum[] ies = this.getAllValues();
            return (E)(this.ordinal() != ies.length - 1 ? ies[this.ordinal() + 1] : null);
        }

        default public E previous() {
            return (E)(this.ordinal() != 0 ? this.getAllValues()[this.ordinal() - 1] : null);
        }

        default public E[] getAllValues() {
            IEnum[] ies = (IEnum[])this.getClass().getEnumConstants();
            return (Enum[])ies;
        }
    }
}

