/*
 * Decompiled with CFR 0.152.
 */
package me.suff.regeneration.util;

import java.nio.FloatBuffer;
import java.util.List;
import me.suff.regeneration.client.rendering.model.ModelArmorOverride;
import me.suff.regeneration.util.RegenState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.ModelBase;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.lwjgl.opengl.GL11;

public class RenderUtil {
    private static final ResourceLocation VIGNETTE_TEX_PATH = new ResourceLocation("regeneration", "textures/misc/vignette.png");
    public static float renderTick = Minecraft.func_71410_x().func_184121_ak();
    private static float lastBrightnessX = OpenGlHelper.lastBrightnessX;
    private static float lastBrightnessY = OpenGlHelper.lastBrightnessY;

    public static void setLightmapTextureCoords(float x, float y) {
        lastBrightnessX = OpenGlHelper.lastBrightnessX;
        lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)x, (float)y);
    }

    public static void restoreLightMap() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static void drawGlowingLine(Vec3d start, Vec3d end, float thickness, Vec3d color, float alpha) {
        if (start == null || end == null) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bb = tessellator.func_178180_c();
        int smoothFactor = Minecraft.func_71410_x().field_71474_y.field_74348_k;
        int layers = 10 + smoothFactor * 20;
        GlStateManager.func_179094_E();
        start = start.func_186678_a(-1.0);
        end = end.func_186678_a(-1.0);
        GlStateManager.func_179137_b((double)(-start.field_72450_a), (double)(-start.field_72448_b), (double)(-start.field_72449_c));
        start = end.func_178788_d(start);
        end = end.func_178788_d(end);
        double x = end.field_72450_a - start.field_72450_a;
        double y = end.field_72448_b - start.field_72448_b;
        double z = end.field_72449_c - start.field_72449_c;
        double diff = MathHelper.func_76133_a((double)(x * x + z * z));
        float yaw = (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(y, diff) * 180.0 / Math.PI));
        GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        for (int layer = 0; layer <= layers; ++layer) {
            if (layer < layers) {
                GlStateManager.func_179131_c((float)((float)color.field_72450_a), (float)((float)color.field_72448_b), (float)((float)color.field_72449_c), (float)(1.0f / (float)layers / 2.0f));
                GlStateManager.func_179132_a((boolean)false);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GlStateManager.func_179132_a((boolean)true);
            }
            double size = (double)thickness + (layer < layers ? (double)layer * (1.25 / (double)layers) : 0.0);
            double d = (layer < layers ? 1.0 - (double)layer * (1.0 / (double)layers) : 0.0) * 0.1;
            double width = 0.0625 * size;
            double height = 0.0625 * size;
            double length = start.func_72438_d(end) + d;
            bb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            bb.func_181662_b(-width, height, length).func_181675_d();
            bb.func_181662_b(width, height, length).func_181675_d();
            bb.func_181662_b(width, height, -d).func_181675_d();
            bb.func_181662_b(-width, height, -d).func_181675_d();
            bb.func_181662_b(width, -height, -d).func_181675_d();
            bb.func_181662_b(width, -height, length).func_181675_d();
            bb.func_181662_b(-width, -height, length).func_181675_d();
            bb.func_181662_b(-width, -height, -d).func_181675_d();
            bb.func_181662_b(-width, -height, -d).func_181675_d();
            bb.func_181662_b(-width, -height, length).func_181675_d();
            bb.func_181662_b(-width, height, length).func_181675_d();
            bb.func_181662_b(-width, height, -d).func_181675_d();
            bb.func_181662_b(width, height, length).func_181675_d();
            bb.func_181662_b(width, -height, length).func_181675_d();
            bb.func_181662_b(width, -height, -d).func_181675_d();
            bb.func_181662_b(width, height, -d).func_181675_d();
            bb.func_181662_b(width, -height, length).func_181675_d();
            bb.func_181662_b(width, height, length).func_181675_d();
            bb.func_181662_b(-width, height, length).func_181675_d();
            bb.func_181662_b(-width, -height, length).func_181675_d();
            bb.func_181662_b(width, -height, -d).func_181675_d();
            bb.func_181662_b(width, height, -d).func_181675_d();
            bb.func_181662_b(-width, height, -d).func_181675_d();
            bb.func_181662_b(-width, -height, -d).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179121_F();
    }

    public static void setupRenderLightning() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)GlStateManager.SourceFactor.SRC_ALPHA.field_187395_p, (int)GlStateManager.SourceFactor.ONE_MINUS_CONSTANT_ALPHA.field_187395_p);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        RenderUtil.setLightmapTextureCoords(240.0f, 240.0f);
    }

    public static void finishRenderLightning() {
        RenderUtil.restoreLightMap();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public static void drawRect(int left, int top, int right, int bottom, float red, float green, float blue, float alpha) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void renderVignette(Vec3d color, float a, RegenState state) {
        GlStateManager.func_179131_c((float)((float)color.field_72450_a), (float)((float)color.field_72448_b), (float)((float)color.field_72449_c), (float)a);
        GlStateManager.func_179118_c();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(VIGNETTE_TEX_PATH);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        MainWindow scaledRes = Minecraft.func_71410_x().field_195558_d;
        int z = -89;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(0.0, (double)scaledRes.func_198083_n(), (double)z).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)scaledRes.func_198105_m(), (double)scaledRes.func_198083_n(), (double)z).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)scaledRes.func_198105_m(), 0.0, (double)z).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, (double)z).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static double calculateColorBrightness(Vec3d c) {
        float r = (float)c.field_72450_a;
        float g = (float)c.field_72448_b;
        float b = (float)c.field_72449_c;
        r = (double)r <= 0.03928 ? r / 12.92f : (float)Math.pow(((double)r + 0.055) / 1.055, 2.4);
        g = (double)g <= 0.03928 ? g / 12.92f : (float)Math.pow(((double)g + 0.055) / 1.055, 2.4);
        b = (double)b <= 0.03928 ? b / 12.92f : (float)Math.pow(((double)b + 0.055) / 1.055, 2.4);
        return 0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b;
    }

    public static void drawModelToGui(ModelBase model, int xPos, int yPos, float scalef, float rotation) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GL11.glBlendFunc((int)770, (int)771);
        GlStateManager.func_179109_b((float)xPos, (float)yPos, (float)100.0f);
        GlStateManager.func_179114_b((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74520_c();
        GlStateManager.func_187424_a((int)2899, (FloatBuffer)RenderHelper.func_74521_a((float)0.75f, (float)0.75f, (float)0.75f, (float)1.0f));
        GlStateManager.func_179152_a((float)(38.0f * scalef), (float)(34.0f * scalef), (float)(38.0f * scalef));
        GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)1.0f);
        model.func_78088_a((Entity)Minecraft.func_71410_x().field_71439_g, 0.0f, 0.0f, (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa, 0.0f, 0.0f, 0.0625f);
        RenderHelper.func_74518_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179097_i();
        GlStateManager.func_179121_F();
    }

    public static void setupArmorModelOverride(RenderPlayer renderPlayer) {
        LayerRenderer armorLayer;
        List layers = (List)ObfuscationReflectionHelper.getPrivateValue(RenderLivingBase.class, (Object)renderPlayer, (int)4);
        if (layers != null && (armorLayer = (LayerRenderer)layers.stream().filter(layer -> layer instanceof LayerBipedArmor).findFirst().orElse(null)) != null) {
            LayerBipedArmor bipedArmor = (LayerBipedArmor)armorLayer;
            ModelArmorOverride armorOverride = new ModelArmorOverride();
            ObfuscationReflectionHelper.setPrivateValue(LayerArmorBase.class, (Object)bipedArmor, (Object)((Object)armorOverride), (int)1);
            ObfuscationReflectionHelper.setPrivateValue(LayerArmorBase.class, (Object)bipedArmor, (Object)((Object)armorOverride), (int)2);
        }
    }
}

