/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.PlayerHandle;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.storage.BlockRestrictionsStorage;
import gollorum.signpost.minecraft.utils.ClientFrameworkAdapter;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.networking.ReflectionEvent;
import gollorum.signpost.networking.SerializedWith;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.serialization.BooleanSerializer;
import gollorum.signpost.utils.serialization.IntSerializer;
import gollorum.signpost.utils.serialization.StringSerializer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class BlockRestrictions {
    private static BlockRestrictions instance;
    private WorldSavedData savedData = null;
    private final Map<PlayerHandle, Entry> values = new HashMap<PlayerHandle, Entry>();

    public static BlockRestrictions getInstance() {
        return instance;
    }

    public boolean hasStorageBeenSetup() {
        return this.savedData != null;
    }

    public static void initialize() {
        instance = new BlockRestrictions();
    }

    private BlockRestrictions() {
    }

    public void setupStorage(ServerWorld world) {
        DimensionSavedDataManager storage = world.func_217481_x();
        this.savedData = storage.func_215752_a(BlockRestrictionsStorage::new, "signpost_BlockRestrictions");
    }

    private Entry getEntry(PlayerHandle player) {
        return this.values.computeIfAbsent(player, Entry::forNewUser);
    }

    public boolean setRemaining(Type type, PlayerHandle player, Function<Integer, Integer> count) {
        int newCount;
        int oldCount;
        if (player.equals(PlayerHandle.Invalid)) {
            return true;
        }
        Entry entry = this.getEntry(player);
        switch (type) {
            case Signpost: {
                oldCount = entry.signpostsLeft;
                newCount = entry.signpostsLeft = count.apply(oldCount).intValue();
                break;
            }
            case Waystone: {
                oldCount = entry.waystonesLeft;
                newCount = entry.waystonesLeft = count.apply(oldCount).intValue();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (oldCount != newCount) {
            this.markDirty();
            return true;
        }
        return false;
    }

    public void incrementRemaining(Type type, PlayerHandle player) {
        if (player.equals(PlayerHandle.Invalid)) {
            return;
        }
        Entry entry = this.getEntry(player);
        int prevCount = type.getCount.apply(entry);
        if (prevCount >= 0) {
            type.setCount.accept(entry, prevCount + 1);
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player.asEntity()), new NotifyCountChanged(type.remainingLangKey, prevCount + 1, type == Type.Waystone));
        }
    }

    public boolean tryDecrementRemaining(Type type, PlayerHandle player) {
        if (player.equals(PlayerHandle.Invalid)) {
            return true;
        }
        Entry entry = this.getEntry(player);
        int prevCount = type.getCount.apply(entry);
        if (prevCount >= 1) {
            type.setCount.accept(entry, prevCount - 1);
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player.asEntity()), new NotifyCountChanged(type.remainingLangKey, prevCount - 1, type == Type.Waystone));
            return true;
        }
        if (prevCount == 0) {
            player.asEntity().func_145747_a((ITextComponent)new TranslationTextComponent(type.errorLangKey, new Object[0]));
        }
        return prevCount < 0;
    }

    public boolean hasRemaining(Type type, PlayerHandle player) {
        int remaining;
        if (player.equals(PlayerHandle.Invalid)) {
            return true;
        }
        Entry entry = this.getEntry(player);
        switch (type) {
            case Waystone: {
                remaining = entry.waystonesLeft;
                break;
            }
            case Signpost: {
                remaining = entry.signpostsLeft;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return remaining != 0;
    }

    public int getRemaining(Type type, PlayerHandle player) {
        int remaining;
        if (player.equals(PlayerHandle.Invalid)) {
            return -1;
        }
        Entry entry = this.getEntry(player);
        switch (type) {
            case Waystone: {
                remaining = entry.waystonesLeft;
                break;
            }
            case Signpost: {
                remaining = entry.signpostsLeft;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return remaining;
    }

    private void markDirty() {
        if (this.savedData != null) {
            this.savedData.func_76185_a();
        }
    }

    public CompoundNBT saveTo(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        list.addAll((Collection)this.values.entrySet().stream().map(e -> {
            CompoundNBT elementComp = new CompoundNBT();
            PlayerHandle.Serializer.write((PlayerHandle)e.getKey(), elementComp);
            elementComp.func_74768_a("remaining_waystones", ((Entry)e.getValue()).waystonesLeft);
            elementComp.func_74768_a("remaining_signposts", ((Entry)e.getValue()).signpostsLeft);
            return elementComp;
        }).collect(Collectors.toSet()));
        compound.func_218657_a("blockRestrictions", (INBT)list);
        return compound;
    }

    public void readFrom(CompoundNBT compound) {
        INBT nbt = compound.func_74781_a("blockRestrictions");
        if (nbt instanceof ListNBT) {
            ListNBT list = (ListNBT)nbt;
            this.values.clear();
            this.values.putAll(list.stream().map(i -> {
                CompoundNBT elementCompound = (CompoundNBT)i;
                return Tuple.of(PlayerHandle.Serializer.read(elementCompound), new Entry(elementCompound.func_74762_e("remaining_waystones"), elementCompound.func_74762_e("remaining_signposts")));
            }).collect(Tuple.mapCollector()));
        }
    }

    public static class NotifyCountChanged
    extends ReflectionEvent<NotifyCountChanged> {
        @SerializedWith(serializer=StringSerializer.class)
        private String langKey;
        @SerializedWith(serializer=IntSerializer.class)
        private Integer count;
        @SerializedWith(serializer=BooleanSerializer.class)
        private Boolean IsWaystoneNotification;

        public NotifyCountChanged() {
        }

        public NotifyCountChanged(String langKey, Integer count, boolean isWaystoneNotification) {
            super(null);
            this.langKey = langKey;
            this.count = count;
            this.IsWaystoneNotification = isWaystoneNotification;
        }

        @Override
        public Class<NotifyCountChanged> getMessageClass() {
            return NotifyCountChanged.class;
        }

        @Override
        public void handle(NotifyCountChanged message, NetworkEvent.Context context) {
            if (((Boolean)(message.IsWaystoneNotification != false ? Config.Client.enableWaystoneLimitNotifications : Config.Client.enableSignpostLimitNotifications).get()).booleanValue()) {
                ClientFrameworkAdapter.showStatusMessage(new TranslationTextComponent(message.langKey, new Object[]{message.count}), true);
            }
        }
    }

    private static class Entry {
        public int waystonesLeft;
        public int signpostsLeft;

        public Entry(int waystonesLeft, int signpostsLeft) {
            this.waystonesLeft = waystonesLeft;
            this.signpostsLeft = signpostsLeft;
        }

        public static Entry forNewUser(PlayerHandle player) {
            return player.equals(PlayerHandle.Invalid) ? new Entry(-1, -1) : new Entry((Integer)Config.Server.permissions.defaultMaxWaystonesPerPlayer.get(), (Integer)Config.Server.permissions.defaultMaxSignpostsPerPlayer.get());
        }
    }

    public static enum Type {
        Waystone(() -> Config.Server.permissions.defaultMaxWaystonesPerPlayer, (e, i) -> {
            e.waystonesLeft = i;
        }, e -> e.waystonesLeft, "signpost.no_more_waystones", "signpost.waystones_left", "signpost.unlimited_waystones", "signpost.waystones_left_other", "signpost.unlimited_waystones_other", o -> o instanceof WithOwner.OfWaystone ? ((WithOwner.OfWaystone)o).getWaystoneOwner() : Optional.empty()),
        Signpost(() -> Config.Server.permissions.defaultMaxSignpostsPerPlayer, (e, i) -> {
            e.signpostsLeft = i;
        }, e -> e.signpostsLeft, "signpost.no_more_signposts", "signpost.signposts_left", "signpost.unlimited_signposts", "signpost.signposts_left_other", "signpost.unlimited_signposts_other", o -> o instanceof WithOwner.OfSignpost ? ((WithOwner.OfSignpost)o).getSignpostOwner() : Optional.empty());

        final Supplier<ForgeConfigSpec.ConfigValue<Integer>> getOverridePermissionLevel;
        final BiConsumer<Entry, Integer> setCount;
        final Function<Entry, Integer> getCount;
        public final String errorLangKey;
        public final String remainingLangKey;
        public final String unlimitedRemainingLangKey;
        public final String remainingLangKeyOther;
        public final String unlimitedRemainingLangKeyOther;
        public final Function<Object, Optional<PlayerHandle>> tryGetOwner;

        public TranslationTextComponent getRemainingTextComponent(int count, Optional<ITextComponent> subject) {
            return subject.map(s -> new TranslationTextComponent(this.remainingLangKeyOther, new Object[]{count, s})).orElseGet(() -> new TranslationTextComponent(this.remainingLangKey, new Object[]{count}));
        }

        public TranslationTextComponent getUnlimitedRemainingTextComponent(Optional<ITextComponent> subject) {
            return subject.map(s -> new TranslationTextComponent(this.unlimitedRemainingLangKeyOther, new Object[]{s})).orElseGet(() -> new TranslationTextComponent(this.unlimitedRemainingLangKey, new Object[0]));
        }

        private Type(Supplier<ForgeConfigSpec.ConfigValue<Integer>> overridePermissionLevelSupplier, BiConsumer<Entry, Integer> setCount, Function<Entry, Integer> getCount, String errorLangKey, String remainingLangKey, String unlimitedRemainingLangKey, String remainingLangKeyOther, String unlimitedRemainingLangKeyOther, Function<Object, Optional<PlayerHandle>> tryGetOwner) {
            this.getOverridePermissionLevel = overridePermissionLevelSupplier;
            this.setCount = (e, i) -> {
                setCount.accept((Entry)e, (Integer)i);
                BlockRestrictions.getInstance().markDirty();
            };
            this.getCount = getCount;
            this.errorLangKey = errorLangKey;
            this.remainingLangKey = remainingLangKey;
            this.unlimitedRemainingLangKey = unlimitedRemainingLangKey;
            this.remainingLangKeyOther = remainingLangKeyOther;
            this.unlimitedRemainingLangKeyOther = unlimitedRemainingLangKeyOther;
            this.tryGetOwner = tryGetOwner;
        }
    }
}

